/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.parser;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartContainer;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.soap.AbstractSoapBinding;
import org.codehaus.xfire.soap.Soap11Binding;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl11.parser.BindingAnnotator;
import org.codehaus.xfire.wsdl11.parser.DefinitionsHelper;

public class SoapBindingAnnotator
extends BindingAnnotator {
    private AbstractSoapBinding soapBinding;
    private boolean useSet = false;

    protected org.codehaus.xfire.service.Binding getBinding() {
        return this.soapBinding;
    }

    public AbstractSoapBinding getSoapBinding() {
        return this.soapBinding;
    }

    public void setSoapBinding(AbstractSoapBinding soapBinding) {
        this.soapBinding = soapBinding;
    }

    protected void visit(Binding wbinding) {
        SOAPBinding sbind = DefinitionsHelper.getSOAPBinding(wbinding);
        this.soapBinding = new Soap11Binding(wbinding.getQName(), sbind.getTransportURI(), this.getService());
        this.getService().addBinding(this.soapBinding);
        this.soapBinding.setStyle(null);
        this.setStyle(sbind.getStyle());
    }

    protected void visit(BindingFault bindingFault, Fault fault, FaultInfo msg) {
        this.visitMessage(msg, bindingFault.getExtensibilityElements());
    }

    protected void visit(BindingInput bindingInput, Input input, MessageInfo msg) {
        this.visitMessage(msg, bindingInput.getExtensibilityElements());
    }

    private void visitMessage(MessagePartContainer msg, List ext) {
        Iterator itr = ext.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (o instanceof SOAPBody) {
                SOAPBody body = (SOAPBody)o;
                this.setUse(msg, body.getUse());
                continue;
            }
            if (!(o instanceof SOAPHeader)) continue;
            SOAPHeader header = (SOAPHeader)o;
            QName msgName = header.getMessage();
            Message hmsg = this.getDefinition().getMessage(msgName);
            Part part = hmsg.getPart(header.getPart());
            QName name = part.getElementName();
            if (name == null) {
                name = part.getTypeName();
            }
            SchemaType st = this.getBindingProvider().getSchemaType(name, this.getService());
            MessagePartInfo info = this.getSoapBinding().getHeaders((MessageInfo)msg).addMessagePart(name, null);
            info.setSchemaType(st);
        }
    }

    protected void visit(BindingOperation operation, OperationInfo opInfo) {
        SOAPOperation soapOp = DefinitionsHelper.getSOAPOperation(operation);
        AbstractSoapBinding binding = this.getSoapBinding();
        binding.setSoapAction(opInfo, soapOp.getSoapActionURI());
        String style = soapOp.getStyle();
        if (style != null) {
            this.setStyle(style);
        }
        binding.setSerializer(opInfo, AbstractSoapBinding.getSerializer(binding.getStyle(), binding.getUse()));
    }

    protected void setStyle(String style) {
        String current;
        if (this.getService().getServiceInfo().isWrapped()) {
            style = "wrapped";
        }
        if ((current = this.getSoapBinding().getStyle()) == null) {
            this.getSoapBinding().setStyle(style);
        } else if (!current.equals(style)) {
            throw new XFireRuntimeException("Multiple styles not supported at this time.");
        }
    }

    protected void setUse(MessagePartContainer msg, String use) {
        String current = this.getSoapBinding().getUse();
        if (!this.useSet) {
            this.getSoapBinding().setUse(use);
            this.useSet = true;
        } else if (!current.equals(use)) {
            throw new XFireRuntimeException("Multiple uses not supported at this time.");
        }
    }

    protected void visit(BindingOutput bindingOutput, Output output, MessageInfo msg) {
        this.visitMessage(msg, bindingOutput.getExtensibilityElements());
    }

    protected boolean isUnderstood(Binding op) {
        SOAPBinding ee = DefinitionsHelper.getSOAPBinding(op);
        return ee != null;
    }

    protected void visit(Port port) {
        SOAPAddress add = DefinitionsHelper.getSOAPAddress(port);
        SOAPBinding sbind = DefinitionsHelper.getSOAPBinding(port.getBinding());
        org.codehaus.xfire.service.Binding binding = this.getService().getBinding(port.getBinding().getQName());
        if (binding != null) {
            Endpoint ep = new Endpoint(new QName(this.getService().getTargetNamespace(), port.getName()), binding, add.getLocationURI());
            this.getService().addEndpoint(ep);
        }
    }
}

