/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.client.ClientFaultConverter;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandlerSupport;
import org.codehaus.xfire.handler.HandlerPipeline;
import org.codehaus.xfire.handler.OutMessageSender;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ServiceInvocationHandler;
import org.codehaus.xfire.soap.AbstractSoapBinding;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.ChannelEndpoint;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.wsdl11.parser.WSDLServiceBuilder;
import org.xml.sax.InputSource;

public class Client
extends AbstractHandlerSupport
implements ChannelEndpoint {
    private static final Log log = LogFactory.getLog((Class)Client.class);
    public static final String CLIENT_MODE = "client.mode";
    private Object[] response;
    private Channel channel;
    private Transport transport;
    private Service service;
    private Binding binding;
    private String url;
    private int timeout = 10000;
    private MessageContext context;
    private Exception fault;
    private String endpointUri;
    private XFire xfire = XFireFactory.newInstance().getXFire();

    protected Client() {
        this.addOutHandler(new OutMessageSender());
        this.addFaultHandler(new ClientFaultConverter());
    }

    public Client(Transport t, Endpoint endpoint) {
        this(endpoint.getBinding(), t, endpoint.getBinding().getService(), endpoint.getUrl(), null);
    }

    public Client(Binding binding, String url) {
        this(binding, XFireFactory.newInstance().getXFire().getTransportManager().getTransport(binding.getBindingId()), binding.getService(), url, null);
    }

    public Client(Transport t, Binding binding, String url) {
        this(binding, t, binding.getService(), url, null);
    }

    public Client(Transport transport, Service service, String url) {
        this(transport, service, url, null);
    }

    public Client(Transport transport, Service service, String url, String endpointUri) {
        this();
        this.transport = transport;
        this.url = url;
        this.endpointUri = endpointUri;
        this.setService(service);
        this.binding = this.findBinding(transport, service);
    }

    public Client(Binding binding, Transport transport, Service service, String url, String endpointUri) {
        this();
        this.transport = transport;
        this.url = url;
        this.endpointUri = endpointUri;
        this.setService(service);
        this.binding = binding;
    }

    public Client(Definition definition, Class serviceClass) throws Exception {
        this();
        this.initFromDefinition("http://schemas.xmlsoap.org/soap/http", definition, serviceClass);
    }

    public Client(String binding, Definition definition, Class serviceClass) throws Exception {
        this();
        this.initFromDefinition(binding, definition, serviceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client(InputStream is, Class serviceClass) throws Exception {
        this();
        try {
            InputSource src = new InputSource(is);
            Definition def = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, src);
            this.initFromDefinition("http://schemas.xmlsoap.org/soap/http", def, serviceClass);
        }
        finally {
            is.close();
        }
    }

    public Client(URL wsdlLocation) throws Exception {
        this(wsdlLocation.openStream(), null);
    }

    public Client(URL wsdlLocation, Class serviceClass) throws Exception {
        this(wsdlLocation.openStream(), serviceClass);
    }

    private void setService(Service service) {
        this.service = service;
        this.service.setFaultSerializer(service.getFaultSerializer());
    }

    protected void initFromDefinition(String binding, Definition definition, Class serviceClass) throws Exception {
        WSDLServiceBuilder builder = new WSDLServiceBuilder(definition);
        builder.setTransportManager(this.xfire.getTransportManager());
        builder.build();
        Endpoint ep = this.findEndpoint(binding, builder.getAllServices());
        this.url = ep.getUrl();
        this.binding = ep.getBinding();
        this.transport = this.getXFire().getTransportManager().getTransport(binding);
        if (serviceClass != null) {
            ep.getBinding().getService().getServiceInfo().setServiceClass(serviceClass);
        }
        this.setService(ep.getBinding().getService());
    }

    public Endpoint findEndpoint(String binding, Collection services) {
        Iterator itr = services.iterator();
        while (itr.hasNext()) {
            Service service = (Service)itr.next();
            Iterator eitr = service.getEndpoints().iterator();
            while (eitr.hasNext()) {
                Endpoint ep = (Endpoint)eitr.next();
                if (!ep.getBinding().getBindingId().equals(binding)) continue;
                return ep;
            }
        }
        return null;
    }

    private Binding findBinding(Transport transport, Service service) {
        String[] ids = transport.getSupportedBindings();
        for (int i = 0; i < ids.length; ++i) {
            Binding b = service.getBinding(ids[i]);
            if (b == null) continue;
            return b;
        }
        return this.findSoapBinding(service);
    }

    private AbstractSoapBinding findSoapBinding(Service service) {
        Iterator itr = service.getBindings().iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof AbstractSoapBinding)) continue;
            return (AbstractSoapBinding)o;
        }
        return null;
    }

    public Object[] invoke(OperationInfo op, Object[] params) throws Exception {
        try {
            OutMessage msg = new OutMessage(this.url);
            msg.setBody(params);
            msg.setChannel(this.getOutChannel());
            this.context = new MessageContext();
            this.context.setService(this.service);
            this.context.setXFire(this.xfire);
            this.context.setBinding(this.binding);
            this.context.setProperty(CLIENT_MODE, Boolean.TRUE);
            this.context.setClient(this);
            MessageExchange exchange = new MessageExchange(this.context);
            exchange.setOperation(op);
            exchange.setOutMessage(msg);
            this.context.setCurrentMessage(msg);
            HandlerPipeline outPipe = new HandlerPipeline(this.xfire.getOutPhases());
            outPipe.addHandlers(this.xfire.getOutHandlers());
            outPipe.addHandlers(this.getOutHandlers());
            outPipe.addHandlers(this.transport.getOutHandlers());
            this.context.setOutPipeline(outPipe);
            ServiceInvocationHandler.writeHeaders(this.context);
            outPipe.invoke(this.context);
        }
        catch (Exception e1) {
            throw XFireFault.createFault(e1);
        }
        this.waitForResponse();
        if (this.fault != null) {
            Exception localFault = this.fault;
            this.fault = null;
            throw localFault;
        }
        Object[] localResponse = this.response;
        this.response = null;
        return localResponse;
    }

    public Object[] invoke(String name, Object[] params) throws Exception {
        OperationInfo op = this.service.getServiceInfo().getOperation(name);
        if (op == null) {
            throw new XFireRuntimeException("Could not find operation with name " + name);
        }
        return this.invoke(op, params);
    }

    protected void waitForResponse() {
        if (!this.getOutChannel().isAsync() || this.response != null && this.fault != null && !this.context.getExchange().getOperation().hasOutput()) {
            return;
        }
        for (int count = 0; this.response == null && this.fault == null && count < this.timeout; count += 50) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void onReceive(MessageContext recvContext, InMessage msg) {
        MessageExchange exchange;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received message to " + msg.getUri()));
        }
        if (this.context.getExchange() == null) {
            new MessageExchange(this.context);
        }
        if (!(exchange = this.context.getExchange()).getOperation().hasOutput()) {
            return;
        }
        exchange.setInMessage(msg);
        this.context.setCurrentMessage(msg);
        try {
            HandlerPipeline inPipe = new HandlerPipeline(this.xfire.getInPhases());
            inPipe.addHandlers(this.getInHandlers());
            inPipe.addHandlers(this.transport.getInHandlers());
            recvContext.setInPipeline(inPipe);
            inPipe.invoke(this.context);
            MessageInfo msgInfo = exchange.getOperation().getOutputMessage();
            ServiceInvocationHandler.readHeaders(this.context, this.binding.getHeaders(msgInfo), (Object[])this.context.getOutMessage().getBody());
            this.finishReadingMessage(msg, this.context);
            this.response = ((List)msg.getBody()).toArray();
        }
        catch (Exception e1) {
            XFireFault fault = XFireFault.createFault(e1);
            AbstractMessage faultMsg = this.context.getExchange().getFaultMessage();
            faultMsg.setBody(fault);
            HandlerPipeline inPipe = new HandlerPipeline(this.xfire.getFaultPhases());
            inPipe.addHandlers(this.getFaultHandlers());
            inPipe.addHandlers(this.transport.getFaultHandlers());
            try {
                inPipe.invoke(this.context);
                this.fault = (Exception)faultMsg.getBody();
            }
            catch (Exception e) {
                this.fault = e;
            }
        }
    }

    public void finishReadingMessage(InMessage message, MessageContext context) throws XFireFault {
        XMLStreamReader reader = message.getXMLStreamReader();
        try {
            while (reader.hasNext()) {
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Couldn't parse message.", e, XFireFault.SENDER);
        }
    }

    public Channel getOutChannel() {
        if (this.channel != null) {
            return this.channel;
        }
        try {
            String uri = this.getEndpointUri();
            this.channel = uri == null ? this.getTransport().createChannel() : this.getTransport().createChannel(uri);
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't open channel.", e);
        }
        this.channel.setEndpoint(this);
        return this.channel;
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public void receive(Object response) {
        this.response = ((List)response).toArray();
    }

    public Service getService() {
        return this.service;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public XFire getXFire() {
        return this.xfire;
    }

    public void setXFire(XFire xfire) {
        this.xfire = xfire;
    }
}

