/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.handler.HandlerPipeline;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Channel;

public class DefaultFaultHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog((Class)DefaultFaultHandler.class);
    public static final String EXCEPTION = "exception";

    public void invoke(MessageContext context) throws Exception {
        Exception e = (Exception)context.getProperty(EXCEPTION);
        if (e instanceof RuntimeException) {
            log.error((Object)"Fault occurred!", (Throwable)e);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Fault occurred!", (Throwable)e);
        }
        XFireFault fault = XFireFault.createFault(e);
        Service service = context.getService();
        if (service == null || service.getFaultSerializer() == null || !context.getExchange().hasFaultMessage()) {
            this.sendToDeadLetter(fault, context);
        } else {
            this.sendFault(fault, context);
        }
    }

    protected void sendToDeadLetter(XFireFault fault, MessageContext context) {
        log.error((Object)"Could not find service.", (Throwable)fault);
    }

    protected void sendFault(XFireFault fault, MessageContext context) {
        OutMessage outMsg = (OutMessage)context.getExchange().getFaultMessage();
        outMsg.setSerializer(context.getService().getFaultSerializer());
        outMsg.setBody(fault);
        context.setCurrentMessage(outMsg);
        HandlerPipeline faultPipe = new HandlerPipeline(context.getXFire().getFaultPhases());
        faultPipe.addHandlers(context.getXFire().getFaultHandlers());
        Channel faultChannel = context.getExchange().getFaultMessage().getChannel();
        if (faultChannel != null) {
            faultPipe.addHandlers(faultChannel.getTransport().getFaultHandlers());
        }
        if (context.getService() != null) {
            faultPipe.addHandlers(context.getService().getFaultHandlers());
        }
        try {
            faultPipe.invoke(context);
        }
        catch (Exception e1) {
            XFireFault fault2 = XFireFault.createFault(e1);
            faultPipe.handleFault(fault2, context);
            log.error((Object)"Could not send fault.", (Throwable)e1);
        }
    }
}

