/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.DefaultFaultHandler;
import org.codehaus.xfire.handler.HandlerPipeline;
import org.codehaus.xfire.transport.ChannelEndpoint;

public class DefaultEndpoint
implements ChannelEndpoint {
    private static final Log log = LogFactory.getLog((Class)DefaultEndpoint.class);
    public static final String SERVICE_HANDLERS_REGISTERED = "service.handlers.registered";

    public void onReceive(MessageContext context, InMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received message to " + msg.getUri()));
        }
        if (context.getExchange() == null) {
            MessageExchange exchange = new MessageExchange(context);
            exchange.setInMessage(msg);
            context.setCurrentMessage(msg);
        }
        HandlerPipeline pipeline = new HandlerPipeline(context.getXFire().getInPhases());
        pipeline.addHandlers(context.getXFire().getInHandlers());
        pipeline.addHandlers(msg.getChannel().getTransport().getInHandlers());
        if (context.getService() != null) {
            pipeline.addHandlers(context.getService().getInHandlers());
            context.setProperty(SERVICE_HANDLERS_REGISTERED, Boolean.TRUE);
        }
        context.setInPipeline(pipeline);
        if (context.getFaultHandler() == null) {
            context.setFaultHandler(new DefaultFaultHandler());
        }
        try {
            pipeline.invoke(context);
        }
        catch (Exception e) {
            context.setProperty("exception", e);
            try {
                context.getFaultHandler().invoke(context);
            }
            catch (Exception e1) {
                log.warn((Object)"Error invoking fault handler.", (Throwable)e1);
            }
        }
    }

    public void finishReadingMessage(InMessage message, MessageContext context) throws XFireFault {
        XMLStreamReader reader = message.getXMLStreamReader();
        try {
            int event = reader.getEventType();
            while (event != 8 && reader.hasNext()) {
                event = reader.next();
            }
        }
        catch (XMLStreamException e) {
            log.warn((Object)"Couldn't parse to end of message.", (Throwable)e);
        }
    }
}

