/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.http.AbstractMessageSender;
import org.codehaus.xfire.transport.http.HttpTransport;
import org.codehaus.xfire.transport.http.SimpleMessageSender;
import org.codehaus.xfire.transport.http.XFireServletController;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.OutMessageDataSource;
import org.codehaus.xfire.util.STAXUtils;

public class HttpChannel
extends AbstractChannel {
    private static final Log log = LogFactory.getLog((Class)HttpChannel.class);
    private Map properties = new HashMap();

    public HttpChannel(String uri, HttpTransport transport) {
        this.setTransport(transport);
        this.setUri(uri);
    }

    public void open() {
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        if (message.getUri().equals("urn:xfire:channel:backchannel")) {
            HttpServletResponse response = XFireServletController.getResponse();
            if (response == null) {
                throw new XFireRuntimeException("No backchannel exists for message");
            }
            this.sendViaServlet(context, message, response);
        } else {
            this.sendViaClient(context, message);
        }
    }

    protected void sendViaServlet(MessageContext context, OutMessage message, HttpServletResponse response) throws XFireException {
        try {
            boolean mtomEnabled = Boolean.valueOf((String)context.getContextualProperty("mtom-enabled"));
            Attachments atts = message.getAttachments();
            if (mtomEnabled || atts != null) {
                if (atts == null) {
                    atts = new JavaMailAttachments();
                    message.setAttachments(atts);
                }
                OutMessageDataSource source = new OutMessageDataSource(context, message);
                DataHandler soapHandler = new DataHandler((DataSource)source);
                atts.setSoapMessage(new SimpleAttachment(source.getName(), soapHandler));
                response.setContentType(atts.getContentType());
                atts.write((OutputStream)response.getOutputStream());
            } else {
                response.setContentType(HttpChannel.getSoapMimeType(message));
                HttpChannel.writeWithoutAttachments(context, message, (OutputStream)response.getOutputStream());
            }
        }
        catch (IOException e) {
            throw new XFireException("Couldn't send message.", e);
        }
    }

    public static void writeWithoutAttachments(MessageContext context, OutMessage message, OutputStream out) throws XFireException {
        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(out, message.getEncoding(), context);
        message.getSerializer().writeMessage(message, writer, context);
        try {
            writer.flush();
        }
        catch (XMLStreamException e) {
            log.error((Object)e);
            throw new XFireException("Couldn't send message.", e);
        }
    }

    public static String getSoapMimeType(AbstractMessage msg) {
        SoapVersion soap = msg.getSoapVersion();
        if (!(soap instanceof Soap11)) {
            if (soap instanceof Soap12) {
                return "application/soap+xml; charset=" + msg.getEncoding();
            }
            return "text/xml; charset=" + msg.getEncoding();
        }
        String ct = "text/xml; charset=" + msg.getEncoding();
        return ct;
    }

    protected void sendViaClient(MessageContext context, OutMessage message) throws XFireException {
        AbstractMessageSender sender;
        try {
            Class chms = ClassLoaderUtils.loadClass("org.codehaus.xfire.transport.http.CommonsHttpMessageSender", this.getClass());
            Constructor constructor = chms.getConstructor(OutMessage.class, MessageContext.class);
            sender = (AbstractMessageSender)constructor.newInstance(message, context);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Could not load commons http client. Using buggy SimpleMessageSender instead.");
            }
            sender = new SimpleMessageSender(message, context);
        }
        try {
            ((AbstractMessageSender)sender).open();
            ((AbstractMessageSender)sender).send();
            if (((AbstractMessageSender)sender).hasResponse()) {
                InMessage inMessage = ((AbstractMessageSender)sender).getInMessage();
                inMessage.setChannel(this);
                this.getEndpoint().onReceive(context, inMessage);
            }
        }
        catch (IOException e) {
            throw new XFireException("Couldn't send message.", e);
        }
        finally {
            ((AbstractMessageSender)sender).close();
        }
    }

    public void close() {
        this.properties.clear();
        super.close();
    }

    public boolean isAsync() {
        return false;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }
}

