/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.transport.http.XFireServletController;

public class XFireServlet
extends HttpServlet {
    protected XFire xfire;
    protected XFireServletController controller;
    private static final Log logger = LogFactory.getLog((Class)XFireServlet.class);
    public static final String XFIRE_INSTANCE = "xfire.instance";

    public void init() throws ServletException {
        try {
            super.init();
            this.xfire = this.createXFire();
            this.controller = this.createController();
        }
        catch (Throwable tx) {
            logger.error((Object)"Error initializing XFireServlet.", tx);
            throw new ServletException("Error initializing XFireServlet.", tx);
        }
    }

    public XFire getXFire() throws ServletException {
        if (this.xfire == null) {
            this.xfire = this.createXFire();
        }
        return this.xfire;
    }

    public XFireServletController getController() throws ServletException {
        if (this.controller == null) {
            this.controller = this.createController();
        }
        return this.controller;
    }

    public XFire createXFire() throws ServletException {
        try {
            XFire xfire = (XFire)this.getServletContext().getAttribute(XFIRE_INSTANCE);
            if (xfire == null) {
                XFireFactory factory = XFireFactory.newInstance();
                xfire = factory.getXFire();
            }
            return xfire;
        }
        catch (Exception e) {
            throw new ServletException("Couldn't start XFire.", (Throwable)e);
        }
    }

    public XFireServletController createController() throws ServletException {
        return new XFireServletController(this.xfire);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.controller.doService(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.controller.doService(req, res);
    }
}

