/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.util.ClassLoaderUtils;

public class Resolver {
    private File file;
    private URI uri;
    private InputStream is;

    public Resolver(String path) throws IOException {
        this("", path);
    }

    public Resolver(String baseUriStr, String uriStr) throws IOException {
        try {
            File uriFile = new File(uriStr);
            uriFile = new File(uriFile.getAbsolutePath());
            URI relative = uriFile.exists() ? uriFile.toURI() : new URI(uriStr);
            if (relative.isAbsolute()) {
                this.uri = relative;
                this.is = relative.toURL().openStream();
            } else if (baseUriStr != null) {
                File baseFile = new File(baseUriStr);
                URI base = baseFile.exists() ? baseFile.toURI() : new URI(baseUriStr);
                if ((base = base.resolve(relative)).isAbsolute()) {
                    this.is = base.toURL().openStream();
                    this.uri = base;
                }
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (this.uri != null && "file".equals(this.uri.getScheme())) {
            this.file = new File(this.uri);
        }
        if (this.is == null && this.file != null && this.file.exists()) {
            this.uri = this.file.toURI();
            try {
                this.is = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new XFireRuntimeException("File was deleted! " + uriStr, e);
            }
        } else if (this.is == null) {
            URL url = ClassLoaderUtils.getResource(uriStr, this.getClass());
            if (url == null) {
                try {
                    url = new URL(uriStr);
                    this.uri = new URI(url.toString());
                    this.is = url.openStream();
                }
                catch (MalformedURLException e) {
                }
                catch (URISyntaxException e) {}
            } else {
                this.is = url.openStream();
            }
        }
        if (this.is == null) {
            throw new IOException("Could not find resource '" + uriStr + "' relative to '" + baseUriStr + "'");
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public boolean isFile() {
        return this.file.exists();
    }

    public File getFile() {
        return this.file;
    }
}

