/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.spring.XFireConfigLoader;

public class WsdlGenTask
extends Task {
    private static final Log LOGGER = LogFactory.getLog(WsdlGenTask.class);
    private String configUrl;
    private String outputDirectory;
    private File generatedFile;
    private ClassLoader overridingContextClassLoader = XFireConfigLoader.class.getClassLoader();

    public void setOverridingContextClassLoader(ClassLoader overridingContextClassLoader) {
        this.overridingContextClassLoader = overridingContextClassLoader;
    }

    public void setConfigUrl(String configUrl) {
        this.configUrl = configUrl;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    private static Log getLogger() {
        return LOGGER;
    }

    public File getGeneratedFile() {
        return this.generatedFile;
    }

    public void execute() throws BuildException {
        XFire xfire;
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.overridingContextClassLoader);
        XFireConfigLoader configLoader = new XFireConfigLoader();
        try {
            xfire = configLoader.loadConfig(this.configUrl);
        }
        catch (XFireException e) {
            throw new BuildException("Failure to load the configUrl", (Throwable)e);
        }
        ServiceRegistry serviceRegistry = xfire.getServiceRegistry();
        Collection services = serviceRegistry.getServices();
        File outputDir = new File(this.outputDirectory);
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            WsdlGenTask.getLogger().warn((Object)("the output directory " + this.outputDirectory + " doesn't exist and couldn't be created. The task with probably fail."));
        }
        for (Service service : services) {
            FileOutputStream out;
            String serviceName = service.getName().getLocalPart();
            File outputFile = new File(outputDir, serviceName + ".wsdl");
            try {
                out = new FileOutputStream(outputFile);
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Unable to generate WSDL: output file " + outputFile + " not found", (Throwable)e);
            }
            BufferedOutputStream stream = new BufferedOutputStream(out);
            try {
                service.getWSDLWriter().write((OutputStream)stream);
            }
            catch (IOException e) {
                throw new BuildException("Unable to generate WSDL.", (Throwable)e);
            }
            this.generatedFile = outputFile;
        }
        Thread.currentThread().setContextClassLoader(originalCL);
    }
}

