/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen.jaxb;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.TypeAndAnnotation;
import com.sun.tools.xjc.api.XJC;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.gen.GenerationContext;
import org.codehaus.xfire.gen.GenerationException;
import org.codehaus.xfire.gen.SchemaSupport;
import org.codehaus.xfire.gen.jaxb.ErrorReceiverImpl;
import org.codehaus.xfire.jaxb2.JaxbTypeRegistry;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.wsdl11.parser.SchemaInfo;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JAXBSchemaSupport
implements SchemaSupport {
    SchemaCompiler schemaCompiler;
    private AegisBindingProvider provider = new AegisBindingProvider((TypeMappingRegistry)new JaxbTypeRegistry());
    private S2JJAXBModel model;
    private JCodeModel jaxbModel;

    public void initialize(GenerationContext context) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[0], cl));
        ErrorReceiverImpl er = new ErrorReceiverImpl();
        this.schemaCompiler = XJC.createSchemaCompiler();
        this.schemaCompiler.setErrorListener((ErrorListener)er);
        if (context.isExplicitAnnotation()) {
            try {
                Field f = this.schemaCompiler.getClass().getDeclaredField("opts");
                f.setAccessible(true);
                Options opts = (Options)f.get(this.schemaCompiler);
                opts.runtime14 = true;
            }
            catch (Exception e) {
                System.err.println("Could not set JDK 1.4 compatibility");
            }
        }
        ArrayList elements = (ArrayList)context.getSchemas();
        int schemaElementCount = 1;
        for (SchemaInfo schemaInfo : elements) {
            this.schemaCompiler.setEntityResolver((EntityResolver)new RelativeEntityResolver(schemaInfo.getDefinition().getDocumentBaseURI()));
            String systemId = schemaInfo.getSchema().getSourceURI();
            if (!schemaInfo.isImported()) {
                systemId = systemId + "#types?schema" + schemaElementCount++;
            }
            this.schemaCompiler.parseSchema(systemId, schemaInfo.getSchemaElement());
        }
        if (context.getExternalBindings() != null) {
            for (Map.Entry entry : context.getExternalBindings().entrySet()) {
                InputSource source = new InputSource((InputStream)entry.getValue());
                source.setSystemId((String)entry.getKey());
                this.schemaCompiler.parseSchema(source);
            }
        }
        this.model = this.schemaCompiler.bind();
        if (er.hasFatalErrors()) {
            throw new GenerationException("Error generating JAXB model.");
        }
        this.jaxbModel = this.model.generateCode(null, (ErrorListener)er);
        this.jaxbModel.build(context.getOutputDirectory());
        Thread.currentThread().setContextClassLoader(cl);
    }

    public JType getType(GenerationContext context, QName concreteType, QName schemaType) throws GenerationException {
        JCodeModel codeModel = context.getCodeModel();
        Mapping mapping = this.model.get(concreteType);
        if (mapping == null) {
            mapping = this.model.get(schemaType);
        }
        JType typeClass = null;
        if (mapping != null) {
            typeClass = mapping.getType().getTypeClass();
        }
        if (typeClass == null) {
            TypeAndAnnotation def = this.model.getJavaType(concreteType);
            if (def == null) {
                def = this.model.getJavaType(schemaType);
            }
            if (def != null) {
                return def.getTypeClass();
            }
        }
        if (typeClass == null) {
            Class clazz = this.provider.getTypeClass(concreteType, null);
            if (clazz == null) {
                clazz = this.provider.getTypeClass(schemaType, null);
            }
            if (clazz == null) {
                throw new GenerationException("Could not find type " + concreteType);
            }
            typeClass = codeModel._ref(clazz);
        }
        return typeClass;
    }

    public BindingProvider getBindingProvider() {
        return this.provider;
    }

    public JExpression getBindingProviderExpr(GenerationContext context) {
        JType aegis = context.getCodeModel()._ref(AegisBindingProvider.class);
        JInvocation expr = JExpr._new((JType)aegis);
        JType xbean = context.getCodeModel()._ref(JaxbTypeRegistry.class);
        expr.arg((JExpression)JExpr._new((JType)xbean));
        return expr;
    }

    static class RelativeEntityResolver
    implements EntityResolver {
        private String baseURI;

        public RelativeEntityResolver(String baseURI) {
            this.baseURI = baseURI;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            File file = new File(this.baseURI, systemId);
            if (file.exists()) {
                System.out.println(systemId);
                return new InputSource(new FileInputStream(file));
            }
            return null;
        }
    }
}

