/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.jaxws.gen;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import org.codehaus.xfire.gen.GenerationContext;
import org.codehaus.xfire.gen.GeneratorPlugin;
import org.codehaus.xfire.gen.jsr181.AbstractPlugin;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.soap.Soap11Binding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceGenerator
extends AbstractPlugin
implements GeneratorPlugin {
    public void generate(GenerationContext context) throws Exception {
        Map q2services = context.getServices();
        for (Map.Entry entry : q2services.entrySet()) {
            this.generate(context, (QName)entry.getKey(), (Collection)entry.getValue());
        }
    }

    public void generate(GenerationContext context, QName qname, Collection<Service> services) throws Exception {
        String name = qname.getLocalPart();
        String ns = qname.getNamespaceURI();
        JCodeModel model = context.getCodeModel();
        String portName = this.getPackage(qname, context) + "." + name + "Service";
        portName = this.getUniqueName(model, portName);
        JDefinedClass servCls = model._class(portName);
        servCls._extends(javax.xml.ws.Service.class);
        String wsdlUrl = context.getWsdlLocation();
        JAnnotationUse clientAnn = servCls.annotate(WebServiceClient.class);
        clientAnn.param("targetNamespace", ns);
        clientAnn.param("name", name);
        clientAnn.param("wsdlLocation", wsdlUrl);
        JType qnameType = model._ref(QName.class);
        JMethod constructor = servCls.constructor(1);
        constructor._throws(MalformedURLException.class);
        JType urlType = model._ref(URL.class);
        JInvocation newURL = JExpr._new((JType)urlType).arg(wsdlUrl);
        JInvocation newSN = JExpr._new((JType)qnameType).arg(ns).arg(name);
        JInvocation superService = JExpr.invoke((String)"super").arg((JExpression)newURL).arg((JExpression)newSN);
        constructor.body().add((JStatement)superService);
        boolean addedLocal = false;
        JBlock staticBlock = servCls.init();
        JType hashMapType = model._ref(HashMap.class);
        JType mapType = model._ref(Map.class);
        JFieldVar portsVar = servCls.field(20, mapType, "ports", (JExpression)JExpr._new((JType)hashMapType));
        JMethod method = servCls.method(17, mapType, "getPortClassMap");
        method.body()._return((JExpression)JExpr.ref((String)"ports"));
        for (Service service : services) {
            JDefinedClass serviceImpl = (JDefinedClass)service.getProperty("service.stub");
            JDefinedClass serviceIntf = (JDefinedClass)service.getProperty("service.interface");
            QName portType = service.getServiceInfo().getPortType();
            JFieldVar intfClass = servCls.field(17, Class.class, this.javify(serviceIntf.name()), JExpr.dotclass((JClass)serviceIntf));
            JFieldVar implClass = servCls.field(17, Class.class, this.javify(serviceImpl.name() + "_BINDING"), JExpr.dotclass((JClass)serviceImpl));
            if (!addedLocal) {
                Soap11Binding localBind = new Soap11Binding(new QName(ns, name + "LocalBinding"), "urn:xfire:transport:local", service);
                service.addBinding((Binding)localBind);
                service.addEndpoint(new QName(ns, name + "LocalPort"), (Binding)localBind, "xfire.local://" + name);
                addedLocal = true;
            }
            for (Endpoint endpoint : service.getEndpoints()) {
                JInvocation newQN = JExpr._new((JType)qnameType);
                newQN.arg(endpoint.getName().getNamespaceURI());
                newQN.arg(endpoint.getName().getLocalPart());
                JInvocation bindingQN = JExpr._new((JType)qnameType);
                bindingQN.arg(endpoint.getBinding().getName().getNamespaceURI());
                bindingQN.arg(endpoint.getBinding().getName().getLocalPart());
                JMethod getFooEndpoint = servCls.method(1, (JType)serviceIntf, "get" + endpoint.getName().getLocalPart());
                JBlock geBody = getFooEndpoint.body();
                geBody._return((JExpression)JExpr.cast((JType)serviceIntf, (JExpression)JExpr.direct((String)"this").invoke("getPort").arg((JExpression)newQN).arg((JExpression)implClass)));
                JAnnotationUse weAnn = getFooEndpoint.annotate(WebEndpoint.class);
                weAnn.param("name", endpoint.getName().getLocalPart());
                staticBlock.add((JStatement)portsVar.invoke("put").arg((JExpression)newQN).arg((JExpression)implClass));
            }
        }
    }
}

