/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.binding.BeanInvoker;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.Invoker;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.soap.Soap11Binding;
import org.codehaus.xfire.spring.SpringUtils;
import org.codehaus.xfire.spring.config.AbstractSoapBindingBean;
import org.codehaus.xfire.spring.config.EndpointBean;
import org.codehaus.xfire.spring.config.Soap11BindingBean;
import org.codehaus.xfire.spring.config.Soap12BindingBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ServiceBean
implements InitializingBean,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog((Class)ServiceBean.class);
    private Service xfireService;
    private ServiceFactory serviceFactory;
    protected XFire xFire;
    private String name;
    private String namespace;
    private Class serviceInterface;
    private Object service;
    private List bindings;
    private List inHandlers;
    private List outHandlers;
    private List faultHandlers;
    private List schemas;
    protected Class implementationClass;
    private Map properties = new HashMap();
    protected boolean createDefaultBindings;
    protected String use;
    protected String style;
    private String scope;

    public void afterPropertiesSet() throws Exception {
        Class<?> intf;
        if (this.serviceFactory == null) {
            this.serviceFactory = new ObjectServiceFactory(this.xFire.getTransportManager(), (BindingProvider)new AegisBindingProvider());
        }
        if ((intf = this.getServiceClass()) == null) {
            if (this.getServiceBean() == null) {
                throw new RuntimeException("Error creating service " + this.name + ". The service class or the service bean must be set!");
            }
            intf = SpringUtils.getUserTarget(this.getServiceBean()).getClass();
        }
        if (this.createDefaultBindings) {
            this.properties.put("objectServiceFactory.createDefaultBindings", Boolean.TRUE);
        }
        if (this.style != null) {
            this.properties.put("objectServiceFactory.style", this.style);
        }
        if (this.use != null) {
            this.properties.put("objectServiceFactory.use", this.use);
        }
        if (this.scope != null) {
            this.properties.put("objectServiceFactory.scope", this.scope);
        }
        if (this.implementationClass != null) {
            this.properties.put("xfire.serviceImplClass", this.implementationClass);
        }
        this.prepareXMLFactories(this.properties);
        if (this.schemas != null) {
            this.properties.put("objectServiceFactory.schemas", this.schemas);
        }
        this.xfireService = this.serviceFactory.create(intf, this.name, this.namespace, this.properties);
        if (this.bindings != null && this.serviceFactory instanceof ObjectServiceFactory) {
            this.initializeBindings();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Exposing service with name " + this.xfireService.getName()));
        }
        this.xFire.getServiceRegistry().register(this.xfireService);
        Object serviceBean = this.getProxyForService();
        if (serviceBean != null) {
            this.xfireService.setInvoker((Invoker)new BeanInvoker(serviceBean));
        }
        if (this.xfireService.getInHandlers() == null) {
            this.xfireService.setInHandlers(this.getInHandlers());
        } else if (this.getInHandlers() != null) {
            this.xfireService.getInHandlers().addAll(this.getInHandlers());
        }
        if (this.xfireService.getOutHandlers() == null) {
            this.xfireService.setOutHandlers(this.getOutHandlers());
        } else if (this.getOutHandlers() != null) {
            this.xfireService.getOutHandlers().addAll(this.getOutHandlers());
        }
        if (this.xfireService.getFaultHandlers() == null) {
            this.xfireService.setFaultHandlers(this.getFaultHandlers());
        } else if (this.getFaultHandlers() != null) {
            this.xfireService.getFaultHandlers().addAll(this.getFaultHandlers());
        }
    }

    private void prepareXMLFactories(Map properties) throws Exception {
        Class inFactoryClass = null;
        Object inFactory = properties.get("xfire.stax.input.factory");
        if (inFactory != null && inFactory instanceof String) {
            ClassEditor ed = new ClassEditor();
            ed.setAsText((String)inFactory);
            inFactoryClass = (Class)ed.getValue();
            if (!XMLInputFactory.class.isAssignableFrom(inFactoryClass)) {
                throw new RuntimeException("Class : " + inFactoryClass.getName() + " is not XMLInputFactory instance");
            }
            properties.put("xfire.stax.input.factory", inFactoryClass);
        }
        Class outFactoryClass = null;
        Object outFactory = properties.get("xfire.stax.output.factory");
        if (outFactory != null && outFactory instanceof String) {
            ClassEditor ed = new ClassEditor();
            ed.setAsText((String)outFactory);
            outFactoryClass = (Class)ed.getValue();
            if (!XMLOutputFactory.class.isAssignableFrom(outFactoryClass)) {
                throw new RuntimeException("Class : " + outFactoryClass.getName() + " is not XMLOutputFactory instance");
            }
            properties.put("xfire.stax.output.factory", outFactoryClass);
        }
    }

    protected void initializeBindings() throws Exception {
        ObjectServiceFactory osf = (ObjectServiceFactory)this.serviceFactory;
        Iterator itr = this.bindings.iterator();
        while (itr.hasNext()) {
            AbstractSoapBindingBean o = (AbstractSoapBindingBean)itr.next();
            Soap11Binding binding = null;
            if (o instanceof Soap11BindingBean) {
                binding = osf.createSoap11Binding(this.xfireService, o.getName(), o.getTransport());
            } else if (o instanceof Soap12BindingBean) {
                binding = osf.createSoap12Binding(this.xfireService, o.getName(), o.getTransport());
            }
            binding.setUndefinedEndpointAllowed(o.isAllowUndefinedEndpoints());
            if (o.getEndpoints() == null) continue;
            Iterator eitr = o.getEndpoints().iterator();
            while (eitr.hasNext()) {
                EndpointBean ep = (EndpointBean)eitr.next();
                osf.createEndpoint(this.xfireService, ep.getName(), ep.getUrl(), (Binding)binding);
            }
        }
    }

    protected Object getProxyForService() {
        return this.getServiceBean();
    }

    public Service getXFireService() {
        return this.xfireService;
    }

    public Object getServiceBean() {
        return this.service;
    }

    public void setServiceBean(Object service) {
        this.service = service;
    }

    public Class getServiceClass() {
        return this.serviceInterface;
    }

    public void setServiceClass(Class serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List getFaultHandlers() {
        return this.faultHandlers;
    }

    public void setFaultHandlers(List faultHandlers) {
        this.faultHandlers = faultHandlers;
    }

    public List getInHandlers() {
        return this.inHandlers;
    }

    public void setInHandlers(List inHandlers) {
        this.inHandlers = inHandlers;
    }

    public List getOutHandlers() {
        return this.outHandlers;
    }

    public void setOutHandlers(List outHandlers) {
        this.outHandlers = outHandlers;
    }

    public void setXfire(XFire xFire) {
        this.xFire = xFire;
    }

    public XFire getXfire() {
        return this.xFire;
    }

    public Class getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(Class implementationClass) {
        this.implementationClass = implementationClass;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public List getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List schemas) {
        this.schemas = schemas;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        if (this.xFire == null) {
            this.xFire = (XFire)ctx.getBean("xfire");
        }
        if (this.serviceFactory == null) {
            this.serviceFactory = (ServiceFactory)ctx.getBean("xfire.serviceFactory");
        }
    }

    public List getBindings() {
        return this.bindings;
    }

    public void setBindings(List bindings) {
        this.bindings = bindings;
    }

    public boolean isCreateDefaultBindings() {
        return this.createDefaultBindings;
    }

    public void setCreateDefaultBindings(boolean createDefaultBindings) {
        this.createDefaultBindings = createDefaultBindings;
    }
}

