/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring.remoting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.client.XFireProxy;
import org.codehaus.xfire.client.XFireProxyFactory;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class XFireClientFactoryBean
implements FactoryBean,
InitializingBean {
    private static final Log LOG = LogFactory.getLog((Class)XFireClientFactoryBean.class);
    private Object _serviceProxy;
    private Class _serviceClass;
    private ServiceFactory _serviceFactory = new ObjectServiceFactory();
    private String _wsdlDocumentUrl;
    private String _serviceName;
    private String _namespaceUri;
    private String _username;
    private String _password;
    private String _url;
    private QName _endpointName;
    private Map _properties;
    private boolean _lookupServiceOnStartup = true;

    public Object getObject() throws Exception {
        return this._serviceProxy;
    }

    public Class getObjectType() {
        return this._serviceProxy != null ? this._serviceProxy.getClass() : this.getServiceClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getServiceClass() == null) {
            throw new IllegalStateException("serviceInterface is required");
        }
        if (this.getWsdlDocumentUrl() == null) {
            throw new IllegalStateException("wsdlDocumentUrl is required");
        }
        if (this.getLookupServiceOnStartup()) {
            this._serviceProxy = this.createClient();
        } else {
            ProxyInterceptor interceptor = new ProxyInterceptor();
            this._serviceProxy = ProxyFactory.getProxy((Class)this.getServiceClass(), (Interceptor)interceptor);
        }
    }

    public ServiceFactory getServiceFactory() {
        return this._serviceFactory;
    }

    public void setServiceFactory(ServiceFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Can not set the service factory to null");
        }
        this._serviceFactory = factory;
    }

    public Class getServiceClass() {
        return this._serviceClass;
    }

    public void setServiceClass(Class serviceClass) {
        this._serviceClass = serviceClass;
    }

    public String getWsdlDocumentUrl() {
        return this._wsdlDocumentUrl;
    }

    public void setWsdlDocumentUrl(String wsdlUrl) {
        this._wsdlDocumentUrl = wsdlUrl;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public void setServiceName(String serviceName) {
        this._serviceName = serviceName;
    }

    public String getNamespaceUri() {
        return this._namespaceUri;
    }

    public void setNamespaceUri(String namespace) {
        this._namespaceUri = namespace;
    }

    public boolean getLookupServiceOnStartup() {
        return this._lookupServiceOnStartup;
    }

    public void setLookupServiceOnStartup(boolean lookupServiceOnStartup) {
        this._lookupServiceOnStartup = lookupServiceOnStartup;
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public Map getProperties() {
        return this._properties;
    }

    public void setProperties(Map properties) {
        this._properties = properties;
    }

    public QName getEndpoint() {
        return this._endpointName;
    }

    public void setEndpoint(QName name) {
        this._endpointName = name;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String _url) {
        this._url = _url;
    }

    private Object createClient() throws Exception {
        String username;
        Object serviceClient = this.makeClient();
        Class interf = this.getServiceClass();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created: " + this.toString()));
        }
        if ((username = this.getUsername()) != null) {
            XFireProxy proxy = (XFireProxy)Proxy.getInvocationHandler(serviceClient);
            Client client = proxy.getClient();
            client.setProperty("username", (Object)username);
            String password = this.getPassword();
            client.setProperty("password", (Object)password);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Enabled HTTP basic authentication for: " + interf + " with username: " + username));
            }
        }
        return serviceClient;
    }

    private Object makeClient() throws Exception {
        String serviceName = this.getServiceName();
        String namespace = this.getNamespaceUri();
        if ((serviceName == null || namespace == null) && this._wsdlDocumentUrl != null) {
            this.setWSDLProperties();
        }
        Service serviceModel = this.getServiceFactory().create(this.getServiceClass(), serviceName, namespace, this._properties);
        String serviceUrl = this.getServiceUrl();
        if (this._endpointName != null) {
            Endpoint ep = serviceModel.getEndpoint(this._endpointName);
            if (ep == null) {
                throw new XFireRuntimeException("Could not find endpoint with name " + this._endpointName + " on service.");
            }
            return new XFireProxyFactory().create(ep);
        }
        return new XFireProxyFactory().create(serviceModel, serviceUrl);
    }

    private String getServiceUrl() {
        String serviceUrl = this._url;
        if (serviceUrl == null) {
            serviceUrl = this.getWsdlDocumentUrl().replaceAll("\\?wsdl", "").replaceAll("\\?WSDL", "");
        }
        return serviceUrl;
    }

    protected void setWSDLProperties() {
        String wsdlUrl = this.getWsdlDocumentUrl();
        try {
            Map services;
            javax.wsdl.Service service;
            Definition d = this.getWSDLDefinition();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Determining properties based on WSDL at: " + wsdlUrl));
            }
            if ((service = (javax.wsdl.Service)this.getOnlyElem(services = d.getServices())) != null) {
                if (this.getServiceName() == null) {
                    this.setServiceName(service.getQName().getLocalPart());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ServiceName is: " + this.getServiceName()));
                }
                if (this.getNamespaceUri() == null) {
                    this.setNamespaceUri(service.getQName().getNamespaceURI());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("NamespaceUri is: " + this.getNamespaceUri()));
                }
            } else {
                LOG.warn((Object)("Unable to determine which service is meant. WSDL does not contain exactly one service, but: " + services.size()));
            }
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Unable to parse WSDL at: " + wsdlUrl, (Throwable)e);
        }
    }

    protected Definition getWSDLDefinition() throws Exception {
        return WSDLFactory.newInstance().newWSDLReader().readWSDL(this.getWsdlDocumentUrl());
    }

    private Object getOnlyElem(Map map) {
        if (map.size() == 1) {
            Set keySet = map.keySet();
            Iterator i = keySet.iterator();
            return map.get(i.next());
        }
        return null;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("XFire client proxy for: ");
        builder.append(this.getServiceClass());
        builder.append(" at: ");
        builder.append(this.getServiceUrl());
        return builder.toString();
    }

    private class ProxyInterceptor
    implements MethodInterceptor {
        private Object _serviceClient;

        private ProxyInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (this._serviceClient == null && AopUtils.isToStringMethod((Method)invocation.getMethod())) {
                return "Un-initialized " + XFireClientFactoryBean.this.toString();
            }
            Method method = invocation.getMethod();
            Object[] args = invocation.getArguments();
            Object client = this.getClient();
            try {
                return method.invoke(client, args);
            }
            catch (InvocationTargetException e) {
                String callTarget = XFireClientFactoryBean.this.getServiceUrl() + " arguments: " + Arrays.toString(args);
                Throwable targetException = e.getTargetException();
                if (targetException instanceof XFireRuntimeException) {
                    XFireRuntimeException xfRt = (XFireRuntimeException)targetException;
                    Throwable cause = xfRt.getCause();
                    throw new XFireRuntimeException("Exception while calling: " + callTarget, cause);
                }
                throw targetException;
            }
        }

        private synchronized Object getClient() throws Exception {
            if (this._serviceClient == null) {
                this._serviceClient = XFireClientFactoryBean.this.createClient();
            }
            return this._serviceClient;
        }
    }
}

