/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.bayeux.client;

import java.util.List;
import java.util.Map;
import org.cometd.bayeux.Bayeux;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;

public interface ClientSession
extends Session {
    public void addExtension(Extension var1);

    public void removeExtension(Extension var1);

    public List<Extension> getExtensions();

    default public void handshake() {
        this.handshake(null);
    }

    default public void handshake(Map<String, Object> template) {
        this.handshake(template, MessageListener.NOOP);
    }

    public void handshake(Map<String, Object> var1, MessageListener var2);

    default public void disconnect() {
        this.disconnect(MessageListener.NOOP);
    }

    public void disconnect(MessageListener var1);

    public ClientSessionChannel getChannel(String var1);

    public void remoteCall(String var1, Object var2, MessageListener var3);

    public static interface MessageListener
    extends Bayeux.BayeuxListener {
        public static final MessageListener NOOP = message -> {};

        public void onMessage(Message var1);
    }

    public static interface Extension {
        default public void incoming(ClientSession session, Message.Mutable message, Promise<Boolean> promise) {
            promise.succeed((Object)(message.isMeta() ? this.rcvMeta(session, message) : this.rcv(session, message)));
        }

        default public boolean rcv(ClientSession session, Message.Mutable message) {
            return true;
        }

        default public boolean rcvMeta(ClientSession session, Message.Mutable message) {
            return true;
        }

        default public void outgoing(ClientSession session, Message.Mutable message, Promise<Boolean> promise) {
            promise.succeed((Object)(message.isMeta() ? this.sendMeta(session, message) : this.send(session, message)));
        }

        default public boolean send(ClientSession session, Message.Mutable message) {
            return true;
        }

        default public boolean sendMeta(ClientSession session, Message.Mutable message) {
            return true;
        }
    }
}

