/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Extension;
import org.cometd.Listener;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.cometd.RemoveListener;
import org.cometd.client.Advice;
import org.cometd.server.MessageImpl;
import org.cometd.server.MessagePool;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BayeuxClient
extends AbstractLifeCycle
implements Client {
    private static final String __TIMER = "org.cometd.client.Timer";
    private static final String __JSON = "org.cometd.client.JSON";
    private static final String __MSGPOOL = "org.cometd.server.MessagePool";
    protected HttpClient _httpClient;
    protected MessagePool _msgPool;
    private ArrayQueue<Message> _inQ = new ArrayQueue();
    private ArrayQueue<Message> _outQ = new ArrayQueue();
    protected Address _cometdAddress;
    private Exchange _pull;
    private Exchange _push;
    private String _path = "/cometd";
    private boolean _initialized = false;
    private boolean _disconnecting = false;
    private boolean _handshook = false;
    private String _clientId;
    private Listener _listener;
    private List<RemoveListener> _rListeners;
    private List<MessageListener> _mListeners;
    private int _batch;
    private boolean _formEncoded;
    private Map<String, Cookie> _cookies = new ConcurrentHashMap<String, Cookie>();
    private Advice _advice;
    private Timer _timer;
    private int _backoffInterval = 1000;
    private int _backoffMaxRetries = 60;
    private Buffer _scheme;
    protected Extension[] _extensions;
    protected JSON _jsonOut;

    public BayeuxClient(HttpClient client, String url) {
        this(client, url, null);
    }

    public BayeuxClient(HttpClient client, String url, Timer timer) {
        HttpURI uri = new HttpURI(url);
        this._httpClient = client;
        this._cometdAddress = new Address(uri.getHost(), uri.getPort());
        this._path = uri.getPath();
        this._timer = timer;
        this._scheme = "https".equals(uri.getScheme()) ? HttpSchemes.HTTPS_BUFFER : HttpSchemes.HTTP_BUFFER;
    }

    public BayeuxClient(HttpClient client, Address address, String path, Timer timer) {
        this._httpClient = client;
        this._cometdAddress = address;
        this._path = path;
        this._timer = timer;
    }

    public BayeuxClient(HttpClient client, Address address, String uri) {
        this(client, address, uri, null);
    }

    public void addExtension(Extension ext) {
        this._extensions = (Extension[])LazyList.addToArray((Object[])this._extensions, (Object)ext, Extension.class);
    }

    Extension[] getExtensions() {
        return this._extensions;
    }

    public void setBackOffInterval(int interval) {
        this._backoffInterval = interval;
    }

    public int getBackoffInterval() {
        return this._backoffInterval;
    }

    public void setBackoffMaxRetries(int retries) {
        this._backoffMaxRetries = retries;
    }

    public int getBackoffMaxRetries() {
        return this._backoffMaxRetries;
    }

    public String getId() {
        return this._clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        if (!this._httpClient.isStarted()) {
            throw new IllegalStateException("!HttpClient.isStarted()");
        }
        ArrayQueue<Message> arrayQueue = this._httpClient;
        synchronized (arrayQueue) {
            if (this._jsonOut == null) {
                this._jsonOut = (JSON)this._httpClient.getAttribute(__JSON);
                if (this._jsonOut == null) {
                    this._jsonOut = new JSON();
                    this._httpClient.setAttribute(__JSON, (Object)this._jsonOut);
                }
            }
            if (this._timer == null) {
                this._timer = (Timer)this._httpClient.getAttribute(__TIMER);
                if (this._timer == null) {
                    this._timer = new Timer("org.cometd.client.Timer@" + ((Object)((Object)this)).hashCode(), true);
                    this._httpClient.setAttribute(__TIMER, (Object)this._timer);
                }
            }
            if (this._msgPool == null) {
                this._msgPool = (MessagePool)this._httpClient.getAttribute(__MSGPOOL);
                if (this._msgPool == null) {
                    this._msgPool = new MessagePool();
                    this._httpClient.setAttribute(__MSGPOOL, (Object)this._msgPool);
                }
            }
        }
        this._disconnecting = false;
        this._pull = null;
        this._push = null;
        super.doStart();
        arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            if (!this._initialized && this._pull == null) {
                this._pull = new Handshake();
                this.send(this._pull, false);
            }
        }
    }

    protected void doStop() throws Exception {
        if (!this._disconnecting) {
            this.disconnect();
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPolling() {
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            return this.isRunning() && this._pull != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(Client from, Message message) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Not running");
        }
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            if (this._mListeners == null) {
                this._inQ.add((Object)message);
            } else {
                for (MessageListener l : this._mListeners) {
                    l.deliver(from, (Client)this, message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(Client from, String toChannel, Object data, String id) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Not running");
        }
        MessageImpl message = this._msgPool.newMessage();
        message.put("channel", (Object)toChannel);
        message.put("data", data);
        if (id != null) {
            message.put("id", (Object)id);
        }
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            if (this._mListeners == null) {
                message.incRef();
                this._inQ.add((Object)message);
            } else {
                for (MessageListener l : this._mListeners) {
                    if (!(l instanceof MessageListener.Synchronous)) continue;
                    l.deliver(from, (Client)this, (Message)message);
                }
            }
        }
        if (this._mListeners != null) {
            for (MessageListener l : this._mListeners) {
                if (l instanceof MessageListener.Synchronous) continue;
                l.deliver(from, (Client)this, (Message)message);
            }
        }
        message.decRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Listener getListener() {
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            return this._listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessages() {
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            return this._inQ.size() > 0;
        }
    }

    public boolean isLocal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(MessageImpl msg) {
        msg.incRef();
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            this._outQ.add((Object)msg);
            if (this._batch == 0 && this._initialized && this._push == null) {
                this._push = new Publish();
                try {
                    this.send((HttpExchange)this._push);
                }
                catch (Exception e) {
                    this.metaPublishFail(e, ((Publish)this._push).getOutboundMessages());
                }
            }
        }
    }

    public void publish(String toChannel, Object data, String msgId) {
        if (!this.isRunning() || this._disconnecting) {
            throw new IllegalStateException("Not running");
        }
        MessageImpl msg = this._msgPool.newMessage();
        msg.put("channel", (Object)toChannel);
        msg.put("data", data);
        if (msgId != null) {
            msg.put("id", (Object)msgId);
        }
        this.publish(msg);
        msg.decRef();
    }

    public void subscribe(String toChannel) {
        if (!this.isRunning() || this._disconnecting) {
            throw new IllegalStateException("Not running");
        }
        MessageImpl msg = this._msgPool.newMessage();
        msg.put("channel", (Object)"/meta/subscribe");
        msg.put("subscription", (Object)toChannel);
        this.publish(msg);
        msg.decRef();
    }

    public void unsubscribe(String toChannel) {
        if (!this.isRunning() || this._disconnecting) {
            throw new IllegalStateException("Not running");
        }
        MessageImpl msg = this._msgPool.newMessage();
        msg.put("channel", (Object)"/meta/unsubscribe");
        msg.put("subscription", (Object)toChannel);
        this.publish(msg);
        msg.decRef();
    }

    public void remove() {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (!this.isRunning() || this._disconnecting) {
            throw new IllegalStateException("Not running");
        }
        MessageImpl msg = this._msgPool.newMessage();
        msg.put("channel", (Object)"/meta/disconnect");
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            this._outQ.add((Object)msg);
            this._disconnecting = true;
            if (this._batch == 0 && this._initialized && this._push == null) {
                this._push = new Publish();
                try {
                    this.send((HttpExchange)this._push);
                }
                catch (IOException e) {
                    Log.warn((String)e.toString());
                    Log.debug((Throwable)e);
                    this.send(this._push, true);
                }
            }
            this._initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(Listener listener) {
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            if (this._listener != null) {
                this.removeListener((ClientListener)this._listener);
            }
            this._listener = listener;
            if (this._listener != null) {
                this.addListener((ClientListener)this._listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> takeMessages() {
        LinkedList<Message> list;
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            list = new LinkedList<Message>((Collection<Message>)this._inQ);
            this._inQ.clear();
        }
        for (Message m : list) {
            if (!(m instanceof MessageImpl)) continue;
            ((MessageImpl)m).decRef();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBatch() {
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            if (--this._batch <= 0) {
                this._batch = 0;
                if ((this._initialized || this._disconnecting) && this._push == null && this._outQ.size() > 0) {
                    this._push = new Publish();
                    try {
                        this.send((HttpExchange)this._push);
                    }
                    catch (IOException e) {
                        this.metaPublishFail(e, ((Publish)this._push).getOutboundMessages());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBatch() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Not running");
        }
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            ++this._batch;
        }
    }

    protected void customize(HttpExchange exchange) {
        StringBuilder buf = null;
        for (Cookie cookie : this._cookies.values()) {
            if (buf == null) {
                buf = new StringBuilder();
            } else {
                buf.append("; ");
            }
            buf.append(cookie.getName());
            buf.append("=");
            buf.append(cookie.getValue());
        }
        if (buf != null) {
            exchange.addRequestHeader("Cookie", buf.toString());
        }
        if (this._scheme != null) {
            exchange.setScheme(this._scheme);
        }
    }

    public void setCookie(Cookie cookie) {
        this._cookies.put(cookie.getName(), cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ClientListener listener) {
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            boolean added = false;
            if (listener instanceof MessageListener) {
                added = true;
                if (this._mListeners == null) {
                    this._mListeners = new ArrayList<MessageListener>();
                }
                this._mListeners.add((MessageListener)listener);
            }
            if (listener instanceof RemoveListener) {
                added = true;
                if (this._rListeners == null) {
                    this._rListeners = new ArrayList<RemoveListener>();
                }
                this._rListeners.add((RemoveListener)listener);
            }
            if (!added) {
                throw new IllegalArgumentException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ClientListener listener) {
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            if (listener instanceof MessageListener && this._mListeners != null) {
                this._mListeners.remove((MessageListener)listener);
            }
            if (listener instanceof RemoveListener && this._rListeners != null) {
                this._rListeners.remove((RemoveListener)listener);
            }
        }
    }

    public int getMaxQueue() {
        return -1;
    }

    public Queue<Message> getQueue() {
        return this._inQ;
    }

    public void setMaxQueue(int max) {
        if (max != -1) {
            throw new UnsupportedOperationException();
        }
    }

    protected boolean send(final Exchange exchange, boolean backoff) {
        long interval;
        long l = interval = this._advice != null ? this._advice.getInterval() : 0L;
        if (backoff) {
            int retries = exchange.getBackoffRetries();
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Send with backoff, retries=" + retries + " for " + (Object)((Object)exchange)));
            }
            if (retries >= this._backoffMaxRetries) {
                return false;
            }
            exchange.incBackoffRetries();
            interval += (long)(retries * this._backoffInterval);
        }
        if (interval > 0L) {
            TimerTask task = new TimerTask(){

                public void run() {
                    try {
                        BayeuxClient.this.send((HttpExchange)exchange);
                    }
                    catch (IOException e) {
                        Log.warn((String)("Delayed send, retry: " + e));
                        Log.debug((Throwable)e);
                        BayeuxClient.this.send(exchange, true);
                    }
                }
            };
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Delay " + interval + " send of " + (Object)((Object)exchange)));
            }
            this._timer.schedule(task, interval);
        } else {
            try {
                this.send((HttpExchange)exchange);
            }
            catch (IOException e) {
                Log.warn((String)("Send, retry on fail: " + e));
                Log.debug((Throwable)e);
                return this.send(exchange, true);
            }
        }
        return true;
    }

    protected void send(HttpExchange exchange) throws IOException {
        exchange.reset();
        this.customize(exchange);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Send: using any connection=" + exchange));
        }
        this._httpClient.send(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInitialized(boolean b) {
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            this._initialized = b;
        }
    }

    protected boolean isInitialized() {
        return this._initialized;
    }

    protected void metaConnect(boolean success, Message message) {
        if (!success) {
            Log.warn((String)(((Object)((Object)this)).toString() + " " + message.toString()));
        }
    }

    protected void metaHandshake(boolean success, boolean reestablish, Message message) {
        if (!success) {
            Log.warn((String)(((Object)((Object)this)).toString() + " " + message.toString()));
        }
    }

    protected void metaPublishFail(Throwable e, Message[] messages) {
        Log.warn((String)(((Object)((Object)this)).toString() + ": " + e));
        Log.debug((Throwable)e);
    }

    protected String extendOut(String msg) {
        if (this._extensions == null) {
            return msg;
        }
        try {
            Message[] messages = this._msgPool.parse(msg);
            for (int i = 0; i < messages.length; ++i) {
                this.extendOut(messages[i]);
            }
            if (messages.length == 1 && msg.charAt(0) == '{') {
                return this._msgPool.getMsgJSON().toJSON((Object)messages[0]);
            }
            return this._msgPool.getMsgJSON().toJSON((Object)messages);
        }
        catch (IOException e) {
            Log.warn((Throwable)e);
            return msg;
        }
    }

    protected void extendOut(Message message) {
        if (this._extensions != null) {
            int i;
            Message m = message;
            if (m.getChannel().startsWith("/meta/")) {
                for (i = 0; m != null && i < this._extensions.length; ++i) {
                    m = this._extensions[i].sendMeta((Client)this, m);
                }
            } else {
                for (i = 0; m != null && i < this._extensions.length; ++i) {
                    m = this._extensions[i].send((Client)this, m);
                }
            }
            if (message != m) {
                message.clear();
                if (m != null) {
                    for (Map.Entry entry : m.entrySet()) {
                        message.put(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }

    protected void extendIn(Message message) {
        if (this._extensions != null) {
            int i;
            Message m = message;
            if (m.getChannel().startsWith("/meta/")) {
                i = this._extensions.length;
                while (m != null && i-- > 0) {
                    m = this._extensions[i].rcvMeta((Client)this, m);
                }
            } else {
                i = this._extensions.length;
                while (m != null && i-- > 0) {
                    m = this._extensions[i].rcv((Client)this, m);
                }
            }
            if (message != m) {
                message.clear();
                if (m != null) {
                    for (Map.Entry entry : m.entrySet()) {
                        message.put(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }

    protected class Publish
    extends Exchange {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Publish() {
            StringBuffer json;
            super("publish");
            StringBuffer stringBuffer = json = new StringBuffer(256);
            synchronized (stringBuffer) {
                ArrayQueue arrayQueue = BayeuxClient.this._outQ;
                synchronized (arrayQueue) {
                    int s = BayeuxClient.this._outQ.size();
                    if (s == 0) {
                        return;
                    }
                    for (int i = 0; i < s; ++i) {
                        Message message = (Message)BayeuxClient.this._outQ.getUnsafe(i);
                        message.put((Object)"clientId", (Object)BayeuxClient.this._clientId);
                        BayeuxClient.this.extendOut(message);
                        json.append(i == 0 ? (char)'[' : ',');
                        BayeuxClient.this._jsonOut.append(json, (Object)message);
                        if (!(message instanceof MessageImpl)) continue;
                        ((MessageImpl)message).decRef();
                    }
                    json.append(']');
                    BayeuxClient.this._outQ.clear();
                    this.setJson(json.toString());
                }
            }
        }

        protected Message[] getOutboundMessages() {
            try {
                return BayeuxClient.this._msgPool.parse(this._json);
            }
            catch (IOException e) {
                Log.warn((String)"Error converting outbound messages");
                if (Log.isDebugEnabled()) {
                    Log.debug((Throwable)e);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onResponseComplete() throws IOException {
            block11: {
                super.onResponseComplete();
                try {
                    ArrayQueue arrayQueue = BayeuxClient.this._outQ;
                    synchronized (arrayQueue) {
                        BayeuxClient.this.startBatch();
                        BayeuxClient.this._push = null;
                    }
                    if (this.getResponseStatus() == 200 && this._responses != null && this._responses.length > 0) {
                        for (int i = 0; i < this._responses.length; ++i) {
                            MessageImpl msg = (MessageImpl)this._responses[i];
                            BayeuxClient.this.deliver(null, (Message)msg);
                            if (!"/meta/disconnect".equals(msg.getChannel()) || !msg.isSuccessful()) continue;
                            if (BayeuxClient.this.isStarted()) {
                                try {
                                    BayeuxClient.this.stop();
                                }
                                catch (Exception e) {
                                    Log.ignore((Throwable)e);
                                }
                            }
                            break block11;
                        }
                        break block11;
                    }
                    Log.warn((String)("Publish, error=" + this.getResponseStatus()));
                }
                finally {
                    BayeuxClient.this.endBatch();
                }
            }
            this.recycle();
        }

        protected void onExpire() {
            super.onExpire();
            BayeuxClient.this.metaPublishFail(null, this.getOutboundMessages());
            if (BayeuxClient.this._disconnecting) {
                try {
                    BayeuxClient.this.stop();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
            }
        }

        protected void onConnectionFailed(Throwable ex) {
            super.onConnectionFailed(ex);
            BayeuxClient.this.metaPublishFail(ex, this.getOutboundMessages());
            if (BayeuxClient.this._disconnecting) {
                try {
                    BayeuxClient.this.stop();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
            }
        }

        protected void onException(Throwable ex) {
            super.onException(ex);
            BayeuxClient.this.metaPublishFail(ex, this.getOutboundMessages());
            if (BayeuxClient.this._disconnecting) {
                try {
                    BayeuxClient.this.stop();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
            }
        }
    }

    protected class Connect
    extends Exchange {
        String _connectString;

        Connect() {
            super("connect");
            this._connectString = "{\"channel\":\"/meta/connect\",\"clientId\":\"" + BayeuxClient.this._clientId + "\"," + "\"connectionType\":\"long-polling\"" + "}";
            this.setMessage(this._connectString);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onResponseComplete() throws IOException {
            super.onResponseComplete();
            if (!BayeuxClient.this.isRunning()) {
                return;
            }
            if (this.getResponseStatus() == 200 && this._responses != null && this._responses.length > 0) {
                try {
                    BayeuxClient.this.startBatch();
                    for (int i = 0; i < this._responses.length; ++i) {
                        Message msg = this._responses[i];
                        Map adviceField = (Map)msg.get((Object)"advice");
                        if (adviceField != null) {
                            BayeuxClient.this._advice = new Advice(adviceField);
                        }
                        if ("/meta/connect".equals(msg.get((Object)"channel"))) {
                            ArrayQueue arrayQueue;
                            Boolean successful = (Boolean)msg.get((Object)"successful");
                            if (successful != null && successful.booleanValue()) {
                                BayeuxClient.this.metaConnect(true, msg);
                                if (!BayeuxClient.this.isRunning()) {
                                }
                                arrayQueue = BayeuxClient.this._outQ;
                                synchronized (arrayQueue) {
                                    if (BayeuxClient.this._disconnecting) {
                                        continue;
                                    }
                                    if (!BayeuxClient.this.isInitialized()) {
                                        BayeuxClient.this.setInitialized(true);
                                        if (BayeuxClient.this._outQ.size() > 0) {
                                            BayeuxClient.this._push = new Publish();
                                            BayeuxClient.this.send((HttpExchange)BayeuxClient.this._push);
                                        }
                                    }
                                }
                                BayeuxClient.this._pull = new Connect();
                                BayeuxClient.this.send(BayeuxClient.this._pull, false);
                            } else {
                                BayeuxClient.this.setInitialized(false);
                                BayeuxClient.this.metaConnect(false, msg);
                                arrayQueue = BayeuxClient.this._outQ;
                                synchronized (arrayQueue) {
                                    if (!BayeuxClient.this.isRunning() || BayeuxClient.this._disconnecting) {
                                    }
                                }
                                if (BayeuxClient.this._advice != null && BayeuxClient.this._advice.isReconnectNone()) {
                                    throw new IOException("Connect failed, advice reconnect=none");
                                }
                                if (BayeuxClient.this._advice != null && BayeuxClient.this._advice.isReconnectHandshake()) {
                                    if (Log.isDebugEnabled()) {
                                        Log.debug((String)"connect received success=false, advice is to rehandshake");
                                    }
                                    BayeuxClient.this._pull = new Handshake();
                                    BayeuxClient.this.send(BayeuxClient.this._pull, true);
                                } else {
                                    if (Log.isDebugEnabled()) {
                                        Log.debug((String)"Assuming retry=reconnect");
                                    }
                                    this.resend(true);
                                }
                            }
                        }
                        BayeuxClient.this.deliver(null, msg);
                    }
                }
                finally {
                    BayeuxClient.this.endBatch();
                }
            } else {
                MessageImpl error = BayeuxClient.this._msgPool.newMessage();
                error.put((Object)"successful", (Object)Boolean.FALSE);
                error.put((Object)"status", (Object)this.getResponseStatus());
                error.put((Object)"content", (Object)this.getResponseContent());
                BayeuxClient.this.metaConnect(false, (Message)error);
                this.resend(true);
            }
            this.recycle();
        }

        protected void onExpire() {
            BayeuxClient.this.setInitialized(false);
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)"expired");
            BayeuxClient.this.metaConnect(false, (Message)error);
            this.resend(true);
        }

        protected void onConnectionFailed(Throwable ex) {
            BayeuxClient.this.setInitialized(false);
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)ex.toString());
            error.put((Object)"exception", (Object)ex);
            BayeuxClient.this.metaConnect(false, (Message)error);
            this.resend(true);
        }

        protected void onException(Throwable ex) {
            BayeuxClient.this.setInitialized(false);
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)ex.toString());
            error.put((Object)"exception", (Object)ex);
            BayeuxClient.this.metaConnect(false, (Message)error);
            this.resend(true);
        }
    }

    protected class Handshake
    extends Exchange {
        public static final String __HANDSHAKE = "[{\"channel\":\"/meta/handshake\",\"version\":\"0.9\",\"minimumVersion\":\"0.9\"}]";

        Handshake() {
            super("handshake");
            this.setMessage(__HANDSHAKE);
        }

        protected void onResponseComplete() throws IOException {
            super.onResponseComplete();
            if (!BayeuxClient.this.isRunning()) {
                return;
            }
            if (BayeuxClient.this._disconnecting) {
                MessageImpl error = BayeuxClient.this._msgPool.newMessage();
                error.put((Object)"successful", (Object)Boolean.FALSE);
                error.put((Object)"failure", (Object)"expired");
                BayeuxClient.this.metaHandshake(false, false, (Message)error);
                try {
                    BayeuxClient.this.stop();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
                return;
            }
            if (this.getResponseStatus() == 200 && this._responses != null && this._responses.length > 0) {
                MessageImpl response = (MessageImpl)this._responses[0];
                boolean successful = response.isSuccessful();
                Map adviceField = (Map)response.get((Object)"advice");
                if (adviceField != null) {
                    BayeuxClient.this._advice = new Advice(adviceField);
                }
                if (successful) {
                    BayeuxClient.this._handshook = true;
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Successful handshake, sending connect");
                    }
                    BayeuxClient.this._clientId = (String)response.get((Object)"clientId");
                    BayeuxClient.this.metaHandshake(true, BayeuxClient.this._handshook, (Message)response);
                    BayeuxClient.this._pull = new Connect();
                    BayeuxClient.this.send(BayeuxClient.this._pull, false);
                } else {
                    BayeuxClient.this.metaHandshake(false, false, (Message)response);
                    BayeuxClient.this._handshook = false;
                    if (BayeuxClient.this._advice != null && BayeuxClient.this._advice.isReconnectNone()) {
                        throw new IOException("Handshake failed with advice reconnect=none :" + this._responses[0]);
                    }
                    if (BayeuxClient.this._advice != null && BayeuxClient.this._advice.isReconnectHandshake()) {
                        BayeuxClient.this._pull = new Handshake();
                        if (!BayeuxClient.this.send(BayeuxClient.this._pull, true)) {
                            throw new IOException("Handshake, retries exhausted");
                        }
                    } else {
                        BayeuxClient.this._pull = new Connect();
                        if (!BayeuxClient.this.send(BayeuxClient.this._pull, true)) {
                            throw new IOException("Connect after handshake, retries exhausted");
                        }
                    }
                }
            } else {
                MessageImpl error = BayeuxClient.this._msgPool.newMessage();
                error.put((Object)"successful", (Object)Boolean.FALSE);
                error.put((Object)"status", (Object)new Integer(this.getResponseStatus()));
                error.put((Object)"content", (Object)this.getResponseContent());
                BayeuxClient.this.metaHandshake(false, false, (Message)error);
                this.resend(true);
            }
            this.recycle();
        }

        protected void onExpire() {
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)"expired");
            BayeuxClient.this.metaHandshake(false, false, (Message)error);
            this.resend(true);
        }

        protected void onConnectionFailed(Throwable ex) {
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)ex.toString());
            error.put((Object)"exception", (Object)ex);
            ex.printStackTrace();
            BayeuxClient.this.metaHandshake(false, false, (Message)error);
            this.resend(true);
        }

        protected void onException(Throwable ex) {
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)ex.toString());
            error.put((Object)"exception", (Object)ex);
            BayeuxClient.this.metaHandshake(false, false, (Message)error);
            this.resend(true);
        }
    }

    protected class Exchange
    extends ContentExchange {
        Message[] _responses;
        int _connectFailures;
        int _backoffRetries = 0;
        String _json;

        Exchange(String info) {
            this.setMethod("POST");
            this.setScheme(HttpSchemes.HTTP_BUFFER);
            this.setAddress(BayeuxClient.this._cometdAddress);
            this.setURI(BayeuxClient.this._path + "/" + info);
            this.setRequestContentType(BayeuxClient.this._formEncoded ? "application/x-www-form-urlencoded;charset=utf-8" : "text/json;charset=utf-8");
        }

        public int getBackoffRetries() {
            return this._backoffRetries;
        }

        public void incBackoffRetries() {
            ++this._backoffRetries;
        }

        protected void setMessage(String message) {
            message = BayeuxClient.this.extendOut(message);
            this.setJson(message);
        }

        protected void setJson(String json) {
            try {
                this._json = json;
                if (BayeuxClient.this._formEncoded) {
                    this.setRequestContent((Buffer)new ByteArrayBuffer("message=" + URLEncoder.encode(this._json, "utf-8")));
                } else {
                    this.setRequestContent((Buffer)new ByteArrayBuffer(this._json, "utf-8"));
                }
            }
            catch (Exception e) {
                Log.ignore((Throwable)e);
                this.setRequestContent((Buffer)new ByteArrayBuffer(this._json));
            }
        }

        protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
            super.onResponseStatus(version, status, reason);
        }

        protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
            super.onResponseHeader(name, value);
            if (!BayeuxClient.this.isRunning()) {
                return;
            }
            if (HttpHeaders.CACHE.getOrdinal(name) == 53) {
                String cname = null;
                String cvalue = null;
                QuotedStringTokenizer tok = new QuotedStringTokenizer(value.toString(), "=;", false, false);
                tok.setSingle(false);
                if (tok.hasMoreElements()) {
                    cname = tok.nextToken();
                }
                if (tok.hasMoreElements()) {
                    cvalue = tok.nextToken();
                }
                Cookie cookie = new Cookie(cname, cvalue);
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if ("Version".equalsIgnoreCase(token)) {
                        cookie.setVersion(Integer.parseInt(tok.nextToken()));
                        continue;
                    }
                    if ("Comment".equalsIgnoreCase(token)) {
                        cookie.setComment(tok.nextToken());
                        continue;
                    }
                    if ("Path".equalsIgnoreCase(token)) {
                        cookie.setPath(tok.nextToken());
                        continue;
                    }
                    if ("Domain".equalsIgnoreCase(token)) {
                        cookie.setDomain(tok.nextToken());
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase(token)) {
                        tok.nextToken();
                        continue;
                    }
                    if ("Max-Age".equalsIgnoreCase(token)) {
                        tok.nextToken();
                        continue;
                    }
                    if (!"Secure".equalsIgnoreCase(token)) continue;
                    cookie.setSecure(true);
                }
                BayeuxClient.this.setCookie(cookie);
            }
        }

        protected void onResponseComplete() throws IOException {
            if (!BayeuxClient.this.isRunning()) {
                return;
            }
            super.onResponseComplete();
            if (this.getResponseStatus() == 200) {
                String content = this.getResponseContent();
                if (content == null || content.length() == 0) {
                    throw new IllegalStateException();
                }
                this._responses = BayeuxClient.this._msgPool.parse(content);
                if (this._responses != null) {
                    for (int i = 0; i < this._responses.length; ++i) {
                        BayeuxClient.this.extendIn(this._responses[i]);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resend(boolean backoff) {
            boolean disconnecting;
            if (!BayeuxClient.this.isRunning()) {
                return;
            }
            ArrayQueue arrayQueue = BayeuxClient.this._outQ;
            synchronized (arrayQueue) {
                disconnecting = BayeuxClient.this._disconnecting;
            }
            if (disconnecting) {
                try {
                    BayeuxClient.this.stop();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
                return;
            }
            this.setJson(this._json);
            if (!BayeuxClient.this.send(this, backoff)) {
                Log.warn((String)"Retries exhausted");
            }
        }

        protected void recycle() {
            if (this._responses != null) {
                for (Message msg : this._responses) {
                    if (!(msg instanceof MessageImpl)) continue;
                    ((MessageImpl)msg).decRef();
                }
            }
            this._responses = null;
        }
    }
}

