/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client;

import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.cometd.bayeux.Bayeux;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Transport;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.client.transport.TransportRegistry;
import org.cometd.common.AbstractClientSession;
import org.cometd.common.HashMapMessage;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BayeuxClient
extends AbstractClientSession
implements Bayeux {
    public static final String LOG_LEVEL = "logLevel";
    public static final String BACKOFF_INCREMENT_OPTION = "backoffIncrement";
    public static final String MAX_BACKOFF_OPTION = "maxBackoff";
    public static final String BAYEUX_VERSION = "1.0";
    private final Logger logger = Log.getLogger((String)(((Object)((Object)this)).getClass().getName() + "@" + System.identityHashCode((Object)this)));
    private final TransportRegistry transportRegistry = new TransportRegistry();
    private final Map<String, Object> options = new ConcurrentHashMap<String, Object>();
    private final AtomicReference<BayeuxClientState> bayeuxClientState = new AtomicReference();
    private final Queue<Message.Mutable> messageQueue = new ConcurrentLinkedQueue<Message.Mutable>();
    private final HttpClientTransport.CookieProvider cookieProvider = new HttpClientTransport.StandardCookieProvider();
    private final TransportListener handshakeListener = new HandshakeTransportListener();
    private final TransportListener connectListener = new ConnectTransportListener();
    private final TransportListener disconnectListener = new DisconnectTransportListener();
    private final TransportListener publishListener = new PublishTransportListener();
    private volatile ScheduledExecutorService scheduler;
    private volatile boolean shutdownScheduler;
    private volatile long backoffIncrement;
    private volatile long maxBackoff;

    public BayeuxClient(String url, ClientTransport transport, ClientTransport ... transports) {
        this(url, (ScheduledExecutorService)null, transport, transports);
    }

    public BayeuxClient(String url, ScheduledExecutorService scheduler, ClientTransport transport, ClientTransport ... transports) {
        if (transport == null) {
            throw new IllegalArgumentException("Transport cannot be null");
        }
        this.scheduler = scheduler;
        this.transportRegistry.add(transport);
        for (ClientTransport t : transports) {
            this.transportRegistry.add(t);
        }
        for (String transportName : this.transportRegistry.getKnownTransports()) {
            ClientTransport clientTransport = this.transportRegistry.getTransport(transportName);
            if (!(clientTransport instanceof HttpClientTransport)) continue;
            HttpClientTransport httpTransport = (HttpClientTransport)clientTransport;
            httpTransport.setURL(url);
            httpTransport.setCookieProvider(this.cookieProvider);
        }
        this.bayeuxClientState.set(new DisconnectedState(null));
    }

    public long getBackoffIncrement() {
        return this.backoffIncrement;
    }

    public long getMaxBackoff() {
        return this.maxBackoff;
    }

    public String getCookie(String name) {
        HttpClientTransport.Cookie cookie = this.cookieProvider.getCookie(name);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public void setCookie(String name, String value) {
        this.setCookie(name, value, -1);
    }

    public void setCookie(String name, String value, int maxAge) {
        HttpClientTransport.Cookie cookie = new HttpClientTransport.Cookie(name, value, null, null, maxAge, false, 0, null);
        this.cookieProvider.setCookie(cookie);
    }

    public String getId() {
        return this.bayeuxClientState.get().clientId;
    }

    public boolean isConnected() {
        return this.isConnected(this.bayeuxClientState.get());
    }

    private boolean isConnected(BayeuxClientState bayeuxClientState) {
        return bayeuxClientState.type == State.CONNECTED;
    }

    public boolean isHandshook() {
        return this.isHandshook(this.bayeuxClientState.get());
    }

    private boolean isHandshook(BayeuxClientState bayeuxClientState) {
        return bayeuxClientState.type == State.CONNECTING || bayeuxClientState.type == State.CONNECTED || bayeuxClientState.type == State.UNCONNECTED;
    }

    private boolean isHandshaking(BayeuxClientState bayeuxClientState) {
        return bayeuxClientState.type == State.HANDSHAKING || bayeuxClientState.type == State.REHANDSHAKING;
    }

    public boolean isDisconnected() {
        return this.isDisconnected(this.bayeuxClientState.get());
    }

    private boolean isDisconnected(BayeuxClientState bayeuxClientState) {
        return bayeuxClientState.type == State.DISCONNECTING || bayeuxClientState.type == State.DISCONNECTED;
    }

    protected State getState() {
        return this.bayeuxClientState.get().type;
    }

    public void handshake() {
        this.handshake(null);
    }

    public void handshake(final Map<String, Object> handshakeFields) {
        this.initialize();
        List<String> allowedTransports = this.getAllowedTransports();
        final ClientTransport initialTransport = this.transportRegistry.getTransport(allowedTransports.get(0));
        initialTransport.init();
        this.logger.debug("Using initial transport {} from {}", new Object[]{initialTransport.getName(), allowedTransports});
        this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

            public BayeuxClientState create(BayeuxClientState oldState) {
                return new HandshakingState(handshakeFields, initialTransport);
            }
        });
    }

    public State handshake(long waitMs) {
        return this.handshake(null, waitMs);
    }

    public State handshake(Map<String, Object> template, long waitMs) {
        this.handshake(template);
        this.waitFor(waitMs, State.CONNECTING, State.DISCONNECTED);
        return this.getState();
    }

    protected boolean sendHandshake() {
        BayeuxClientState bayeuxClientState = this.bayeuxClientState.get();
        if (this.isHandshaking(bayeuxClientState)) {
            Message.Mutable message = this.newMessage();
            if (bayeuxClientState.handshakeFields != null) {
                message.putAll(bayeuxClientState.handshakeFields);
            }
            message.setChannel("/meta/handshake");
            message.put((Object)"supportedConnectionTypes", this.getAllowedTransports());
            message.put((Object)"version", (Object)BAYEUX_VERSION);
            if (message.getId() == null) {
                message.setId(this.newMessageId());
            }
            this.logger.debug("Handshaking with extra fields {}, transport {}", new Object[]{bayeuxClientState.handshakeFields, bayeuxClientState.transport});
            bayeuxClientState.send(this.handshakeListener, message);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(long waitMs, State state, State ... states) {
        long start = System.currentTimeMillis();
        ArrayList<State> waitForStates = new ArrayList<State>();
        waitForStates.add(state);
        waitForStates.addAll(Arrays.asList(states));
        BayeuxClient bayeuxClient = this;
        synchronized (bayeuxClient) {
            State currentState;
            while (System.currentTimeMillis() - start < waitMs) {
                currentState = this.getState();
                for (State s : waitForStates) {
                    if (s != currentState) continue;
                    return true;
                }
                try {
                    ((Object)((Object)this)).wait(waitMs);
                }
                catch (InterruptedException x) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            currentState = this.getState();
            for (State s : waitForStates) {
                if (s != currentState) continue;
                return true;
            }
            return false;
        }
    }

    protected boolean sendConnect() {
        BayeuxClientState bayeuxClientState = this.bayeuxClientState.get();
        if (this.isHandshook(bayeuxClientState)) {
            Message.Mutable message = this.newMessage();
            message.setChannel("/meta/connect");
            message.put((Object)"connectionType", (Object)bayeuxClientState.transport.getName());
            if (bayeuxClientState.type == State.CONNECTING || bayeuxClientState.type == State.UNCONNECTED) {
                message.getAdvice(true).put("timeout", 0);
            }
            this.logger.debug("Connecting, transport {}", new Object[]{bayeuxClientState.transport});
            bayeuxClientState.send(this.connectListener, message);
            return true;
        }
        return false;
    }

    protected ChannelId newChannelId(String channelId) {
        AbstractClientSession.AbstractSessionChannel channel = (AbstractClientSession.AbstractSessionChannel)this.getChannels().get(channelId);
        return channel == null ? new ChannelId(channelId) : channel.getChannelId();
    }

    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new BayeuxClientChannel(channelId);
    }

    protected void sendBatch() {
        Message.Mutable[] messages;
        if (this.canSend() && (messages = this.takeMessages()).length > 0) {
            this.sendMessages(messages);
        }
    }

    protected boolean sendMessages(Message.Mutable ... messages) {
        BayeuxClientState bayeuxClientState = this.bayeuxClientState.get();
        if (bayeuxClientState.type == State.CONNECTING || this.isConnected(bayeuxClientState)) {
            bayeuxClientState.send(this.publishListener, messages);
            return true;
        }
        this.failMessages(null, (Message[])messages);
        return false;
    }

    private Message.Mutable[] takeMessages() {
        LinkedList<Message.Mutable> queue = new LinkedList<Message.Mutable>(this.messageQueue);
        this.messageQueue.removeAll(queue);
        return queue.toArray(new Message.Mutable[queue.size()]);
    }

    public void disconnect() {
        this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

            public BayeuxClientState create(BayeuxClientState oldState) {
                if (BayeuxClient.this.isConnected(oldState)) {
                    return new DisconnectingState(oldState.transport, oldState.clientId);
                }
                return new DisconnectedState(oldState.transport);
            }
        });
    }

    public void abort() {
        this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

            public BayeuxClientState create(BayeuxClientState oldState) {
                return new AbortedState(oldState.transport);
            }
        });
    }

    protected void processHandshake(final Message.Mutable handshake) {
        this.logger.debug("Processing handshake {}", new Object[]{handshake});
        if (handshake.isSuccessful()) {
            ClientTransport newTransport;
            Object[] serverTransports = (Object[])handshake.get((Object)"supportedConnectionTypes");
            List<ClientTransport> negotiatedTransports = this.transportRegistry.negotiate(serverTransports, BAYEUX_VERSION);
            ClientTransport clientTransport = newTransport = negotiatedTransports.isEmpty() ? null : negotiatedTransports.get(0);
            if (newTransport == null) {
                String error = "405:c" + this.transportRegistry.getAllowedTransports() + ",s" + Arrays.toString(serverTransports) + ":no transport";
                handshake.setSuccessful(false);
                handshake.put((Object)"error", (Object)error);
                this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                    public BayeuxClientState create(BayeuxClientState oldState) {
                        return new DisconnectedState(oldState.transport);
                    }

                    public void postCreate() {
                        BayeuxClient.this.receive(handshake);
                    }
                });
            } else {
                this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                    public BayeuxClientState create(BayeuxClientState oldState) {
                        String action;
                        if (newTransport != oldState.transport) {
                            oldState.transport.reset();
                            newTransport.init();
                        }
                        if ("retry".equals(action = BayeuxClient.this.getAdviceAction(handshake.getAdvice(), "retry"))) {
                            return new ConnectingState(oldState.handshakeFields, handshake.getAdvice(), newTransport, handshake.getClientId());
                        }
                        if ("none".equals(action)) {
                            return new DisconnectedState(oldState.transport);
                        }
                        return null;
                    }

                    public void postCreate() {
                        BayeuxClient.this.receive(handshake);
                    }
                });
            }
        } else {
            this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                public BayeuxClientState create(BayeuxClientState oldState) {
                    String action = BayeuxClient.this.getAdviceAction(handshake.getAdvice(), "handshake");
                    if ("handshake".equals(action)) {
                        return new RehandshakingState(oldState.handshakeFields, oldState.transport, oldState.nextBackoff());
                    }
                    if ("none".equals(action)) {
                        return new DisconnectedState(oldState.transport);
                    }
                    return null;
                }

                public void postCreate() {
                    BayeuxClient.this.receive(handshake);
                }
            });
        }
    }

    protected void processConnect(final Message.Mutable connect) {
        this.logger.debug("Processing connect {}", new Object[]{connect});
        this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

            public BayeuxClientState create(BayeuxClientState oldState) {
                Map<String, Object> advice = connect.getAdvice();
                if (advice == null) {
                    advice = oldState.advice;
                }
                String action = BayeuxClient.this.getAdviceAction(advice, "retry");
                if (connect.isSuccessful()) {
                    if ("retry".equals(action)) {
                        return new ConnectedState(oldState.handshakeFields, advice, oldState.transport, oldState.clientId);
                    }
                } else {
                    if ("handshake".equals(action)) {
                        return new RehandshakingState(oldState.handshakeFields, oldState.transport, 0L);
                    }
                    if ("retry".equals(action)) {
                        return new UnconnectedState(oldState.handshakeFields, advice, oldState.transport, oldState.clientId, oldState.nextBackoff());
                    }
                    if ("none".equals(action)) {
                        return new DisconnectedState(oldState.transport);
                    }
                }
                return null;
            }

            public void postCreate() {
                BayeuxClient.this.receive(connect);
            }
        });
    }

    protected void processDisconnect(final Message.Mutable disconnect) {
        this.logger.debug("Processing disconnect {}", new Object[]{disconnect});
        this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

            public BayeuxClientState create(BayeuxClientState oldState) {
                return new DisconnectedState(oldState.transport);
            }

            public void postCreate() {
                BayeuxClient.this.receive(disconnect);
            }
        });
    }

    private String getAdviceAction(Map<String, Object> advice, String defaultResult) {
        String action = defaultResult;
        if (advice != null && advice.containsKey("reconnect")) {
            action = (String)advice.get("reconnect");
        }
        return action;
    }

    protected boolean scheduleHandshake(long interval, long backoff) {
        return this.scheduleAction(new Runnable(){

            public void run() {
                BayeuxClient.this.sendHandshake();
            }
        }, interval, backoff);
    }

    protected boolean scheduleConnect(long interval, long backoff) {
        return this.scheduleAction(new Runnable(){

            public void run() {
                BayeuxClient.this.sendConnect();
            }
        }, interval, backoff);
    }

    private boolean scheduleAction(Runnable action, long interval, long backoff) {
        ScheduledExecutorService scheduler = this.scheduler;
        if (scheduler != null) {
            try {
                scheduler.schedule(action, interval + backoff, TimeUnit.MILLISECONDS);
                return true;
            }
            catch (RejectedExecutionException x) {
                this.logger.debug((Throwable)x);
            }
        }
        return false;
    }

    public List<String> getAllowedTransports() {
        return this.transportRegistry.getAllowedTransports();
    }

    public Set<String> getKnownTransportNames() {
        return this.transportRegistry.getKnownTransports();
    }

    public Transport getTransport(String transport) {
        return this.transportRegistry.getTransport(transport);
    }

    protected void initialize() {
        Long backoffIncrement;
        String logLevel = (String)this.getOption(LOG_LEVEL);
        if (logLevel != null) {
            this.logger.setDebugEnabled("debug".equals(logLevel));
        }
        if ((backoffIncrement = (Long)this.getOption(BACKOFF_INCREMENT_OPTION)) == null) {
            backoffIncrement = 1000L;
        }
        this.backoffIncrement = backoffIncrement;
        Long maxBackoff = (Long)this.getOption(MAX_BACKOFF_OPTION);
        if (maxBackoff == null) {
            maxBackoff = 30000L;
        }
        this.maxBackoff = maxBackoff;
        if (this.scheduler == null) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.shutdownScheduler = true;
        }
    }

    protected void terminate() {
        Message.Mutable[] messages = this.takeMessages();
        this.failMessages(null, (Message[])messages);
        this.cookieProvider.clear();
        if (this.shutdownScheduler) {
            this.shutdownScheduler = false;
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
    }

    public Object getOption(String qualifiedName) {
        return this.options.get(qualifiedName);
    }

    public void setOption(String qualifiedName, Object value) {
        this.options.put(qualifiedName, value);
    }

    public Set<String> getOptionNames() {
        return this.options.keySet();
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    protected Message.Mutable newMessage() {
        return new HashMapMessage();
    }

    protected void enqueueSend(Message.Mutable message) {
        if (this.canSend()) {
            boolean sent = this.sendMessages(message);
            this.logger.debug("{} message {}", new Object[]{sent ? "Sent" : "Failed", message});
        } else {
            this.messageQueue.offer(message);
            this.logger.debug("Enqueued message {} (batching: {})", new Object[]{message, this.isBatching()});
        }
    }

    private boolean canSend() {
        return !this.isBatching() && !this.isHandshaking(this.bayeuxClientState.get());
    }

    protected void failMessages(Throwable x, Message ... messages) {
        for (Message message : messages) {
            Message.Mutable failed = this.newMessage();
            failed.setId(message.getId());
            failed.setSuccessful(false);
            failed.setChannel(message.getChannel());
            failed.put((Object)"message", (Object)messages);
            if (x != null) {
                failed.put((Object)"exception", (Object)x);
            }
            this.receive(failed);
        }
    }

    public void onSending(Message[] messages) {
    }

    public void onMessages(List<Message.Mutable> messages) {
    }

    public void onFailure(Throwable x, Message[] messages) {
        this.logger.info(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBayeuxClientState(BayeuxClientStateUpdater updater) {
        BayeuxClientState newState = null;
        boolean updated = false;
        while (!updated) {
            BayeuxClientState oldState = this.bayeuxClientState.get();
            newState = updater.create(oldState);
            if (newState == null) {
                throw new IllegalStateException();
            }
            if (!oldState.isUpdateableTo(newState)) {
                this.logger.debug("State not updateable : {} -> {}", new Object[]{oldState, newState});
                break;
            }
            updated = this.bayeuxClientState.compareAndSet(oldState, newState);
            this.logger.debug("State update" + (updated ? "" : " failed (concurrent update)") + ": {} -> {}", new Object[]{oldState, newState});
        }
        updater.postCreate();
        if (updated) {
            newState.execute();
            BayeuxClient bayeuxClient = this;
            synchronized (bayeuxClient) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    private class DisconnectingState
    extends BayeuxClientState {
        private DisconnectingState(ClientTransport transport, String clientId) {
            super(State.DISCONNECTING, null, null, transport, clientId, 0L);
        }

        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.DISCONNECTED;
        }

        protected void execute() {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel("/meta/disconnect");
            this.send(BayeuxClient.this.disconnectListener, message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnconnectedState
    extends BayeuxClientState {
        private UnconnectedState(Map<String, Object> handshakeFields, Map<String, Object> advice, ClientTransport transport, String clientId, long backoff) {
            super(State.UNCONNECTED, handshakeFields, advice, transport, clientId, backoff);
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.CONNECTED || newState.type == State.UNCONNECTED || newState.type == State.REHANDSHAKING || newState.type == State.DISCONNECTED;
        }

        @Override
        protected void execute() {
            BayeuxClient.this.scheduleConnect(this.getInterval(), this.backoff);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectedState
    extends BayeuxClientState {
        private ConnectedState(Map<String, Object> handshakeFields, Map<String, Object> advice, ClientTransport transport, String clientId) {
            super(State.CONNECTED, handshakeFields, advice, transport, clientId, 0L);
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.CONNECTED || newState.type == State.UNCONNECTED || newState.type == State.REHANDSHAKING || newState.type == State.DISCONNECTING || newState.type == State.DISCONNECTED;
        }

        @Override
        protected void execute() {
            BayeuxClient.this.scheduleConnect(this.getInterval(), this.backoff);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectingState
    extends BayeuxClientState {
        private ConnectingState(Map<String, Object> handshakeFields, Map<String, Object> advice, ClientTransport transport, String clientId) {
            super(State.CONNECTING, handshakeFields, advice, transport, clientId, 0L);
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.CONNECTED || newState.type == State.UNCONNECTED || newState.type == State.REHANDSHAKING || newState.type == State.DISCONNECTING || newState.type == State.DISCONNECTED;
        }

        @Override
        protected void execute() {
            BayeuxClient.this.sendBatch();
            BayeuxClient.this.scheduleConnect(this.getInterval(), this.backoff);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RehandshakingState
    extends BayeuxClientState {
        public RehandshakingState(Map<String, Object> handshakeFields, ClientTransport transport, long backoff) {
            super(State.REHANDSHAKING, handshakeFields, null, transport, null, backoff);
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.CONNECTING || newState.type == State.REHANDSHAKING || newState.type == State.DISCONNECTED;
        }

        @Override
        protected void execute() {
            BayeuxClient.this.scheduleHandshake(this.getInterval(), this.backoff);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HandshakingState
    extends BayeuxClientState {
        private HandshakingState(Map<String, Object> handshakeFields, ClientTransport transport) {
            super(State.HANDSHAKING, handshakeFields, null, transport, null, 0L);
        }

        @Override
        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.REHANDSHAKING || newState.type == State.CONNECTING || newState.type == State.DISCONNECTED;
        }

        @Override
        protected void execute() {
            BayeuxClient.this.sendHandshake();
        }
    }

    private class AbortedState
    extends DisconnectedState {
        private AbortedState(ClientTransport transport) {
            super(transport);
        }

        protected void execute() {
            this.transport.abort();
            super.execute();
        }
    }

    private class DisconnectedState
    extends BayeuxClientState {
        private DisconnectedState(ClientTransport transport) {
            super(State.DISCONNECTED, null, null, transport, null, 0L);
        }

        protected boolean isUpdateableTo(BayeuxClientState newState) {
            return newState.type == State.HANDSHAKING;
        }

        protected void execute() {
            this.transport.reset();
            BayeuxClient.this.terminate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BayeuxClientState {
        protected final State type;
        protected final Map<String, Object> handshakeFields;
        protected final Map<String, Object> advice;
        protected final ClientTransport transport;
        protected final String clientId;
        protected final long backoff;

        private BayeuxClientState(State type, Map<String, Object> handshakeFields, Map<String, Object> advice, ClientTransport transport, String clientId, long backoff) {
            this.type = type;
            this.handshakeFields = handshakeFields;
            this.advice = advice;
            this.transport = transport;
            this.clientId = clientId;
            this.backoff = backoff;
        }

        protected long getInterval() {
            long result = 0L;
            if (this.advice != null && this.advice.containsKey("interval")) {
                result = ((Number)this.advice.get("interval")).longValue();
            }
            return result;
        }

        protected void send(TransportListener listener, Message.Mutable ... messages) {
            List<Message.Mutable> messageList = Arrays.asList(messages);
            Iterator<Message.Mutable> iterator = messageList.iterator();
            while (iterator.hasNext()) {
                Message.Mutable message = iterator.next();
                if (message.getId() == null) {
                    message.setId(BayeuxClient.this.newMessageId());
                }
                if (this.clientId != null) {
                    message.setClientId(this.clientId);
                }
                if (BayeuxClient.this.extendSend(message)) continue;
                iterator.remove();
            }
            if (!messageList.isEmpty()) {
                BayeuxClient.this.logger.debug("Sending messages {}", new Object[]{messageList});
                this.transport.send(listener, messageList.toArray(new Message.Mutable[messageList.size()]));
            }
        }

        private long nextBackoff() {
            return Math.min(this.backoff + BayeuxClient.this.getBackoffIncrement(), BayeuxClient.this.getMaxBackoff());
        }

        protected abstract boolean isUpdateableTo(BayeuxClientState var1);

        protected abstract void execute();

        public String toString() {
            return this.type.toString();
        }
    }

    private abstract class BayeuxClientStateUpdater {
        private BayeuxClientStateUpdater() {
        }

        public abstract BayeuxClientState create(BayeuxClientState var1);

        public void postCreate() {
        }
    }

    protected class BayeuxClientChannel
    extends AbstractClientSession.AbstractSessionChannel {
        protected BayeuxClientChannel(ChannelId channelId) {
            super(channelId);
        }

        public ClientSession getSession() {
            return BayeuxClient.this;
        }

        protected void sendSubscribe() {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel("/meta/subscribe");
            message.put((Object)"subscription", (Object)this.getId());
            BayeuxClient.this.enqueueSend(message);
        }

        protected void sendUnSubscribe() {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel("/meta/unsubscribe");
            message.put((Object)"subscription", (Object)this.getId());
            BayeuxClient.this.enqueueSend(message);
        }

        public void publish(Object data) {
            this.publish(data, null);
        }

        public void publish(Object data, String messageId) {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel(this.getId());
            message.setData(data);
            if (messageId != null) {
                message.setId(String.valueOf(messageId));
            }
            BayeuxClient.this.enqueueSend(message);
        }
    }

    private class DisconnectTransportListener
    extends PublishTransportListener {
        private DisconnectTransportListener() {
        }

        protected void onFailure(Throwable x, Message[] messages) {
            BayeuxClient.this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                public BayeuxClientState create(BayeuxClientState oldState) {
                    return new DisconnectedState(oldState.transport);
                }
            });
            super.onFailure(x, messages);
        }

        protected void processMessage(Message.Mutable message) {
            if ("/meta/disconnect".equals(message.getChannel())) {
                BayeuxClient.this.processDisconnect(message);
            } else {
                super.processMessage(message);
            }
        }
    }

    private class ConnectTransportListener
    extends PublishTransportListener {
        private ConnectTransportListener() {
        }

        protected void onFailure(Throwable x, Message[] messages) {
            BayeuxClient.this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                public BayeuxClientState create(BayeuxClientState oldState) {
                    return new UnconnectedState(oldState.handshakeFields, oldState.advice, oldState.transport, oldState.clientId, oldState.nextBackoff());
                }
            });
            super.onFailure(x, messages);
        }

        protected void processMessage(Message.Mutable message) {
            if ("/meta/connect".equals(message.getChannel())) {
                BayeuxClient.this.processConnect(message);
            } else {
                super.processMessage(message);
            }
        }
    }

    private class HandshakeTransportListener
    extends PublishTransportListener {
        private HandshakeTransportListener() {
        }

        protected void onFailure(Throwable x, Message[] messages) {
            BayeuxClient.this.updateBayeuxClientState(new BayeuxClientStateUpdater(){

                public BayeuxClientState create(BayeuxClientState oldState) {
                    return new RehandshakingState(oldState.handshakeFields, oldState.transport, oldState.nextBackoff());
                }
            });
            super.onFailure(x, messages);
        }

        protected void processMessage(Message.Mutable message) {
            if ("/meta/handshake".equals(message.getChannel())) {
                BayeuxClient.this.processHandshake(message);
            } else {
                super.processMessage(message);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PublishTransportListener
    implements TransportListener {
        private PublishTransportListener() {
        }

        @Override
        public void onSending(Message[] messages) {
            BayeuxClient.this.onSending(messages);
        }

        @Override
        public void onMessages(List<Message.Mutable> messages) {
            BayeuxClient.this.onMessages(messages);
            for (Message.Mutable message : messages) {
                this.processMessage(message);
            }
        }

        @Override
        public void onConnectException(Throwable x, Message[] messages) {
            this.onFailure(x, messages);
        }

        @Override
        public void onException(Throwable x, Message[] messages) {
            this.onFailure(x, messages);
        }

        @Override
        public void onExpire(Message[] messages) {
            this.onFailure(new TimeoutException("expired"), messages);
        }

        @Override
        public void onProtocolError(String info, Message[] messages) {
            this.onFailure(new ProtocolException(info), messages);
        }

        protected void processMessage(Message.Mutable message) {
            BayeuxClient.this.receive(message);
        }

        protected void onFailure(Throwable x, Message[] messages) {
            BayeuxClient.this.onFailure(x, messages);
            BayeuxClient.this.failMessages(x, messages);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNCONNECTED,
        HANDSHAKING,
        REHANDSHAKING,
        CONNECTING,
        CONNECTED,
        DISCONNECTING,
        DISCONNECTED;

    }
}

