/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.AbstractTransport;
import org.cometd.common.JSONContext;
import org.cometd.common.JettyJSONContextClient;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientTransport
extends AbstractTransport {
    public static final String TIMEOUT_OPTION = "timeout";
    public static final String INTERVAL_OPTION = "interval";
    public static final String MAX_NETWORK_DELAY_OPTION = "maxNetworkDelay";
    public static final String JSON_CONTEXT = "jsonContext";
    protected final Logger _logger = Log.getLogger((String)((Object)((Object)this)).getClass().getName());
    private JSONContext.Client jsonContext;

    protected ClientTransport(String name, Map<String, Object> options) {
        super(name, options);
    }

    public void init() {
        this.jsonContext = (JSONContext.Client)this.getOption(JSON_CONTEXT);
        if (this.jsonContext == null) {
            this.jsonContext = new JettyJSONContextClient();
        }
    }

    public void setDebugEnabled(boolean enabled) {
        this._logger.setDebugEnabled(enabled);
    }

    public abstract void abort();

    public abstract void reset();

    public abstract boolean accept(String var1);

    public abstract void send(TransportListener var1, Message.Mutable ... var2);

    protected List<Message.Mutable> parseMessages(String content) throws ParseException {
        return Arrays.asList(this.jsonContext.parse(content));
    }

    protected String generateJSON(Message.Mutable[] messages) {
        return this.jsonContext.generate(messages);
    }
}

