/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.AbstractTransport;
import org.cometd.common.JSONContext;
import org.cometd.common.JettyJSONContextClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientTransport
extends AbstractTransport {
    public static final String TIMEOUT_OPTION = "timeout";
    public static final String INTERVAL_OPTION = "interval";
    public static final String MAX_NETWORK_DELAY_OPTION = "maxNetworkDelay";
    public static final String JSON_CONTEXT = "jsonContext";
    protected final Logger logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + System.identityHashCode((Object)this)));
    private boolean debug;
    private JSONContext.Client jsonContext;

    protected ClientTransport(String name, Map<String, Object> options) {
        super(name, options);
    }

    public void init() {
        this.jsonContext = (JSONContext.Client)this.getOption(JSON_CONTEXT);
        if (this.jsonContext == null) {
            this.jsonContext = new JettyJSONContextClient();
        }
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public void setDebugEnabled(boolean enabled) {
        this.debug = enabled;
    }

    protected void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.logger.info(message, args);
        } else {
            this.logger.debug(message, args);
        }
    }

    public abstract void abort();

    public void reset() {
    }

    public void terminate() {
    }

    public abstract boolean accept(String var1);

    public abstract void send(TransportListener var1, Message.Mutable ... var2);

    protected List<Message.Mutable> parseMessages(String content) throws ParseException {
        return new ArrayList<Message.Mutable>(Arrays.asList(this.jsonContext.parse(content)));
    }

    protected String generateJSON(Message.Mutable[] messages) {
        return this.jsonContext.generate(messages);
    }
}

