/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.AbstractTransport;
import org.cometd.common.JSONContext;
import org.cometd.common.JettyJSONContextClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientTransport
extends AbstractTransport {
    public static final String TIMEOUT_OPTION = "timeout";
    public static final String INTERVAL_OPTION = "interval";
    public static final String MAX_NETWORK_DELAY_OPTION = "maxNetworkDelay";
    public static final String JSON_CONTEXT = "jsonContext";
    protected final Logger logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + System.identityHashCode((Object)this)));
    private JSONContext.Client jsonContext;

    protected ClientTransport(String name, Map<String, Object> options) {
        super(name, options);
    }

    public void init() {
        Object option = this.getOption(JSON_CONTEXT);
        if (option == null) {
            this.jsonContext = new JettyJSONContextClient();
        } else if (option instanceof String) {
            try {
                Class<?> jsonContextClass = Thread.currentThread().getContextClassLoader().loadClass((String)option);
                if (!JSONContext.Client.class.isAssignableFrom(jsonContextClass)) {
                    throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + option);
                }
                this.jsonContext = (JSONContext.Client)jsonContextClass.newInstance();
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + option, x);
            }
        } else if (option instanceof JSONContext.Client) {
            this.jsonContext = (JSONContext.Client)option;
        } else {
            throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + option);
        }
        this.setOption(JSON_CONTEXT, this.jsonContext);
    }

    public abstract void abort();

    public void terminate() {
    }

    public abstract boolean accept(String var1);

    public abstract void send(TransportListener var1, Message.Mutable ... var2);

    protected List<Message.Mutable> parseMessages(String content) throws ParseException {
        return new ArrayList<Message.Mutable>(Arrays.asList(this.jsonContext.parse(content)));
    }

    protected String generateJSON(Message.Mutable[] messages) {
        return this.jsonContext.generate(messages);
    }

    public static interface Factory {
        public ClientTransport newClientTransport(Map<String, Object> var1);
    }
}

