/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import org.cometd.Bayeux;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Extension;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.cometd.RemoveListener;
import org.cometd.oort.OortComet;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Oort
extends AbstractLifeCycle {
    public static final String OORT_URL = "oort.url";
    public static final String OORT_CLOUD = "oort.cloud";
    public static final String OORT_CHANNELS = "oort.channels";
    public static final String OORT_ATTRIBUTE = "org.cometd.oort.Oort";
    protected String _url;
    protected String _secret;
    protected Bayeux _bayeux;
    protected HttpClient _httpClient = new HttpClient();
    protected Timer _timer = new Timer();
    protected Random _random = new SecureRandom();
    protected Client _oortClient;
    protected List<MessageListener> _oortMessageListeners = new ArrayList<MessageListener>();
    protected Map<String, OortComet> _knownCommets = new HashMap<String, OortComet>();
    protected Set<String> _channels = new HashSet<String>();

    Oort(String id, Bayeux bayeux) {
        this._url = id;
        this._bayeux = bayeux;
        this._secret = Long.toHexString(this._random.nextLong());
        this._oortClient = this._bayeux.newClient("oort");
        this._oortClient.addListener((ClientListener)new RootOortClientListener());
        this._bayeux.getChannel("/oort/cloud", true).subscribe(this._oortClient);
        bayeux.addExtension((Extension)new OortExtension());
    }

    public Bayeux getBayeux() {
        return this._bayeux;
    }

    public String getURL() {
        return this._url;
    }

    public String getSecret() {
        return this._secret;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._httpClient.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OortComet observeComet(String cometUrl) {
        Oort oort = this;
        synchronized (oort) {
            if (this._url.equals(cometUrl)) {
                return null;
            }
            OortComet comet = this._knownCommets.get(cometUrl);
            if (comet == null) {
                try {
                    comet = new OortComet(this, cometUrl);
                    this._knownCommets.put(cometUrl, comet);
                    comet.start();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return comet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void observedComets(Set<String> comets) {
        Oort oort = this;
        synchronized (oort) {
            Set<String> known = this.getKnownComets();
            for (String comet : comets) {
                if (this._url.equals(comet)) continue;
                this.observeComet(comet);
            }
            known = this.getKnownComets();
            if (!comets.containsAll(known)) {
                this._bayeux.getChannel("/oort/cloud", true).publish(this._oortClient, known, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKnownComets() {
        Oort oort = this;
        synchronized (oort) {
            HashSet<String> comets = new HashSet<String>(this._knownCommets.keySet());
            comets.add(this._url);
            return comets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void observeChannel(String channelId) {
        Oort oort = this;
        synchronized (oort) {
            if (!this._channels.contains(channelId)) {
                this._channels.add(channelId);
                for (OortComet comet : this._knownCommets.values()) {
                    if (!comet.isHandshook()) continue;
                    comet.subscribe(channelId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOortMessageListener(MessageListener listener) {
        Oort oort = this;
        synchronized (oort) {
            this._oortMessageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOortClientListener(MessageListener listener) {
        Oort oort = this;
        synchronized (oort) {
            return this._oortMessageListeners.remove(listener);
        }
    }

    public boolean isOort(Client client) {
        return client == this._oortClient;
    }

    public String toString() {
        return this._url;
    }

    protected void oortHandshook(String oortUrl, String oortSecret, String clientId) {
        Log.info((String)((Object)((Object)this) + ": " + clientId + " is oort " + oortUrl));
        if (!this._knownCommets.containsKey(oortUrl)) {
            this.observeComet(oortUrl);
        }
        Client client = this._bayeux.getClient(clientId);
        client.addExtension((Extension)new RemoteOortClientExtension());
    }

    protected class RootOortClientListener
    implements RemoveListener,
    MessageListener {
        protected RootOortClientListener() {
        }

        public void removed(String clientId, boolean timeout) {
        }

        public void deliver(Client fromClient, Client toClient, Message msg) {
            String channelId = msg.getChannel();
            if (msg.getData() != null && channelId.equals("/oort/cloud") && msg.getData() instanceof Object[]) {
                Object[] data = (Object[])msg.getData();
                HashSet<String> comets = new HashSet<String>();
                for (Object o : data) {
                    comets.add(o.toString());
                }
                Oort.this.observedComets(comets);
            }
        }
    }

    protected class RemoteOortClientExtension
    implements Extension {
        protected RemoteOortClientExtension() {
        }

        public boolean queueMaxed(Client from, Client client, Message message) {
            boolean send = from != Oort.this._oortClient || message.getChannel().startsWith("/oort/");
            return send;
        }

        public Message rcv(Client from, Message message) {
            return message;
        }

        public Message rcvMeta(Client from, Message message) {
            return message;
        }

        public Message send(Client from, Message message) {
            boolean send = !Oort.this.isOort(from) || message.getChannel().startsWith("/oort/");
            return send ? message : null;
        }

        public Message sendMeta(Client from, Message message) {
            return message;
        }
    }

    protected class OortExtension
    implements Extension {
        protected OortExtension() {
        }

        public Message rcv(Client from, Message message) {
            return message;
        }

        public Message rcvMeta(Client from, Message message) {
            return message;
        }

        public Message send(Client from, Message message) {
            return message;
        }

        public Message sendMeta(Client from, Message message) {
            if (message.getChannel().equals("/meta/handshake") && Boolean.TRUE.equals(message.get((Object)"successful"))) {
                Map oort;
                Map rcvExt;
                Message rcv = message.getAssociated();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)(Oort.this._url + " --> " + rcv));
                }
                if ((rcvExt = (Map)rcv.get((Object)"ext")) != null && (oort = (Map)rcvExt.get("oort")) != null) {
                    String cometUrl = (String)oort.get("comet");
                    String oortUrl = (String)oort.get("oort");
                    if (Oort.this.getURL().equals(cometUrl)) {
                        String oortSecret = (String)oort.get("oortSecret");
                        Oort.this.oortHandshook(oortUrl, oortSecret, message.getClientId());
                        Object ext = message.get((Object)"ext");
                        HashMap<String, Map> sndExt = (HashMap<String, Map>)(ext instanceof JSON.Literal ? JSON.parse((String)ext.toString()) : ext);
                        if (sndExt == null) {
                            sndExt = new HashMap<String, Map>();
                        }
                        oort.put("cometSecret", Oort.this.getSecret());
                        sndExt.put("oort", oort);
                        message.put((Object)"ext", sndExt);
                    }
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)(Oort.this._url + " <-- " + message));
                }
            }
            return message;
        }
    }
}

