/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.SessionChannel;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.OortComet;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;

public class Oort {
    public static final String OORT_URL = "oort.url";
    public static final String OORT_CLOUD = "oort.cloud";
    public static final String OORT_CHANNELS = "oort.channels";
    public static final String OORT_ATTRIBUTE = "org.cometd.oort.Oort";
    protected final String _url;
    protected final String _secret;
    protected final BayeuxServer _bayeux;
    protected final HttpClient _httpClient;
    protected final Random _random = new SecureRandom();
    protected final LocalSession _oortSession;
    protected final Map<String, OortComet> _knownCommets = new ConcurrentHashMap<String, OortComet>();
    protected final Set<String> _channels = Collections.newSetFromMap(new ConcurrentHashMap());

    Oort(String id, BayeuxServer bayeux) {
        this._url = id;
        this._bayeux = bayeux;
        this._secret = Long.toHexString(this._random.nextLong());
        this._httpClient = new HttpClient();
        this._oortSession = this._bayeux.newLocalSession("oort");
        bayeux.addExtension((BayeuxServer.Extension)new OortExtension());
        try {
            this._httpClient.start();
            this._oortSession.handshake();
            this._oortSession.getChannel("/oort/cloud").subscribe((SessionChannel.SubscriberListener)new RootOortClientListener());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BayeuxServer getBayeux() {
        return this._bayeux;
    }

    public String getURL() {
        return this._url;
    }

    public String getSecret() {
        return this._secret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OortComet observeComet(String cometUrl) {
        Oort oort = this;
        synchronized (oort) {
            if (this._url.equals(cometUrl)) {
                return null;
            }
            OortComet comet = this._knownCommets.get(cometUrl);
            if (comet == null) {
                try {
                    comet = new OortComet(this, cometUrl);
                    this._knownCommets.put(cometUrl, comet);
                    comet.handshake();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return comet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void observedComets(Set<String> comets) {
        Oort oort = this;
        synchronized (oort) {
            Set<String> known = this.getKnownComets();
            for (String comet : comets) {
                if (this._url.equals(comet)) continue;
                this.observeComet(comet);
            }
            known = this.getKnownComets();
            if (!comets.containsAll(known)) {
                this._bayeux.getChannel("/oort/cloud", true).publish((Session)this._oortSession, known, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKnownComets() {
        Oort oort = this;
        synchronized (oort) {
            HashSet<String> comets = new HashSet<String>(this._knownCommets.keySet());
            comets.add(this._url);
            return comets;
        }
    }

    public void observeChannel(String channelId) {
        if (this._channels.add(channelId)) {
            for (OortComet comet : this._knownCommets.values()) {
                comet.subscribe(channelId);
            }
        }
    }

    public boolean isOort(ServerSession session) {
        LocalSession local = session.getLocalSession();
        return local == this._oortSession;
    }

    public boolean isOort(LocalSession session) {
        return session == this._oortSession;
    }

    public String toString() {
        return this._url;
    }

    protected void oortHandshook(String oortUrl, String oortSecret, String clientId) {
        Log.info((String)(this + ": " + clientId + " is oort " + oortUrl));
        if (!this._knownCommets.containsKey(oortUrl)) {
            this.observeComet(oortUrl);
        }
        ServerSession session = this._bayeux.getSession(clientId);
        session.addExtension((ServerSession.Extension)new RemoteOortClientExtension());
    }

    protected class RootOortClientListener
    implements SessionChannel.SubscriberListener {
        protected RootOortClientListener() {
        }

        public void onMessage(SessionChannel channel, Message msg) {
            String channelId = msg.getChannel();
            Object data = msg.getData();
            if (data instanceof Object[]) {
                Object[] array = (Object[])msg.getData();
                HashSet<String> comets = new HashSet<String>();
                for (Object o : array) {
                    comets.add(o.toString());
                }
                Oort.this.observedComets(comets);
            }
        }
    }

    protected class RemoteOortClientExtension
    implements ServerSession.Extension {
        protected RemoteOortClientExtension() {
        }

        public boolean rcv(ServerSession session, ServerMessage.Mutable message) {
            return true;
        }

        public boolean rcvMeta(ServerSession session, ServerMessage.Mutable message) {
            return true;
        }

        public ServerMessage send(ServerSession to, ServerMessage message) {
            boolean send = !Oort.this.isOort(to) || message.getChannel().startsWith("/oort/");
            return send ? message : null;
        }

        public boolean sendMeta(ServerSession session, ServerMessage.Mutable message) {
            return true;
        }
    }

    protected class OortExtension
    implements BayeuxServer.Extension {
        protected OortExtension() {
        }

        public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
            return true;
        }

        public boolean rcvMeta(ServerSession from, ServerMessage.Mutable message) {
            return true;
        }

        public boolean send(ServerMessage.Mutable message) {
            return true;
        }

        public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
            if (message.getChannel().equals("/meta/handshake") && message.isSuccessful()) {
                Map oort;
                Map rcvExt;
                ServerMessage rcv = message.getAssociated();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)(Oort.this._url + " --> " + rcv));
                }
                if ((rcvExt = rcv.getExt()) != null && (oort = (Map)rcvExt.get("oort")) != null) {
                    String cometUrl = (String)oort.get("comet");
                    String oortUrl = (String)oort.get("oort");
                    if (Oort.this.getURL().equals(cometUrl)) {
                        String oortSecret = (String)oort.get("oortSecret");
                        Oort.this.oortHandshook(oortUrl, oortSecret, message.getClientId());
                        Object ext = message.get((Object)"ext");
                        HashMap<String, Map> sndExt = (HashMap<String, Map>)(ext instanceof JSON.Literal ? JSON.parse((String)ext.toString()) : ext);
                        if (sndExt == null) {
                            sndExt = new HashMap<String, Map>();
                        }
                        oort.put("cometSecret", Oort.this.getSecret());
                        sndExt.put("oort", oort);
                        message.put((Object)"ext", sndExt);
                    }
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)(Oort.this._url + " <-- " + message));
                }
            }
            return true;
        }
    }
}

