/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.client.SessionChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;

public class Seti {
    public static final String SETI_ATTRIBUTE = "org.cometd.oort.Seti";
    public static final String SETI_SHARD = "seti.shard";
    final String _setiId;
    final String _shardId;
    final Oort _oort;
    final LocalSession _session;
    final ShardLocation _allShardLocation;
    final ServerChannel _setiIdChannel;
    final ServerChannel _setiAllChannel;
    final ServerChannel _setiShardChannel;
    final ConcurrentMap<String, Location> _uid2Location = new ConcurrentHashMap<String, Location>();

    public Seti(Oort oort, String shardId) {
        this._oort = oort;
        this._session = this._oort.getBayeux().newLocalSession("seti");
        this._setiId = this._oort.getURL().replace("://", "_").replace("/", "_").replace(":", "_");
        this._shardId = shardId;
        this._setiIdChannel = this._oort.getBayeux().getChannel("/seti/" + this._setiId, true);
        this._setiIdChannel.setPersistent(true);
        this._setiAllChannel = this._oort.getBayeux().getChannel("/seti/ALL", true);
        this._setiAllChannel.setPersistent(true);
        this._setiShardChannel = this._oort.getBayeux().getChannel("/seti/" + shardId, true);
        this._setiShardChannel.setPersistent(true);
        this._allShardLocation = new ShardLocation("ALL");
        try {
            this._session.handshake();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._oort.observeChannel(this._setiIdChannel.getId());
        this._session.getChannel(this._setiIdChannel.getId()).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receive(message);
            }
        });
        this._oort.observeChannel(this._setiAllChannel.getId());
        this._session.getChannel(this._setiAllChannel.getId()).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receive(message);
            }
        });
        this._oort.observeChannel(this._setiShardChannel.getId());
        this._session.getChannel(this._setiShardChannel.getId()).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receive(message);
            }
        });
    }

    public void associate(String userId, ServerSession session) {
        this._uid2Location.put(userId, new LocalLocation(session));
        this.userId2Shard(userId).associate(userId);
    }

    public void disassociate(String userId) {
        this._uid2Location.remove(userId);
        this.userId2Shard(userId).disassociate(userId);
    }

    public void sendMessage(String toUser, String toChannel, Object data) {
        Location location = (Location)this._uid2Location.get(toUser);
        if (location == null) {
            location = this.userId2Shard(toUser);
        }
        location.sendMessage(toUser, toChannel, data);
    }

    public void sendMessage(Collection<String> toUsers, String toChannel, Object message) {
        ShardLocation shard;
        MultiMap shard2users = new MultiMap();
        for (String userId : toUsers) {
            shard = this.userId2Shard(userId);
            shard2users.add((Object)shard, (Object)userId);
        }
        for (Map.Entry entry : shard2users.entrySet()) {
            shard = (ShardLocation)entry.getKey();
            Object lazyUsers = entry.getValue();
            if (LazyList.size(lazyUsers) == 1) {
                shard.sendMessage((String)lazyUsers, toChannel, message);
                continue;
            }
            shard.sendMessage((List)lazyUsers, toChannel, message);
        }
    }

    protected ShardLocation userId2Shard(String userId) {
        return this._allShardLocation;
    }

    protected void receive(Message msg) {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("SETI " + this._oort + ":: " + msg));
        }
        if (!(msg.getData() instanceof Map)) {
            return;
        }
        Map data = (Map)msg.getData();
        String toUid = (String)data.get("to");
        String fromUid = (String)data.get("from");
        Object message = data.get("message");
        String on = (String)data.get("on");
        if (fromUid != null) {
            if (on != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)(this._oort + ":: " + fromUid + " on " + on));
                }
                this._uid2Location.put(fromUid, new SetiLocation("/seti/" + on));
            } else {
                String off = (String)data.get("off");
                if (off != null) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)(this._oort + ":: " + fromUid + " off "));
                    }
                    this._uid2Location.remove(fromUid, new SetiLocation("/seti/" + off));
                }
            }
        }
        if (message != null && toUid != null) {
            String toChannel = (String)data.get("channel");
            Location location = (Location)this._uid2Location.get(toUid);
            if (location == null && this._setiIdChannel.getId().equals(msg.getChannel())) {
                location = this.userId2Shard(toUid);
            }
            if (location != null) {
                location.receive(toUid, toChannel, message);
            }
        }
    }

    public void disconnect() {
        this._session.disconnect();
    }

    class SetiPresence
    implements JSON.Convertible {
        String _user;
        boolean _on;

        SetiPresence(String user, boolean on) {
            this._user = user;
            this._on = on;
        }

        public void fromJSON(Map object) {
            throw new UnsupportedOperationException();
        }

        public void toJSON(JSON.Output out) {
            out.add("from", (Object)this._user);
            out.add(this._on ? "on" : "off", (Object)Seti.this._setiId);
        }
    }

    class SetiMessage
    implements JSON.Convertible {
        String _toUser;
        Collection<String> _toUsers;
        String _toChannel;
        Object _message;

        SetiMessage(String toUser, String toChannel, Object message) {
            this._toUser = toUser;
            this._toChannel = toChannel;
            this._message = message;
        }

        SetiMessage(Collection<String> toUsers, String toChannel, Object message) {
            this._toUsers = toUsers;
            this._toChannel = toChannel;
            this._message = message;
        }

        public void fromJSON(Map object) {
            throw new UnsupportedOperationException();
        }

        public void toJSON(JSON.Output out) {
            if (this._toUser != null) {
                out.add("to", (Object)this._toUser);
            } else if (this._toUsers != null) {
                out.add("to", this._toUsers);
            }
            out.add("channel", (Object)this._toChannel);
            out.add("from", (Object)Seti.this._setiId);
            out.add("message", this._message);
        }
    }

    class ShardLocation
    implements Location {
        ClientSessionChannel _channel;

        ShardLocation(String shardId) {
            this._channel = Seti.this._session.getChannel("/seti/" + shardId);
        }

        public void sendMessage(Collection<String> toUsers, String toChannel, Object message) {
            this._channel.publish((Object)new SetiMessage(toUsers, toChannel, message));
        }

        @Override
        public void sendMessage(String toUser, String toChannel, Object message) {
            this._channel.publish((Object)new SetiMessage(toUser, toChannel, message));
        }

        @Override
        public void receive(String toUser, String toChannel, Object message) {
        }

        public void associate(String user) {
            this._channel.publish((Object)new SetiPresence(user, true));
        }

        public void disassociate(String user) {
            this._channel.publish((Object)new SetiPresence(user, false));
        }
    }

    class SetiLocation
    implements Location {
        ClientSessionChannel _channel;

        SetiLocation(String channelId) {
            this._channel = Seti.this._session.getChannel(channelId);
        }

        SetiLocation(SessionChannel channel) {
            this._channel = channel;
        }

        @Override
        public void sendMessage(String toUser, String toChannel, Object message) {
            this._channel.publish((Object)new SetiMessage(toUser, toChannel, message));
        }

        @Override
        public void receive(String toUser, String toChannel, Object message) {
        }

        public boolean equals(Object o) {
            return o instanceof SetiLocation && ((SetiLocation)o)._channel.equals(this._channel);
        }

        public int hashCode() {
            return this._channel.hashCode();
        }
    }

    class LocalLocation
    implements Location {
        ServerSession _session;

        LocalLocation(ServerSession session) {
            this._session = session;
        }

        @Override
        public void sendMessage(String toUser, String toChannel, Object data) {
            System.err.println("SETI LocalLocation.send " + toUser + "," + toChannel + "," + data);
            this._session.deliver((Session)this._session, toChannel, data, null);
        }

        @Override
        public void receive(String toUser, String toChannel, Object data) {
            System.err.println("SETI LocalLocation.recieve " + toUser + "," + toChannel + "," + data);
            this._session.deliver((Session)this._session, toChannel, data, null);
        }
    }

    private static interface Location {
        public void sendMessage(String var1, String var2, Object var3);

        public void receive(String var1, String var2, Object var3);
    }
}

