/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.LongPollingTransport;
import org.cometd.oort.Oort;
import org.eclipse.jetty.client.HttpClient;

public class OortComet
extends BayeuxClient {
    protected Oort _oort;
    protected String _cometUrl;
    protected String _cometSecret;
    private boolean _connected;
    private final Map<String, ClientSessionChannel.MessageListener> _subscriptions = new HashMap<String, ClientSessionChannel.MessageListener>();

    OortComet(Oort oort, String cometUrl) {
        super(cometUrl, (ClientTransport)LongPollingTransport.create(null, (HttpClient)oort.getHttpClient()), new ClientTransport[0]);
        this._cometUrl = cometUrl;
        this._oort = oort;
        this._oort.getLog().info("observing {}", new Object[]{this._cometUrl});
        this.addExtension(new ClientSession.Extension(){

            public boolean sendMeta(ClientSession session, Message.Mutable message) {
                if ("/meta/handshake".equals(message.getChannel())) {
                    HashMap<String, String> oort = new HashMap<String, String>();
                    oort.put("oort", OortComet.this._oort.getURL());
                    oort.put("oortSecret", OortComet.this._oort.getSecret());
                    oort.put("comet", OortComet.this._cometUrl);
                    message.getExt(true).put("oort", oort);
                }
                return true;
            }

            public boolean send(ClientSession session, Message.Mutable message) {
                return true;
            }

            public boolean rcvMeta(ClientSession session, Message.Mutable message) {
                return true;
            }

            public boolean rcv(ClientSession session, Message.Mutable message) {
                return true;
            }
        });
        this.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)new ClientSessionChannel.MessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(ClientSessionChannel channel, Message message) {
                if (message.isSuccessful()) {
                    OortComet.this._oort.getLog().info("connected {} as {}", new Object[]{OortComet.this._cometUrl, message.getClientId()});
                    Map ext = message.getExt();
                    if (ext == null) {
                        return;
                    }
                    Map oort = (Map)ext.get("oort");
                    if (oort == null) {
                        return;
                    }
                    OortComet.this._cometSecret = (String)oort.get("cometSecret");
                    OortComet.this.batch(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            OortComet.this.getChannel("/oort/cloud").subscribe(new ClientSessionChannel.MessageListener(){

                                public void onMessage(ClientSessionChannel channel, Message message) {
                                    Object[] data = (Object[])message.getData();
                                    HashSet<String> comets = new HashSet<String>();
                                    for (Object o : data) {
                                        comets.add(o.toString());
                                    }
                                    OortComet.this._oort.observedComets(comets);
                                }
                            });
                            OortComet oortComet = OortComet.this;
                            synchronized (oortComet) {
                                OortComet.this._subscriptions.clear();
                                OortComet.this._connected = true;
                                OortComet.this.subscribe();
                            }
                            OortComet.this.getChannel("/oort/cloud").publish(OortComet.this._oort.getKnownComets(), OortComet.this._cometSecret);
                        }
                    });
                    OortComet.this._oort.getLog().debug("<== {}", new Object[]{ext});
                } else if (OortComet.this._connected) {
                    OortComet oortComet = OortComet.this;
                    synchronized (oortComet) {
                        OortComet.this._connected = false;
                    }
                    OortComet.this._oort.getLog().warn("failed handshake {}", new Object[]{OortComet.this._cometUrl});
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe() {
        OortComet oortComet = this;
        synchronized (oortComet) {
            if (!this._connected) {
                return;
            }
            for (String id : this._oort.getObservedChannels()) {
                if (this._subscriptions.containsKey(id)) continue;
                ClientSessionChannel.MessageListener listener = new ClientSessionChannel.MessageListener(){

                    public void onMessage(ClientSessionChannel channel, Message message) {
                        OortComet.this._oort.getLog().debug("republish {} by {}", new Object[]{message, OortComet.this._oort.getOortSession()});
                        OortComet.this._oort.getOortSession().getChannel(message.getChannel()).publish(message.getData(), message.getId());
                    }
                };
                this._subscriptions.put(id, listener);
                this._oort.getLog().debug("subscribe {} on {}", new Object[]{id, this._cometUrl});
                this.getChannel(id).subscribe(listener);
            }
        }
    }

    public void onFailure(Throwable x, Message[] messages) {
        this._oort.getLog().debug("onFailure {}", new Object[]{Arrays.asList(messages), x});
    }

    protected void processHandshake(Message.Mutable handshake) {
        super.processHandshake(handshake);
    }

    public String toString() {
        return this.getId() + "@" + this._cometUrl;
    }
}

