/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.LongPollingTransport;
import org.cometd.oort.Oort;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.log.Log;

public class OortComet
extends BayeuxClient {
    protected Oort _oort;
    protected String _cometUrl;
    protected String _cometSecret;

    OortComet(Oort oort, String cometUrl) {
        super(cometUrl, (ClientTransport)LongPollingTransport.create(null, (HttpClient)oort._httpClient), new ClientTransport[0]);
        this._cometUrl = cometUrl;
        this._oort = oort;
        this.addExtension(new ClientSession.Extension(){

            public boolean sendMeta(ClientSession session, Message.Mutable message) {
                if ("/meta/handshake".equals(message.getChannel())) {
                    HashMap<String, String> oort = new HashMap<String, String>();
                    oort.put("oort", OortComet.this._oort.getURL());
                    oort.put("oortSecret", OortComet.this._oort.getSecret());
                    oort.put("comet", OortComet.this._cometUrl);
                    message.getExt(true).put("oort", oort);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)(OortComet.this._oort.getURL() + " ==> " + message));
                    }
                }
                return true;
            }

            public boolean send(ClientSession session, Message.Mutable message) {
                return true;
            }

            public boolean rcvMeta(ClientSession session, Message.Mutable message) {
                return true;
            }

            public boolean rcv(ClientSession session, Message.Mutable message) {
                return true;
            }
        });
        this.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                System.err.println("handshake " + message);
                if (message.isSuccessful()) {
                    Map ext = message.getExt();
                    if (ext == null) {
                        return;
                    }
                    Map oort = (Map)ext.get("oort");
                    if (oort == null) {
                        return;
                    }
                    OortComet.this._cometSecret = (String)oort.get("cometSecret");
                    OortComet.this.batch(new Runnable(){

                        public void run() {
                            System.err.println("Oort subscriptions for " + this);
                            OortComet.this.getChannel("/oort/cloud").subscribe(new ClientSessionChannel.MessageListener(){

                                public void onMessage(ClientSessionChannel channel, Message message) {
                                    Object[] data = (Object[])message.getData();
                                    HashSet<String> comets = new HashSet<String>();
                                    for (Object o : data) {
                                        comets.add(o.toString());
                                    }
                                    OortComet.this._oort.observedComets(comets);
                                }
                            });
                            for (String id : OortComet.this._oort._channels.keySet()) {
                                OortComet.this.subscribe(id);
                            }
                            OortComet.this.getChannel("/oort/cloud").publish(OortComet.this._oort.getKnownComets(), OortComet.this._cometSecret);
                        }
                    });
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)(OortComet.this._oort.getURL() + " <== " + ext));
                    }
                }
            }
        });
    }

    public void subscribe(String id) {
        final ClientSessionChannel channel_here = this._oort._oortSession.getChannel(id);
        this.getChannel(id).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                channel_here.publish(message.getData(), message.getId());
            }
        });
    }
}

