/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.net.URI;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.OortComet;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Oort {
    public static final String OORT_URL = "oort.url";
    public static final String OORT_CLOUD = "oort.cloud";
    public static final String OORT_CHANNELS = "oort.channels";
    public static final String OORT_ATTRIBUTE = "org.cometd.oort.Oort";
    private final String _url;
    private final String _secret;
    private final BayeuxServer _bayeux;
    private final HttpClient _httpClient;
    private final Random _random = new SecureRandom();
    private final LocalSession _oortSession;
    private final Logger _log;
    private final Map<String, OortComet> _knownComets = new ConcurrentHashMap<String, OortComet>();
    private final Map<String, ServerSession> _incomingComets = new ConcurrentHashMap<String, ServerSession>();
    private final ConcurrentMap<String, Boolean> _channels = new ConcurrentHashMap<String, Boolean>();
    private boolean _clientDebugEnabled;

    Oort(String url, BayeuxServer bayeux) {
        this._url = url;
        this._bayeux = bayeux;
        this._secret = Long.toHexString(this._random.nextLong());
        this._log = Log.getLogger((String)("Oort-" + this._url));
        if (Boolean.valueOf(String.valueOf(bayeux.getOption("debug"))).booleanValue()) {
            this._log.setDebugEnabled(true);
        }
        this._httpClient = new HttpClient();
        this._oortSession = this._bayeux.newLocalSession("oort");
        bayeux.addExtension((BayeuxServer.Extension)new OortExtension());
        bayeux.createIfAbsent("/oort/cloud", new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
                channel.addListener((ServerChannel.ServerChannelListener)new RootCloudListener());
            }
        }});
        try {
            this._httpClient.start();
            this._oortSession.handshake();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BayeuxServer getBayeux() {
        return this._bayeux;
    }

    public String getURL() {
        return this._url;
    }

    public String getSecret() {
        return this._secret;
    }

    public boolean isClientDebugEnabled() {
        return this._clientDebugEnabled;
    }

    public void setClientDebugEnabled(boolean clientDebugEnabled) {
        this._clientDebugEnabled = clientDebugEnabled;
        for (OortComet comet : this._knownComets.values()) {
            comet.setDebugEnabled(clientDebugEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OortComet observeComet(String cometUrl) {
        try {
            URI uri = new URI(cometUrl);
            if (uri.getScheme() == null || uri.getHost() == null) {
                this._log.warn("No protocol|host in comet URL: " + cometUrl, new Object[0]);
                return null;
            }
        }
        catch (Exception e) {
            this._log.debug((Throwable)e);
            this._log.warn("Bad comet URL: " + cometUrl, new Object[0]);
            return null;
        }
        Oort oort = this;
        synchronized (oort) {
            if (this._url.equals(cometUrl)) {
                return null;
            }
            OortComet comet = this._knownComets.get(cometUrl);
            if (comet == null) {
                try {
                    comet = new OortComet(this, cometUrl);
                    comet.setDebugEnabled(this._clientDebugEnabled);
                    this._knownComets.put(cometUrl, comet);
                    comet.handshake();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return comet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void observedComets(Set<String> comets) {
        Oort oort = this;
        synchronized (oort) {
            Set<String> known = this.getKnownComets();
            for (String comet : comets) {
                if (this._url.equals(comet)) continue;
                this.observeComet(comet);
            }
            known = this.getKnownComets();
            if (!comets.containsAll(known)) {
                this._bayeux.getChannel("/oort/cloud").publish((Session)this._oortSession, known, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKnownComets() {
        Oort oort = this;
        synchronized (oort) {
            HashSet<String> comets = new HashSet<String>(this._knownComets.keySet());
            comets.add(this._url);
            return comets;
        }
    }

    public void observeChannel(String channelId) {
        if (this._channels.putIfAbsent(channelId, Boolean.TRUE) == null) {
            for (OortComet comet : this._knownComets.values()) {
                comet.subscribe();
            }
        }
    }

    public boolean isOort(ServerSession session) {
        String id = session.getId();
        if (id.equals(this._oortSession.getId())) {
            return true;
        }
        if (this._incomingComets.containsKey(id)) {
            return true;
        }
        for (OortComet oc : this._knownComets.values()) {
            if (!id.equals(oc.getId())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this._url;
    }

    protected void incomingCometHandshake(String oortUrl, String oortSecret, String clientId) {
        this._log.info("incoming {}@{}", new Object[]{clientId, oortUrl});
        if (!this._knownComets.containsKey(oortUrl)) {
            this.observeComet(oortUrl);
        }
        ServerSession session = this._bayeux.getSession(clientId);
        session.addListener((ServerSession.ServerSessionListener)new ServerSession.MessageListener(){

            public boolean onMessage(ServerSession to, ServerSession from, ServerMessage message) {
                if (to == from || to.getId().equals(from.getId()) || Oort.this.isOort(from)) {
                    Oort.this._log.debug("{} ---| {} {}", new Object[]{from, to, message});
                    return false;
                }
                Oort.this._log.debug("{} ---> {} {}", new Object[]{from, to, message});
                return true;
            }
        });
    }

    public HttpClient getHttpClient() {
        return this._httpClient;
    }

    public Logger getLog() {
        return this._log;
    }

    public Set<String> getObservedChannels() {
        return this._channels.keySet();
    }

    public LocalSession getOortSession() {
        return this._oortSession;
    }

    protected class RootCloudListener
    implements ServerChannel.MessageListener,
    ServerChannel.SubscriptionListener {
        protected RootCloudListener() {
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable msg) {
            Object data = msg.getData();
            if (data instanceof Object[]) {
                Object[] array = (Object[])msg.getData();
                HashSet<String> comets = new HashSet<String>();
                for (Object o : array) {
                    comets.add(o.toString());
                }
                Oort.this.observedComets(comets);
            }
            return true;
        }

        public void subscribed(ServerSession session, ServerChannel channel) {
            Oort.this._log.info("/oort/cloud subscribe {}", new Object[]{session.getId()});
            Oort.this._incomingComets.put(session.getId(), session);
        }

        public void unsubscribed(ServerSession session, ServerChannel channel) {
            Oort.this._log.info("/oort/cloud unsubscribe {}", new Object[]{session.getId()});
            Oort.this._incomingComets.remove(session.getId());
        }
    }

    protected class OortExtension
    implements BayeuxServer.Extension {
        protected OortExtension() {
        }

        public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
            return true;
        }

        public boolean rcvMeta(ServerSession from, ServerMessage.Mutable message) {
            return true;
        }

        public boolean send(ServerSession from, ServerSession to, ServerMessage.Mutable message) {
            return true;
        }

        public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
            Map oort_ext;
            ServerMessage.Mutable rcv;
            Map rcvExt;
            if (message.getChannel().equals("/meta/handshake") && message.isSuccessful() && (rcvExt = (rcv = message.getAssociated()).getExt()) != null && (oort_ext = (Map)rcvExt.get("oort")) != null) {
                String cometUrl = (String)oort_ext.get("comet");
                String oortUrl = (String)oort_ext.get("oort");
                if (Oort.this.getURL().equals(cometUrl)) {
                    String oortSecret = (String)oort_ext.get("oortSecret");
                    Oort.this.incomingCometHandshake(oortUrl, oortSecret, message.getClientId());
                    Object ext = message.get((Object)"ext");
                    HashMap<String, Map> sndExt = (HashMap<String, Map>)(ext instanceof JSON.Literal ? JSON.parse((String)ext.toString()) : ext);
                    if (sndExt == null) {
                        sndExt = new HashMap<String, Map>();
                    }
                    oort_ext.put("cometSecret", Oort.this.getSecret());
                    sndExt.put("oort", oort_ext);
                    message.put((Object)"ext", sndExt);
                }
            }
            return true;
        }
    }
}

