/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.oort.Oort;

public class OortServlet
implements Servlet {
    public static final String OORT_URL_PARAM = "oort.url";
    public static final String OORT_CLOUD_PARAM = "oort.cloud";
    public static final String OORT_CHANNELS_PARAM = "oort.channels";
    private ServletConfig _config;

    public ServletConfig getServletConfig() {
        return this._config;
    }

    public String getServletInfo() {
        return OortServlet.class.toString();
    }

    public void init(ServletConfig config) throws ServletException {
        this._config = config;
        BayeuxServer bayeux = (BayeuxServer)config.getServletContext().getAttribute("org.cometd.bayeux");
        if (bayeux == null) {
            throw new UnavailableException("Missing org.cometd.bayeux attribute");
        }
        String url = this._config.getInitParameter(OORT_URL_PARAM);
        if (url == null) {
            throw new UnavailableException("Missing oort.url init parameter");
        }
        try {
            String cloud;
            Oort oort = this.newOort(bayeux, url);
            oort.setClientDebugEnabled(Boolean.valueOf(this._config.getInitParameter("clientDebug")));
            oort.start();
            this._config.getServletContext().setAttribute(Oort.OORT_ATTRIBUTE, (Object)oort);
            String channels = this._config.getInitParameter(OORT_CHANNELS_PARAM);
            if (channels != null) {
                String[] patterns;
                for (String channel : patterns = channels.split(",")) {
                    oort.observeChannel(channel);
                }
            }
            if ((cloud = this._config.getInitParameter(OORT_CLOUD_PARAM)) != null && cloud.length() > 0) {
                String[] urls;
                for (String comet : urls = cloud.split(",")) {
                    if (comet.length() <= 0) continue;
                    oort.observeComet(comet);
                }
            }
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    protected Oort newOort(BayeuxServer bayeux, String url) {
        return new Oort(bayeux, url);
    }

    public void destroy() {
        try {
            Oort oort = (Oort)((Object)this._config.getServletContext().getAttribute(Oort.OORT_ATTRIBUTE));
            if (oort != null) {
                oort.stop();
            }
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletResponse response = (HttpServletResponse)res;
        response.sendError(503);
    }
}

