/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Seti
extends AbstractLifeCycle {
    public static final String SETI_ATTRIBUTE = Seti.class.getName();
    private static final String SETI_ALL_CHANNEL = "/seti/all";
    private final Map<String, Set<Location>> _uid2Location = new HashMap<String, Set<Location>>();
    private final Logger _logger;
    private final Oort _oort;
    private final String _setiId;
    private final LocalSession _session;

    public Seti(Oort oort) {
        this._logger = Log.getLogger((String)(((Object)((Object)this)).getClass().getName() + "-" + oort.getURL()));
        this._oort = oort;
        this._setiId = oort.getURL().replace("://", "_").replace(":", "_").replace("/", "_");
        this._session = oort.getBayeuxServer().newLocalSession("seti");
    }

    protected Logger getLogger() {
        return this._logger;
    }

    public Oort getOort() {
        return this._oort;
    }

    public String getId() {
        return this._setiId;
    }

    protected void doStart() throws Exception {
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        bayeux.createIfAbsent("/seti/**", new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
            }
        }});
        String channel = "/seti/" + this._setiId;
        bayeux.createIfAbsent(channel, new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.setPersistent(true);
            }
        }});
        this._oort.observeChannel(channel);
        this._session.handshake();
        this._session.getChannel(channel).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receiveDirect(message);
            }
        });
        bayeux.createIfAbsent(SETI_ALL_CHANNEL, new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.setPersistent(true);
            }
        }});
        this._oort.observeChannel(SETI_ALL_CHANNEL);
        this._session.getChannel(SETI_ALL_CHANNEL).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receiveBroadcast(message);
            }
        });
    }

    protected void doStop() throws Exception {
        this._session.disconnect();
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        this._oort.deobserveChannel(SETI_ALL_CHANNEL);
        bayeux.getChannel(SETI_ALL_CHANNEL).setPersistent(false);
        String channel = "/seti/" + this._setiId;
        this._oort.deobserveChannel(channel);
        bayeux.getChannel(channel).setPersistent(false);
        bayeux.getChannel("/seti/**").removeAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
    }

    public boolean associate(String userId, ServerSession session) {
        if (session == null) {
            throw new NullPointerException();
        }
        LocalLocation location = new LocalLocation(userId, session);
        boolean wasAssociated = this.isAssociated(userId);
        boolean added = this.associate(userId, location);
        if (added) {
            session.addListener((ServerSession.ServerSessionListener)location);
            this._logger.debug("Associated session {} to user {}", new Object[]{session, userId});
            if (!wasAssociated) {
                this._logger.debug("Broadcasting presence addition for user {}", new Object[]{userId});
                this._oort.getBayeuxServer().getChannel(SETI_ALL_CHANNEL).publish((Session)this._session, (Object)new SetiPresence(userId, true), null);
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean associate(String userId, Location location) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                locations = new HashSet<Location>();
                this._uid2Location.put(userId, locations);
            }
            boolean result = locations.add(location);
            this._logger.debug("Associations {}", new Object[]{this._uid2Location});
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssociated(String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                return false;
            }
            for (Location location : locations) {
                if (!(location instanceof LocalLocation)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean disassociate(String userId, ServerSession session) {
        LocalLocation location = new LocalLocation(userId, session);
        boolean removed = this.disassociate(userId, location);
        if (removed) {
            this._logger.debug("Disassociated session {} from user {}", new Object[]{session, userId});
        }
        if (this._session.isConnected() && !this.isAssociated(userId)) {
            this._logger.debug("Broadcasting presence removal for user {}", new Object[]{userId});
            this._oort.getBayeuxServer().getChannel(SETI_ALL_CHANNEL).publish((Session)this._session, (Object)new SetiPresence(userId, false), null);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean disassociate(String userId, Location location) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            boolean result = false;
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations != null) {
                result = locations.remove(location);
                if (locations.isEmpty()) {
                    this._uid2Location.remove(userId);
                }
            }
            this._logger.debug("Associations {}", new Object[]{this._uid2Location});
            return result;
        }
    }

    public void sendMessage(String toUserId, String toChannel, Object data) {
        this.sendMessage(Collections.singleton(toUserId), toChannel, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Collection<String> toUserIds, String toChannel, Object data) {
        for (String toUserId : toUserIds) {
            HashSet<Location> copy = new HashSet<Location>();
            Map<String, Set<Location>> map = this._uid2Location;
            synchronized (map) {
                Set<Location> locations = this._uid2Location.get(toUserId);
                if (locations == null) {
                    copy.add(new SetiLocation(toUserId, SETI_ALL_CHANNEL));
                } else {
                    copy.addAll(locations);
                }
            }
            this._logger.debug("Sending message to locations {}", new Object[]{copy});
            for (Location location : copy) {
                location.send(toUserId, toChannel, data);
            }
        }
    }

    protected void receiveDirect(Message message) {
        this._logger.debug("Received direct message {}", new Object[]{message});
        this.receiveMessage(message);
    }

    protected void receiveBroadcast(Message message) {
        Map data = message.getDataAsMap();
        Boolean presence = (Boolean)data.get("presence");
        if (presence != null) {
            this.receivePresence(message);
        } else {
            this.receiveMessage(message);
        }
    }

    protected void receivePresence(Message message) {
        Map data = message.getDataAsMap();
        String setiId = (String)data.get("setiId");
        if (this._setiId.equals(setiId)) {
            return;
        }
        this._logger.debug("Received presence message {}", new Object[]{message});
        String userId = (String)data.get("userId");
        SetiLocation location = new SetiLocation(userId, "/seti/" + setiId);
        boolean presence = (Boolean)data.get("presence");
        if (presence) {
            this.associate(userId, location);
        } else {
            this.disassociate(userId, location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveMessage(Message message) {
        Map messageData = message.getDataAsMap();
        String userId = (String)messageData.get("userId");
        String channel = (String)messageData.get("channel");
        Object data = messageData.get("data");
        HashSet<Location> copy = new HashSet<Location>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations != null) {
                for (Location location : locations) {
                    if (!(location instanceof LocalLocation)) continue;
                    copy.add(location);
                }
            }
        }
        this._logger.debug("Received message {} for locations {}", new Object[]{message, copy});
        for (Location location : copy) {
            location.receive(userId, channel, data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetiPresence
    extends HashMap<String, Object> {
        private static final String USER_ID_FIELD = "userId";
        private static final String SETI_ID_FIELD = "setiId";
        private static final String PRESENCE_FIELD = "presence";

        private SetiPresence(String userId, boolean on) {
            super(3);
            this.put(USER_ID_FIELD, userId);
            this.put(SETI_ID_FIELD, Seti.this._setiId);
            this.put(PRESENCE_FIELD, on);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetiMessage
    extends HashMap<String, Object> {
        private static final String USER_ID_FIELD = "userId";
        private static final String CHANNEL_FIELD = "channel";
        private static final String SETI_ID_FIELD = "setiId";
        private static final String DATA_FIELD = "data";

        private SetiMessage(String toUser, String toChannel, Object data) {
            super(4);
            this.put(USER_ID_FIELD, toUser);
            this.put(CHANNEL_FIELD, toChannel);
            this.put(SETI_ID_FIELD, Seti.this._setiId);
            this.put(DATA_FIELD, data);
        }
    }

    protected class SetiLocation
    implements Location {
        private final String _userId;
        private final String _setiId;

        protected SetiLocation(String userId, String channelId) {
            this._userId = userId;
            this._setiId = channelId;
        }

        public void send(String toUser, String toChannel, Object data) {
            Seti.this._session.getChannel(this._setiId).publish((Object)new SetiMessage(toUser, toChannel, data));
        }

        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SetiLocation)) {
                return false;
            }
            SetiLocation that = (SetiLocation)obj;
            return this._userId.equals(that._userId) && this._setiId.equals(that._setiId);
        }

        public int hashCode() {
            return 31 * this._userId.hashCode() + this._setiId.hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._setiId + "]";
        }
    }

    protected class LocalLocation
    implements Location,
    ServerSession.RemoveListener {
        private final String _userId;
        private final ServerSession _session;

        protected LocalLocation(String userId, ServerSession session) {
            this._userId = userId;
            this._session = session;
        }

        public void send(String toUser, String toChannel, Object data) {
            this._session.deliver((Session)Seti.this._session.getServerSession(), toChannel, data, null);
        }

        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        public void removed(ServerSession session, boolean timeout) {
            Seti.this.disassociate(this._userId, session);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LocalLocation)) {
                return false;
            }
            LocalLocation that = (LocalLocation)obj;
            return this._userId.equals(that._userId) && this._session.getId().equals(that._session.getId());
        }

        public int hashCode() {
            return 31 * this._userId.hashCode() + this._session.getId().hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._session + "]";
        }
    }

    protected static interface Location {
        public void send(String var1, String var2, Object var3);

        public void receive(String var1, String var2, Object var3);

        public int hashCode();

        public boolean equals(Object var1);
    }
}

