/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.concurrent.TimeUnit;
import org.cometd.oort.Oort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OortMulticastConfigurer {
    private static final int MTU = 1500;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Oort oort;
    private InetAddress bindAddress;
    private InetAddress groupAddress;
    private int groupPort = 5577;
    private int timeToLive = 1;
    private long advertiseInterval = 1000L;
    private Thread receiverThread;
    private Thread senderThread;
    private volatile boolean active;

    public OortMulticastConfigurer(Oort oort) {
        this.oort = oort;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setGroupAddress(InetAddress groupAddress) {
        this.groupAddress = groupAddress;
    }

    public void setGroupPort(int groupPort) {
        this.groupPort = groupPort;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setAdvertiseInterval(long advertiseInterval) {
        this.advertiseInterval = advertiseInterval;
    }

    public void start() throws Exception {
        MulticastSocket sender = new MulticastSocket();
        sender.setTimeToLive(this.timeToLive);
        InetSocketAddress bindSocketAddress = this.bindAddress == null ? new InetSocketAddress(this.groupPort) : new InetSocketAddress(this.bindAddress, this.groupPort);
        MulticastSocket receiver = new MulticastSocket(bindSocketAddress);
        if (this.groupAddress == null) {
            this.groupAddress = InetAddress.getByName("239.255.0.1");
        }
        receiver.joinGroup(this.groupAddress);
        this.active = true;
        this.senderThread = new Thread((Runnable)new MulticastSender(sender), "Oort Multicast Sender");
        this.senderThread.setDaemon(true);
        this.senderThread.start();
        this.receiverThread = new Thread((Runnable)new MulticastReceiver(receiver), "Oort Multicast Receiver");
        this.receiverThread.setDaemon(true);
        this.receiverThread.start();
    }

    public void stop() {
        this.active = false;
        this.senderThread.interrupt();
    }

    public boolean join(long timeout) {
        try {
            this.senderThread.join(timeout);
            this.receiverThread.join(timeout);
            return true;
        }
        catch (InterruptedException x) {
            return false;
        }
    }

    protected void receive(String cometURL) {
        if (!this.oort.getKnownComets().contains(cometURL)) {
            this.logger.debug("Received comet URL via multicast: {}", (Object)cometURL);
            this.oort.observeComet(cometURL);
        }
    }

    private class MulticastSender
    implements Runnable {
        private final MulticastSocket socket;

        public MulticastSender(MulticastSocket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            OortMulticastConfigurer.this.logger.debug("Entering multicast sender thread");
            try {
                String cometURL = OortMulticastConfigurer.this.oort.getURL();
                byte[] cometURLBytes = cometURL.getBytes("UTF-8");
                if (cometURLBytes.length > 1500) {
                    OortMulticastConfigurer.this.logger.info("Oort URL {} exceeds max transmission unit and will not be advertised", (Object)cometURL);
                    return;
                }
                while (OortMulticastConfigurer.this.active) {
                    DatagramPacket packet = new DatagramPacket(cometURLBytes, 0, cometURLBytes.length, OortMulticastConfigurer.this.groupAddress, OortMulticastConfigurer.this.groupPort);
                    this.socket.send(packet);
                    TimeUnit.MILLISECONDS.sleep(OortMulticastConfigurer.this.advertiseInterval);
                }
            }
            catch (IOException x) {
                OortMulticastConfigurer.this.logger.warn("Unexpected exception", (Throwable)x);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                OortMulticastConfigurer.this.logger.debug("Exiting multicast sender thread");
                this.socket.close();
            }
        }
    }

    private class MulticastReceiver
    implements Runnable {
        private final MulticastSocket socket;

        public MulticastReceiver(MulticastSocket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            OortMulticastConfigurer.this.logger.debug("Entering multicast receiver thread on {}", (Object)this.socket.getLocalSocketAddress());
            try {
                byte[] buffer = new byte[1500];
                while (OortMulticastConfigurer.this.active) {
                    DatagramPacket packet = new DatagramPacket(buffer, 0, buffer.length);
                    this.socket.receive(packet);
                    String url = new String(buffer, packet.getOffset(), packet.getLength(), "UTF-8");
                    if (url.equals(OortMulticastConfigurer.this.oort.getURL())) continue;
                    OortMulticastConfigurer.this.receive(url);
                }
            }
            catch (IOException x) {
                OortMulticastConfigurer.this.logger.warn("Unexpected exception", (Throwable)x);
            }
            finally {
                OortMulticastConfigurer.this.logger.debug("Exiting multicast receiver thread");
                this.socket.close();
            }
        }
    }
}

