/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.net.InetAddress;
import javax.servlet.ServletConfig;
import org.cometd.oort.Oort;
import org.cometd.oort.OortConfigServlet;
import org.cometd.oort.OortMulticastConfigurer;

public class OortMulticastConfigServlet
extends OortConfigServlet {
    public static final String OORT_MULTICAST_BIND_ADDRESS_PARAM = "oort.multicast.bindAddress";
    public static final String OORT_MULTICAST_GROUP_ADDRESS_PARAM = "oort.multicast.groupAddress";
    public static final String OORT_MULTICAST_GROUP_PORT_PARAM = "oort.multicast.groupPort";
    public static final String OORT_MULTICAST_TIME_TO_LIVE_PARAM = "oort.multicast.timeToLive";
    public static final String OORT_MULTICAST_ADVERTISE_INTERVAL_PARAM = "oort.multicast.advertiseInterval";
    private OortMulticastConfigurer configurer;

    protected void configureCloud(ServletConfig config, Oort oort) throws Exception {
        String advertiseInterval;
        String timeToLive;
        String groupPort;
        String groupAddress;
        this.configurer = new OortMulticastConfigurer(oort);
        String bindAddress = config.getInitParameter(OORT_MULTICAST_BIND_ADDRESS_PARAM);
        if (bindAddress != null) {
            this.configurer.setBindAddress(InetAddress.getByName(bindAddress));
        }
        if ((groupAddress = config.getInitParameter(OORT_MULTICAST_GROUP_ADDRESS_PARAM)) != null) {
            this.configurer.setGroupAddress(InetAddress.getByName(groupAddress));
        }
        if ((groupPort = config.getInitParameter(OORT_MULTICAST_GROUP_PORT_PARAM)) != null) {
            this.configurer.setGroupPort(Integer.parseInt(groupPort));
        }
        if ((timeToLive = config.getInitParameter(OORT_MULTICAST_TIME_TO_LIVE_PARAM)) != null) {
            this.configurer.setTimeToLive(Integer.parseInt(timeToLive));
        }
        if ((advertiseInterval = config.getInitParameter(OORT_MULTICAST_ADVERTISE_INTERVAL_PARAM)) != null) {
            this.configurer.setAdvertiseInterval(Long.parseLong(advertiseInterval));
        }
        this.configurer.start();
    }

    public void destroy() {
        if (this.configurer != null) {
            this.configurer.stop();
            this.configurer.join(1000L);
        }
        super.destroy();
    }
}

