/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.LongPollingTransport;
import org.cometd.oort.Oort;
import org.cometd.websocket.client.WebSocketTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.websocket.WebSocketClientFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OortComet
extends BayeuxClient {
    private final ConcurrentMap<String, ClientSessionChannel.MessageListener> _subscriptions = new ConcurrentHashMap<String, ClientSessionChannel.MessageListener>();
    private final Oort _oort;
    private final String _cometURL;
    private volatile boolean _subscriptionsAllowed;

    public OortComet(Oort oort, String cometURL) {
        this(oort, cometURL, null);
    }

    public OortComet(Oort oort, String cometURL, Map<String, Object> options) {
        super(cometURL, (ClientTransport)WebSocketTransport.create(options, (WebSocketClientFactory)oort.getWebSocketClientFactory()), new ClientTransport[]{LongPollingTransport.create(options, (HttpClient)oort.getHttpClient())});
        this._oort = oort;
        this._cometURL = cometURL;
        this.setDebugEnabled(oort.isClientDebugEnabled());
        this.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)new HandshakeListener());
    }

    protected void subscribe(Set<String> observedChannels) {
        if (!this._subscriptionsAllowed) {
            return;
        }
        for (String channel : observedChannels) {
            ClientSessionChannel.MessageListener listener;
            ClientSessionChannel.MessageListener existing;
            if (this._subscriptions.containsKey(channel) || (existing = this._subscriptions.putIfAbsent(channel, listener = new ClientSessionChannel.MessageListener(){

                public void onMessage(ClientSessionChannel channel, Message message) {
                    OortComet.this.debug("Republishing message {} from {}", new Object[]{message, OortComet.this._cometURL});
                    OortComet.this._oort.getOortSession().getChannel(message.getChannel()).publish(message.getData());
                }
            })) != null) continue;
            this.debug("Subscribing to messages on {} from {}", new Object[]{channel, this._cometURL});
            this.getChannel(channel).subscribe(listener);
        }
        this.debug("Subscriptions to messages on {} from {}", new Object[]{this._subscriptions, this._cometURL});
    }

    protected void unsubscribe(String channel) {
        ClientSessionChannel.MessageListener listener = (ClientSessionChannel.MessageListener)this._subscriptions.remove(channel);
        if (listener != null) {
            this.debug("Unsubscribing to messages on {} from {}", new Object[]{channel, this._cometURL});
            this.getChannel(channel).unsubscribe(listener);
        }
    }

    protected void clearSubscriptions() {
        for (String channel : this._oort.getObservedChannels()) {
            this.unsubscribe(channel);
        }
    }

    public String toString() {
        return this._cometURL + "@" + this.getId();
    }

    private class HandshakeListener
    implements ClientSessionChannel.MessageListener {
        private HandshakeListener() {
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            if (!message.isSuccessful()) {
                return;
            }
            Map ext = message.getExt();
            if (ext == null) {
                return;
            }
            Object oortExtObject = ext.get("org.cometd.oort");
            if (!(oortExtObject instanceof Map)) {
                return;
            }
            OortComet.this.batch(new Runnable(){

                public void run() {
                    OortComet.this.getChannel("/oort/cloud").subscribe(new ClientSessionChannel.MessageListener(){

                        public void onMessage(ClientSessionChannel channel, Message message) {
                            if (message.isSuccessful()) {
                                OortComet.this._oort.joinComets(message);
                            }
                        }
                    });
                    OortComet.this.clearSubscriptions();
                    OortComet.this._subscriptionsAllowed = true;
                    Set<String> channels = OortComet.this._oort.getObservedChannels();
                    OortComet.this.debug("Handshake completed, observing channels {}", new Object[]{channels});
                    OortComet.this.subscribe(channels);
                    HashMap<String, String> data = new HashMap<String, String>(1);
                    data.put("oortURL", OortComet.this._oort.getURL());
                    OortComet.this.getChannel("/service/oort").publish(data);
                    OortComet.this.getChannel("/oort/cloud").publish(new ArrayList<String>(OortComet.this._oort.getKnownComets()));
                }
            });
        }
    }
}

