/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.cometd.bayeux.MarkedReference;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.oort.Oort;
import org.cometd.oort.OortObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OortMap<V>
extends OortObject<ConcurrentMap<String, V>> {
    private static final String TYPE_FIELD_ENTRY_VALUE = "oort.map.entry";
    private static final String ACTION_FIELD_PUT_VALUE = "oort.map.put";
    private static final String ACTION_FIELD_REMOVE_VALUE = "oort.map.remove";
    private static final String KEY_FIELD = "oort.map.key";
    private static final String VALUE_FIELD = "oort.map.value";
    private final List<EntryListener<V>> listeners = new CopyOnWriteArrayList<EntryListener<V>>();

    public OortMap(Oort oort, String name, OortObject.Factory<ConcurrentMap<String, V>> factory) {
        super(oort, name, factory);
    }

    public void addEntryListener(EntryListener<V> listener) {
        this.listeners.add(listener);
    }

    public void removeEntryListener(EntryListener<V> listener) {
        this.listeners.remove(listener);
    }

    public V putAndShare(String key, V value) {
        HashMap<String, String> entry = new HashMap<String, String>(2);
        entry.put(KEY_FIELD, key);
        entry.put(VALUE_FIELD, (String)value);
        OortObject.Data data = new OortObject.Data(6);
        data.put("oort.info.version", this.nextVersion());
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", entry);
        data.put("oort.info.type", TYPE_FIELD_ENTRY_VALUE);
        data.put("oort.info.action", ACTION_FIELD_PUT_VALUE);
        this.logger.debug("Sharing map put {}", (Object)data);
        BayeuxServer bayeuxServer = this.getOort().getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), (Object)data, null);
        return (V)data.getResult();
    }

    public V removeAndShare(String key) {
        HashMap<String, String> entry = new HashMap<String, String>(1);
        entry.put(KEY_FIELD, key);
        OortObject.Data data = new OortObject.Data(6);
        data.put("oort.info.version", this.nextVersion());
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", entry);
        data.put("oort.info.type", TYPE_FIELD_ENTRY_VALUE);
        data.put("oort.info.action", ACTION_FIELD_REMOVE_VALUE);
        this.logger.debug("Sharing map remove {}", (Object)data);
        BayeuxServer bayeuxServer = this.getOort().getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), (Object)data, null);
        return (V)data.getResult();
    }

    public V get(String key) {
        return ((ConcurrentMap)this.getInfo(this.getOort().getURL()).getObject()).get(key);
    }

    public V find(String key) {
        for (OortObject.Info info : this) {
            Object result = ((ConcurrentMap)info.getObject()).get(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public OortObject.Info<ConcurrentMap<String, V>> findInfo(String key) {
        for (OortObject.Info<ConcurrentMap<String, V>> info : this) {
            if (((ConcurrentMap)info.getObject()).get(key) == null) continue;
            return info;
        }
        return null;
    }

    @Override
    protected void onObject(Map<String, Object> data) {
        if (TYPE_FIELD_ENTRY_VALUE.equals(data.get("oort.info.type"))) {
            String action = (String)data.get("oort.info.action");
            final boolean remove = ACTION_FIELD_REMOVE_VALUE.equals(action);
            if (!ACTION_FIELD_PUT_VALUE.equals(action) && !remove) {
                throw new IllegalArgumentException(action);
            }
            String oortURL = (String)data.get("oort.info.url");
            OortObject.Info<ConcurrentMap<String, V>> info = this.getInfo(oortURL);
            if (info != null) {
                Map object = (Map)data.get("oort.info.object");
                final String key = (String)object.get(KEY_FIELD);
                final Object value = object.get(VALUE_FIELD);
                OortObject.Info newInfo = new OortObject.Info(this.getOort().getURL(), data);
                final ConcurrentMap map = (ConcurrentMap)info.getObject();
                newInfo.put("oort.info.object", map);
                final AtomicReference result = new AtomicReference();
                MarkedReference old = this.setInfo(newInfo, new Runnable(){

                    public void run() {
                        if (remove) {
                            result.set(map.remove(key));
                        } else {
                            result.set(map.put(key, value));
                        }
                    }
                });
                Entry entry = new Entry(key, result.get(), value);
                this.logger.debug("{} {} map {} of {}", new Object[]{old.isMarked() ? "Performed" : "Skipped", newInfo.isLocal() ? "local" : "remote", remove ? "remove" : "put", entry});
                if (old.isMarked()) {
                    if (remove) {
                        this.notifyEntryRemoved(info, entry);
                    } else {
                        this.notifyEntryPut(info, entry);
                    }
                }
                if (data instanceof OortObject.Data) {
                    ((OortObject.Data)data).setResult(result.get());
                }
            } else {
                this.logger.debug("No info for {}", (Object)oortURL);
            }
        } else {
            super.onObject(data);
        }
    }

    private void notifyEntryPut(OortObject.Info<ConcurrentMap<String, V>> info, Entry<V> entry) {
        for (EntryListener<V> listener : this.listeners) {
            try {
                listener.onPut(info, entry);
            }
            catch (Exception x) {
                this.logger.info("Exception while invoking listener " + listener, (Throwable)x);
            }
        }
    }

    private void notifyEntryRemoved(OortObject.Info<ConcurrentMap<String, V>> info, Entry<V> elements) {
        for (EntryListener<V> listener : this.listeners) {
            try {
                listener.onRemoved(info, elements);
            }
            catch (Exception x) {
                this.logger.info("Exception while invoking listener " + listener, (Throwable)x);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeltaListener<V>
    implements OortObject.Listener<ConcurrentMap<String, V>> {
        private final OortMap<V> oortMap;

        public DeltaListener(OortMap<V> oortMap) {
            this.oortMap = oortMap;
        }

        @Override
        public void onUpdated(OortObject.Info<ConcurrentMap<String, V>> oldInfo, OortObject.Info<ConcurrentMap<String, V>> newInfo) {
            Map oldMap = oldInfo == null ? Collections.emptyMap() : (Map)oldInfo.getObject();
            HashMap newMap = new HashMap(newInfo.getObject());
            for (Map.Entry oldEntry : oldMap.entrySet()) {
                String key = (String)oldEntry.getKey();
                Object newValue = newMap.remove(key);
                Entry entry = new Entry(key, oldEntry.getValue(), newValue);
                if (newValue == null) {
                    ((OortMap)this.oortMap).notifyEntryRemoved(newInfo, entry);
                    continue;
                }
                ((OortMap)this.oortMap).notifyEntryPut(newInfo, entry);
            }
            for (Map.Entry newEntry : newMap.entrySet()) {
                Entry<Object> entry = new Entry<Object>((String)newEntry.getKey(), null, newEntry.getValue());
                ((OortMap)this.oortMap).notifyEntryPut(newInfo, entry);
            }
        }

        @Override
        public void onRemoved(OortObject.Info<ConcurrentMap<String, V>> info) {
            for (Map.Entry oldEntry : info.getObject().entrySet()) {
                Entry<Object> entry = new Entry<Object>((String)oldEntry.getKey(), oldEntry.getValue(), null);
                ((OortMap)this.oortMap).notifyEntryRemoved(info, entry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<V> {
        private final String key;
        private final V oldValue;
        private final V newValue;

        protected Entry(String key, V oldValue, V newValue) {
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public String getKey() {
            return this.key;
        }

        public V getOldValue() {
            return this.oldValue;
        }

        public V getNewValue() {
            return this.newValue;
        }

        public String toString() {
            return String.format("(%s=%s->%s)", this.getKey(), this.getOldValue(), this.getNewValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EntryListener<V>
    extends EventListener {
        public void onPut(OortObject.Info<ConcurrentMap<String, V>> var1, Entry<V> var2);

        public void onRemoved(OortObject.Info<ConcurrentMap<String, V>> var1, Entry<V> var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Adapter<V>
        implements EntryListener<V> {
            @Override
            public void onPut(OortObject.Info<ConcurrentMap<String, V>> info, Entry<V> entry) {
            }

            @Override
            public void onRemoved(OortObject.Info<ConcurrentMap<String, V>> info, Entry<V> entry) {
            }
        }
    }
}

