/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Seti
extends AbstractLifeCycle {
    public static final String SETI_ATTRIBUTE = Seti.class.getName();
    private static final String SETI_ALL_CHANNEL = "/seti/all";
    private final Map<String, Set<Location>> _uid2Location = new HashMap<String, Set<Location>>();
    private final List<PresenceListener> listeners = new CopyOnWriteArrayList<PresenceListener>();
    private final Logger _logger;
    private final Oort _oort;
    private final String _setiId;
    private final LocalSession _session;
    private boolean _debug;

    public Seti(Oort oort) {
        this._oort = oort;
        this._setiId = Oort.replacePunctuation(oort.getURL(), '_');
        this._logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + this._setiId));
        this._session = oort.getBayeuxServer().newLocalSession(this._setiId);
        this._debug = oort.isDebugEnabled();
    }

    protected Logger getLogger() {
        return this._logger;
    }

    public boolean isDebugEnabled() {
        return this._debug;
    }

    public void setDebugEnabled(boolean debug) {
        this._debug = debug;
    }

    private void debug(String message, Object ... args) {
        if (this._debug) {
            this._logger.info(message, args);
        } else {
            this._logger.debug(message, args);
        }
    }

    public Oort getOort() {
        return this._oort;
    }

    public String getId() {
        return this._setiId;
    }

    protected void doStart() throws Exception {
        this._listeners.clear();
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        bayeux.createChannelIfAbsent("/seti/**", new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
            }
        }});
        String channel = "/seti/" + this._setiId;
        bayeux.createChannelIfAbsent(channel, new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer.Persistent()});
        this._oort.observeChannel(channel);
        this._session.handshake();
        this._session.getChannel(channel).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receiveDirect(message);
            }
        });
        bayeux.createChannelIfAbsent(SETI_ALL_CHANNEL, new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer.Persistent()});
        this._oort.observeChannel(SETI_ALL_CHANNEL);
        this._session.getChannel(SETI_ALL_CHANNEL).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receiveBroadcast(message);
            }
        });
    }

    protected void doStop() throws Exception {
        this._session.disconnect();
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        this._oort.deobserveChannel(SETI_ALL_CHANNEL);
        bayeux.getChannel(SETI_ALL_CHANNEL).setPersistent(false);
        String channel = "/seti/" + this._setiId;
        this._oort.deobserveChannel(channel);
        bayeux.getChannel(channel).setPersistent(false);
        bayeux.getChannel("/seti/**").removeAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
    }

    public boolean associate(String userId, ServerSession session) {
        if (session == null) {
            throw new NullPointerException();
        }
        LocalLocation location = new LocalLocation(userId, session);
        boolean wasAssociated = this.isAssociated(userId);
        boolean added = this.associate(userId, location);
        if (added) {
            session.addListener((ServerSession.ServerSessionListener)location);
            this.debug("Associated session {} to user {}", session, userId);
            if (!wasAssociated) {
                this.debug("Broadcasting presence addition for user {}", userId);
                this._oort.getBayeuxServer().getChannel(SETI_ALL_CHANNEL).publish((Session)this._session, (Object)new SetiPresence(userId, true), null);
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean associate(String userId, Location location) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                locations = new HashSet<Location>();
                this._uid2Location.put(userId, locations);
            }
            boolean result = locations.add(location);
            this.debug("Associations {}", this._uid2Location);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssociated(String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                return false;
            }
            for (Location location : locations) {
                if (!(location instanceof LocalLocation)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAssociationCount(String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                return 0;
            }
            int result = 0;
            for (Location location : locations) {
                if (!(location instanceof LocalLocation)) continue;
                ++result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPresent(String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            return locations != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPresenceCount(String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            return locations == null ? 0 : locations.size();
        }
    }

    public boolean disassociate(String userId, ServerSession session) {
        LocalLocation location = new LocalLocation(userId, session);
        boolean removed = this.disassociate(userId, location);
        if (removed) {
            this.debug("Disassociated session {} from user {}", session, userId);
        }
        if (this._session.isConnected() && !this.isAssociated(userId)) {
            this.debug("Broadcasting presence removal for user {}", userId);
            this._oort.getBayeuxServer().getChannel(SETI_ALL_CHANNEL).publish((Session)this._session, (Object)new SetiPresence(userId, false), null);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean disassociate(String userId, Location location) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            boolean result = false;
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations != null) {
                result = locations.remove(location);
                if (locations.isEmpty()) {
                    this._uid2Location.remove(userId);
                }
            }
            this.debug("Associations {}", this._uid2Location);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUserIds() {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            return new HashSet<String>(this._uid2Location.keySet());
        }
    }

    public void sendMessage(String toUserId, String toChannel, Object data) {
        this.sendMessage(Collections.singleton(toUserId), toChannel, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Collection<String> toUserIds, String toChannel, Object data) {
        for (String toUserId : toUserIds) {
            HashSet<Location> copy = new HashSet<Location>();
            Map<String, Set<Location>> map = this._uid2Location;
            synchronized (map) {
                Set<Location> locations = this._uid2Location.get(toUserId);
                if (locations == null) {
                    copy.add(new SetiLocation(toUserId, SETI_ALL_CHANNEL));
                } else {
                    copy.addAll(locations);
                }
            }
            this.debug("Sending message to locations {}", copy);
            for (Location location : copy) {
                location.send(toUserId, toChannel, data);
            }
        }
    }

    protected void receiveDirect(Message message) {
        this.debug("Received direct message {}", message);
        this.receiveMessage(message);
    }

    protected void receiveBroadcast(Message message) {
        Map data = message.getDataAsMap();
        Boolean presence = (Boolean)data.get("presence");
        if (presence != null) {
            this.receivePresence(message);
        } else {
            this.receiveMessage(message);
        }
    }

    protected void receivePresence(Message message) {
        this.debug("Received presence message {}", message);
        Map presence = message.getDataAsMap();
        String setiId = (String)presence.get("setiId");
        boolean present = (Boolean)presence.get("presence");
        if (!this._setiId.equals(setiId)) {
            String userId = (String)presence.get("userId");
            SetiLocation location = new SetiLocation(userId, "/seti/" + setiId);
            if (present) {
                this.associate(userId, location);
            } else {
                this.disassociate(userId, location);
            }
        }
        if (present) {
            this.notifyPresenceAdded(presence);
        } else {
            this.notifyPresenceRemoved(presence);
        }
    }

    public void addPresenceListener(PresenceListener listener) {
        this.listeners.add(listener);
    }

    public void removePresenceListener(PresenceListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyPresenceAdded(Map<String, Object> presence) {
        String userId = (String)presence.get("userId");
        String oortURL = (String)presence.get("oortURL");
        PresenceListener.Event event = new PresenceListener.Event(this, userId, oortURL);
        for (PresenceListener listener : this.listeners) {
            try {
                listener.presenceAdded(event);
            }
            catch (Exception x) {
                this._logger.info("Exception while invoking listener " + listener, (Throwable)x);
            }
        }
    }

    private void notifyPresenceRemoved(Map<String, Object> presence) {
        String userId = (String)presence.get("userId");
        String oortURL = (String)presence.get("oortURL");
        PresenceListener.Event event = new PresenceListener.Event(this, userId, oortURL);
        for (PresenceListener listener : this.listeners) {
            try {
                listener.presenceRemoved(event);
            }
            catch (Exception x) {
                this._logger.info("Exception while invoking listener " + listener, (Throwable)x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveMessage(Message message) {
        Map messageData = message.getDataAsMap();
        String userId = (String)messageData.get("userId");
        String channel = (String)messageData.get("channel");
        Object data = messageData.get("data");
        HashSet<Location> copy = new HashSet<Location>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations != null) {
                for (Location location : locations) {
                    if (!(location instanceof LocalLocation)) continue;
                    copy.add(location);
                }
            }
        }
        this.debug("Received message {} for locations {}", message, copy);
        for (Location location : copy) {
            location.receive(userId, channel, data);
        }
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getName(), this.getId());
    }

    public static interface PresenceListener
    extends EventListener {
        public void presenceAdded(Event var1);

        public void presenceRemoved(Event var1);

        public static class Event
        extends EventObject {
            private final String userId;
            private final String url;

            public Event(Seti source, String userId, String url) {
                super((Object)source);
                this.userId = userId;
                this.url = url;
            }

            public Seti getSeti() {
                return (Seti)((Object)this.getSource());
            }

            public String getUserId() {
                return this.userId;
            }

            public String getURL() {
                return this.url;
            }

            public boolean isLocal() {
                return this.getURL().equals(this.getSeti().getOort().getURL());
            }

            public String toString() {
                return String.format("%s[%s %s on %s]", new Object[]{this.getClass().getName(), this.getUserId(), this.isLocal() ? "local" : "remote", this.getSeti()});
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetiPresence
    extends HashMap<String, Object> {
        private static final String USER_ID_FIELD = "userId";
        private static final String OORT_URL_FIELD = "oortURL";
        private static final String SETI_ID_FIELD = "setiId";
        private static final String PRESENCE_FIELD = "presence";

        private SetiPresence(String userId, boolean present) {
            super(4);
            this.put(USER_ID_FIELD, userId);
            this.put(OORT_URL_FIELD, Seti.this._oort.getURL());
            this.put(SETI_ID_FIELD, Seti.this._setiId);
            this.put(PRESENCE_FIELD, present);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetiMessage
    extends HashMap<String, Object> {
        private static final String USER_ID_FIELD = "userId";
        private static final String CHANNEL_FIELD = "channel";
        private static final String SETI_ID_FIELD = "setiId";
        private static final String DATA_FIELD = "data";

        private SetiMessage(String toUser, String toChannel, Object data) {
            super(4);
            this.put(USER_ID_FIELD, toUser);
            this.put(CHANNEL_FIELD, toChannel);
            this.put(SETI_ID_FIELD, Seti.this._setiId);
            this.put(DATA_FIELD, data);
        }
    }

    protected class SetiLocation
    implements Location {
        private final String _userId;
        private final String _setiId;

        protected SetiLocation(String userId, String channelId) {
            this._userId = userId;
            this._setiId = channelId;
        }

        public void send(String toUser, String toChannel, Object data) {
            Seti.this._session.getChannel(this._setiId).publish((Object)new SetiMessage(toUser, toChannel, data));
        }

        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SetiLocation)) {
                return false;
            }
            SetiLocation that = (SetiLocation)obj;
            return this._userId.equals(that._userId) && this._setiId.equals(that._setiId);
        }

        public int hashCode() {
            return 31 * this._userId.hashCode() + this._setiId.hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._setiId + "]";
        }
    }

    protected class LocalLocation
    implements Location,
    ServerSession.RemoveListener {
        private final String _userId;
        private final ServerSession _session;

        protected LocalLocation(String userId, ServerSession session) {
            this._userId = userId;
            this._session = session;
        }

        public void send(String toUser, String toChannel, Object data) {
            this._session.deliver((Session)Seti.this._session.getServerSession(), toChannel, data, null);
        }

        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        public void removed(ServerSession session, boolean timeout) {
            Seti.this.disassociate(this._userId, session);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LocalLocation)) {
                return false;
            }
            LocalLocation that = (LocalLocation)obj;
            return this._userId.equals(that._userId) && this._session.getId().equals(that._session.getId());
        }

        public int hashCode() {
            return 31 * this._userId.hashCode() + this._session.getId().hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._session + "]";
        }
    }

    protected static interface Location {
        public void send(String var1, String var2, Object var3);

        public void receive(String var1, String var2, Object var3);

        public int hashCode();

        public boolean equals(Object var1);
    }
}

