/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.oort.OortComet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Seti
extends AbstractLifeCycle {
    public static final String SETI_ATTRIBUTE = Seti.class.getName();
    private static final String SETI_ALL_CHANNEL = "/seti/all";
    private final Map<String, Set<Location>> _uid2Location = new HashMap<String, Set<Location>>();
    private final ConcurrentMap<String, Boolean> _setis = new ConcurrentHashMap<String, Boolean>();
    private final List<PresenceListener> _presenceListeners = new CopyOnWriteArrayList<PresenceListener>();
    private final Oort.CometListener _cometListener = new CometListener();
    private final Oort _oort;
    private final String _setiId;
    private final Logger _logger;
    private final LocalSession _session;
    private boolean _debug;

    public Seti(Oort oort) {
        this._oort = oort;
        this._setiId = this.generateSetiId(oort.getURL());
        this._logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + this._setiId));
        this._session = oort.getBayeuxServer().newLocalSession(this._setiId);
        this._debug = oort.isDebugEnabled();
    }

    protected Logger getLogger() {
        return this._logger;
    }

    public boolean isDebugEnabled() {
        return this._debug;
    }

    public void setDebugEnabled(boolean debug) {
        this._debug = debug;
    }

    private void debug(String message, Object ... args) {
        if (this._debug) {
            this._logger.info(message, args);
        } else {
            this._logger.debug(message, args);
        }
    }

    public Oort getOort() {
        return this._oort;
    }

    public String getId() {
        return this._setiId;
    }

    protected void doStart() throws Exception {
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        this._session.handshake();
        ((ServerChannel)bayeux.createChannelIfAbsent(SETI_ALL_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference()).setPersistent(true);
        this._oort.observeChannel(SETI_ALL_CHANNEL);
        this._session.getChannel(SETI_ALL_CHANNEL).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receiveBroadcast(message);
            }
        });
        String setiChannel = this.generateSetiChannel(this._setiId);
        ((ServerChannel)bayeux.createChannelIfAbsent(setiChannel, new ConfigurableServerChannel.Initializer[0]).getReference()).setPersistent(true);
        this._session.getChannel(setiChannel).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receiveDirect(message);
            }
        });
        this._oort.observeChannel(setiChannel);
        this._oort.addCometListener(this._cometListener);
        this._session.getChannel(SETI_ALL_CHANNEL).publish((Object)new SetiPresence(true, this.getAssociatedUserIds()));
    }

    protected void doStop() throws Exception {
        this.removeAssociationsAndPresences();
        this._presenceListeners.clear();
        this._setis.clear();
        this._session.disconnect();
        this._oort.removeCometListener(this._cometListener);
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        String channel = this.generateSetiChannel(this._setiId);
        this._oort.deobserveChannel(channel);
        bayeux.getChannel(channel).setPersistent(false);
        this._oort.deobserveChannel(SETI_ALL_CHANNEL);
        bayeux.getChannel(SETI_ALL_CHANNEL).setPersistent(false);
    }

    protected String generateSetiId(String oortURL) {
        return Oort.replacePunctuation(oortURL, '_');
    }

    protected String generateSetiChannel(String setiId) {
        return "/seti/" + setiId;
    }

    public boolean associate(String userId, ServerSession session) {
        if (session == null) {
            throw new NullPointerException();
        }
        LocalLocation location = new LocalLocation(userId, session);
        boolean wasAssociated = this.isAssociated(userId);
        boolean added = this.associate(userId, location);
        if (added) {
            session.addListener((ServerSession.ServerSessionListener)location);
            this.debug("Associated session {} to user {}", session, userId);
            if (!wasAssociated) {
                this.debug("Broadcasting presence addition for user {}", userId);
                this._session.getChannel(SETI_ALL_CHANNEL).publish((Object)new SetiPresence(true, userId));
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean associate(String userId, Location location) {
        if (!this.isRunning()) {
            return false;
        }
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                locations = new HashSet<Location>();
                this._uid2Location.put(userId, locations);
            }
            boolean result = locations.add(location);
            this.debug("Associations {}", this._uid2Location);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssociated(String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                return false;
            }
            for (Location location : locations) {
                if (!(location instanceof LocalLocation)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAssociationCount(String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                return 0;
            }
            int result = 0;
            for (Location location : locations) {
                if (!(location instanceof LocalLocation)) continue;
                ++result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPresent(String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            return locations != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPresenceCount(String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            return locations == null ? 0 : locations.size();
        }
    }

    public boolean disassociate(String userId, ServerSession session) {
        LocalLocation location = new LocalLocation(userId, session);
        boolean removed = this.disassociate(userId, location);
        if (removed) {
            this.debug("Disassociated session {} from user {}", session, userId);
        }
        if (this._session.isConnected() && !this.isAssociated(userId)) {
            this.debug("Broadcasting presence removal for user {}", userId);
            this._session.getChannel(SETI_ALL_CHANNEL).publish((Object)new SetiPresence(false, userId));
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean disassociate(String userId, Location location) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            boolean result = false;
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations != null) {
                result = locations.remove(location);
                if (locations.isEmpty()) {
                    this._uid2Location.remove(userId);
                }
            }
            this.debug("Associations {}", this._uid2Location);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAssociationsAndPresences() {
        final HashSet<String> userIds = new HashSet<String>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            this.getAssociatedUserIds(userIds);
            this._uid2Location.clear();
        }
        this.debug("Broadcasting presence removal for users {}", userIds);
        this._session.batch(new Runnable(){

            public void run() {
                ClientSessionChannel setiAllChannel = Seti.this._session.getChannel(Seti.SETI_ALL_CHANNEL);
                if (!userIds.isEmpty()) {
                    setiAllChannel.publish((Object)new SetiPresence(false, userIds));
                }
                setiAllChannel.publish((Object)new SetiPresence(false, Collections.emptySet()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePresences(String oortURL) {
        ArrayList<String> userIds = new ArrayList<String>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Iterator<Map.Entry<String, Set<Location>>> entries = this._uid2Location.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, Set<Location>> entry = entries.next();
                Set<Location> userLocations = entry.getValue();
                Iterator<Location> iterator = userLocations.iterator();
                while (iterator.hasNext()) {
                    Location location = iterator.next();
                    if (!(location instanceof SetiLocation) || !oortURL.equals(((SetiLocation)location)._oortURL)) continue;
                    iterator.remove();
                    userIds.add(entry.getKey());
                    break;
                }
                if (!userLocations.isEmpty()) continue;
                entries.remove();
            }
        }
        this._logger.debug("Removing presences of {} for users {}", (Object)oortURL, userIds);
        for (String userId : userIds) {
            this.notifyPresenceRemoved(oortURL, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUserIds() {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            return new HashSet<String>(this._uid2Location.keySet());
        }
    }

    public Set<String> getAssociatedUserIds() {
        HashSet<String> result = new HashSet<String>();
        this.getAssociatedUserIds(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAssociatedUserIds(Set<String> result) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            block3: for (Map.Entry<String, Set<Location>> entry : this._uid2Location.entrySet()) {
                for (Location location : entry.getValue()) {
                    if (!(location instanceof LocalLocation)) continue;
                    result.add(entry.getKey());
                    continue block3;
                }
            }
        }
    }

    public void sendMessage(String toUserId, String toChannel, Object data) {
        this.sendMessage(Collections.singleton(toUserId), toChannel, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Collection<String> toUserIds, String toChannel, Object data) {
        for (String toUserId : toUserIds) {
            HashSet<Location> copy = new HashSet<Location>();
            Map<String, Set<Location>> map = this._uid2Location;
            synchronized (map) {
                Set<Location> locations = this._uid2Location.get(toUserId);
                if (locations == null) {
                    copy.add(new SetiLocation(toUserId, null));
                } else {
                    copy.addAll(locations);
                }
            }
            this.debug("Sending message to locations {}", copy);
            for (Location location : copy) {
                location.send(toUserId, toChannel, data);
            }
        }
    }

    protected void receiveDirect(Message message) {
        this.debug("Received direct message {}", message);
        Map data = message.getDataAsMap();
        Boolean presence = (Boolean)data.get("presence");
        if (presence != null) {
            this.receivePresence(data);
        } else {
            this.receiveMessage(data);
        }
    }

    protected void receiveBroadcast(Message message) {
        this.debug("Received broadcast message {}", message);
        Map data = message.getDataAsMap();
        Boolean presence = (Boolean)data.get("presence");
        if (presence != null) {
            this.receivePresence(data);
        } else {
            this.receiveMessage(data);
        }
    }

    protected void receivePresence(Map<String, Object> presence) {
        this.debug("Received presence message {}", presence);
        String setiId = (String)presence.get("setiId");
        if (this._setiId.equals(setiId)) {
            this.receiveLocalPresence(presence);
        } else {
            this.receiveRemotePresence(presence);
        }
    }

    private void receiveLocalPresence(Map<String, Object> presence) {
        String oortURL = (String)presence.get("oortURL");
        boolean present = (Boolean)presence.get("presence");
        Set<String> userIds = this.convertPresenceUsers(presence);
        this.debug("Notifying presence listeners {}", presence);
        for (String userId : userIds) {
            if (present) {
                this.notifyPresenceAdded(oortURL, userId);
                continue;
            }
            this.notifyPresenceRemoved(oortURL, userId);
        }
    }

    private void receiveRemotePresence(Map<String, Object> presence) {
        boolean isSetiKnown;
        String setiId = (String)presence.get("setiId");
        boolean present = (Boolean)presence.get("presence");
        Set<String> userIds = this.convertPresenceUsers(presence);
        boolean bl = isSetiKnown = this._setis.putIfAbsent(setiId, true) != null;
        if (!isSetiKnown) {
            this.debug("Seti appeared {}", setiId);
        }
        if (userIds.isEmpty()) {
            if (isSetiKnown && !present) {
                this._setis.remove(setiId);
                this.debug("Seti disappeared {}", setiId);
            }
        } else {
            String oortURL = (String)presence.get("oortURL");
            for (String userId : userIds) {
                SetiLocation location = new SetiLocation(userId, oortURL);
                if (present) {
                    if (!this.associate(userId, location)) continue;
                    this.notifyPresenceAdded(oortURL, userId);
                    continue;
                }
                if (!this.disassociate(userId, location)) continue;
                this.notifyPresenceRemoved(oortURL, userId);
            }
        }
        if (!isSetiKnown) {
            Set<String> associatedUserIds = this.getAssociatedUserIds();
            this.debug("Pushing associated {} to {}", associatedUserIds, setiId);
            this._session.getChannel(this.generateSetiChannel(setiId)).publish((Object)new SetiPresence(true, associatedUserIds));
        }
    }

    public void addPresenceListener(PresenceListener listener) {
        this._presenceListeners.add(listener);
    }

    public void removePresenceListener(PresenceListener listener) {
        this._presenceListeners.remove(listener);
    }

    private void notifyPresenceAdded(String oortURL, String userId) {
        PresenceListener.Event event = new PresenceListener.Event(this, userId, oortURL);
        for (PresenceListener listener : this._presenceListeners) {
            try {
                listener.presenceAdded(event);
            }
            catch (Exception x) {
                this._logger.info("Exception while invoking listener " + listener, (Throwable)x);
            }
        }
    }

    private void notifyPresenceRemoved(String oortURL, String userId) {
        PresenceListener.Event event = new PresenceListener.Event(this, userId, oortURL);
        for (PresenceListener listener : this._presenceListeners) {
            try {
                listener.presenceRemoved(event);
            }
            catch (Exception x) {
                this._logger.info("Exception while invoking listener " + listener, (Throwable)x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveMessage(Map<String, Object> message) {
        String userId = (String)message.get("userId");
        String channel = (String)message.get("channel");
        Object data = message.get("data");
        HashSet<Location> copy = new HashSet<Location>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations != null) {
                for (Location location : locations) {
                    if (!(location instanceof LocalLocation)) continue;
                    copy.add(location);
                }
            }
        }
        this.debug("Received message {} for locations {}", message, copy);
        for (Location location : copy) {
            location.receive(userId, channel, data);
        }
    }

    private Set<String> convertPresenceUsers(Map<String, Object> presence) {
        Object value = presence.get("userIds");
        if (value instanceof Set) {
            return (Set)value;
        }
        if (value instanceof Collection) {
            return new HashSet<String>((Collection)value);
        }
        if (value.getClass().isArray()) {
            HashSet<String> result = new HashSet<String>();
            for (Object item : (Object[])value) {
                result.add(item.toString());
            }
            return result;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getName(), this.getId());
    }

    private class CometListener
    implements Oort.CometListener {
        private CometListener() {
        }

        public void cometJoined(Oort.CometListener.Event event) {
            String oortURL = event.getCometURL();
            Seti.this._logger.debug("Comet joined: {}", (Object)oortURL);
            OortComet oortComet = Seti.this._oort.getComet(oortURL);
            if (oortComet != null) {
                ClientSessionChannel channel = oortComet.getChannel(Seti.this.generateSetiChannel(Seti.this.generateSetiId(oortURL)));
                channel.publish((Object)new SetiPresence(true, Seti.this.getAssociatedUserIds()));
            }
        }

        public void cometLeft(Oort.CometListener.Event event) {
            String oortURL = event.getCometURL();
            Seti.this._logger.debug("Comet left: {}", (Object)oortURL);
            Seti.this.removePresences(oortURL);
        }
    }

    public static interface PresenceListener
    extends EventListener {
        public void presenceAdded(Event var1);

        public void presenceRemoved(Event var1);

        public static class Event
        extends EventObject {
            private final String userId;
            private final String url;

            public Event(Seti source, String userId, String url) {
                super((Object)source);
                this.userId = userId;
                this.url = url;
            }

            public Seti getSeti() {
                return (Seti)((Object)this.getSource());
            }

            public String getUserId() {
                return this.userId;
            }

            public String getOortURL() {
                return this.url;
            }

            public boolean isLocal() {
                return this.getSeti().getOort().getURL().equals(this.getOortURL());
            }

            public String toString() {
                return String.format("%s[%s %s on %s]", new Object[]{this.getClass().getName(), this.getUserId(), this.isLocal() ? "local" : "remote", this.getSeti()});
            }
        }

        public static class Adapter
        implements PresenceListener {
            public void presenceAdded(Event event) {
            }

            public void presenceRemoved(Event event) {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetiPresence
    extends HashMap<String, Object> {
        private static final String USER_IDS_FIELD = "userIds";
        private static final String OORT_URL_FIELD = "oortURL";
        private static final String SETI_ID_FIELD = "setiId";
        private static final String PRESENCE_FIELD = "presence";

        private SetiPresence(boolean present, String userId) {
            this(present, Collections.singleton(userId));
        }

        private SetiPresence(boolean present, Set<String> userIds) {
            super(4);
            this.put(USER_IDS_FIELD, userIds);
            this.put(OORT_URL_FIELD, Seti.this._oort.getURL());
            this.put(SETI_ID_FIELD, Seti.this._setiId);
            this.put(PRESENCE_FIELD, present);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetiMessage
    extends HashMap<String, Object> {
        private static final String USER_ID_FIELD = "userId";
        private static final String CHANNEL_FIELD = "channel";
        private static final String SETI_ID_FIELD = "setiId";
        private static final String DATA_FIELD = "data";

        private SetiMessage(String toUser, String toChannel, Object data) {
            super(4);
            this.put(USER_ID_FIELD, toUser);
            this.put(CHANNEL_FIELD, toChannel);
            this.put(SETI_ID_FIELD, Seti.this._setiId);
            this.put(DATA_FIELD, data);
        }
    }

    protected class SetiLocation
    implements Location {
        private final String _userId;
        private final String _oortURL;
        private final String _setiChannel;

        protected SetiLocation(String userId, String oortURL) {
            this._userId = userId;
            this._oortURL = oortURL;
            this._setiChannel = oortURL == null ? Seti.SETI_ALL_CHANNEL : Seti.this.generateSetiChannel(Seti.this.generateSetiId(oortURL));
        }

        public void send(String toUser, String toChannel, Object data) {
            Seti.this._session.getChannel(this._setiChannel).publish((Object)new SetiMessage(toUser, toChannel, data));
        }

        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SetiLocation)) {
                return false;
            }
            SetiLocation that = (SetiLocation)obj;
            return this._userId.equals(that._userId) && this._setiChannel.equals(that._setiChannel);
        }

        public int hashCode() {
            return 31 * this._userId.hashCode() + this._setiChannel.hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._setiChannel + "]";
        }
    }

    protected class LocalLocation
    implements Location,
    ServerSession.RemoveListener {
        private final String _userId;
        private final ServerSession _session;

        protected LocalLocation(String userId, ServerSession session) {
            this._userId = userId;
            this._session = session;
        }

        public void send(String toUser, String toChannel, Object data) {
            this._session.deliver((Session)Seti.this._session.getServerSession(), toChannel, data, null);
        }

        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        public void removed(ServerSession session, boolean timeout) {
            Seti.this.disassociate(this._userId, session);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LocalLocation)) {
                return false;
            }
            LocalLocation that = (LocalLocation)obj;
            return this._userId.equals(that._userId) && this._session.getId().equals(that._session.getId());
        }

        public int hashCode() {
            return 31 * this._userId.hashCode() + this._session.getId().hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._session + "]";
        }
    }

    protected static interface Location {
        public void send(String var1, String var2, Object var3);

        public void receive(String var1, String var2, Object var3);

        public int hashCode();

        public boolean equals(Object var1);
    }
}

