/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.client.ext.AckExtension;
import org.cometd.common.HashMapMessage;
import org.cometd.common.JSONContext;
import org.cometd.oort.OortComet;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.cometd.server.ext.AcknowledgedMessagesExtension;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.WebSocketClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Oort
extends AggregateLifeCycle {
    public static final String OORT_ATTRIBUTE = Oort.class.getName();
    public static final String EXT_OORT_FIELD = "org.cometd.oort";
    public static final String EXT_OORT_URL_FIELD = "oortURL";
    public static final String EXT_OORT_ID_FIELD = "oortId";
    public static final String EXT_OORT_SECRET_FIELD = "oortSecret";
    public static final String EXT_COMET_URL_FIELD = "cometURL";
    public static final String EXT_OORT_ALIAS_URL_FIELD = "oortAliasURL";
    public static final String OORT_CLOUD_CHANNEL = "/oort/cloud";
    public static final String OORT_SERVICE_CHANNEL = "/service/oort";
    private static final String COMET_URL_ATTRIBUTE = "org.cometd.oort.cometURL";
    private final ConcurrentMap<String, OortComet> _pendingComets = new ConcurrentHashMap<String, OortComet>();
    private final ConcurrentMap<String, ClientCometInfo> _clientComets = new ConcurrentHashMap<String, ClientCometInfo>();
    private final ConcurrentMap<String, ServerCometInfo> _serverComets = new ConcurrentHashMap<String, ServerCometInfo>();
    private final ConcurrentMap<String, Boolean> _channels = new ConcurrentHashMap<String, Boolean>();
    private final CopyOnWriteArrayList<CometListener> _cometListeners = new CopyOnWriteArrayList();
    private final BayeuxServer.Extension _oortExtension = new OortExtension();
    private final ServerChannel.MessageListener _cloudListener = new CloudListener();
    private final ServerChannel.MessageListener _joinListener = new JoinListener();
    private final BayeuxServer _bayeux;
    private final String _url;
    private final String _id;
    private final Logger _logger;
    private ThreadPool _threadPool;
    private HttpClient _httpClient;
    private WebSocketClientFactory _wsFactory;
    private final LocalSession _oortSession;
    private String _secret;
    private boolean _debug;
    private boolean _clientDebug;
    private boolean _ackExtensionEnabled;
    private BayeuxServer.Extension _ackExtension;
    private JSONContext.Client _jsonContext;

    public Oort(BayeuxServer bayeux, String url) {
        this._bayeux = bayeux;
        this._url = url;
        this._id = UUID.randomUUID().toString();
        this._logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + Oort.replacePunctuation(this._url, '_')));
        this._debug = String.valueOf(3).equals(bayeux.getOption("logLevel"));
        this._oortSession = bayeux.newLocalSession("oort");
        this._secret = Long.toHexString(new SecureRandom().nextLong());
    }

    protected void doStart() throws Exception {
        if (this._threadPool == null) {
            this._threadPool = new QueuedThreadPool();
        }
        this.addBean(this._threadPool);
        if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).start();
        }
        if (this._httpClient == null) {
            this._httpClient = new HttpClient();
            this._httpClient.setThreadPool(this._threadPool);
        }
        this.addBean(this._httpClient);
        if (this._wsFactory == null) {
            this._wsFactory = new WebSocketClientFactory(this._threadPool);
        }
        this.addBean(this._wsFactory);
        super.doStart();
        if (this.isAckExtensionEnabled()) {
            boolean present = false;
            for (BayeuxServer.Extension extension : this._bayeux.getExtensions()) {
                if (!(extension instanceof AcknowledgedMessagesExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                this._ackExtension = new AcknowledgedMessagesExtension();
                this._bayeux.addExtension(this._ackExtension);
            }
        }
        this._bayeux.addExtension(this._oortExtension);
        ServerChannel oortCloudChannel = (ServerChannel)this._bayeux.createChannelIfAbsent(OORT_CLOUD_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference();
        oortCloudChannel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
        oortCloudChannel.addListener((ConfigurableServerChannel.ServerChannelListener)this._cloudListener);
        ServerChannel oortServiceChannel = (ServerChannel)this._bayeux.createChannelIfAbsent(OORT_SERVICE_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference();
        oortServiceChannel.addListener((ConfigurableServerChannel.ServerChannelListener)this._joinListener);
        this._oortSession.handshake();
    }

    protected void doStop() throws Exception {
        this._oortSession.disconnect();
        for (OortComet comet : this._pendingComets.values()) {
            comet.disconnect(1000L);
        }
        this._pendingComets.clear();
        for (ClientCometInfo cometInfo : this._clientComets.values()) {
            cometInfo.comet.disconnect(1000L);
        }
        this._clientComets.clear();
        this._serverComets.clear();
        this._channels.clear();
        this._bayeux.getChannel(OORT_SERVICE_CHANNEL).removeListener((ConfigurableServerChannel.ServerChannelListener)this._joinListener);
        ServerChannel oortCloudChannel = this._bayeux.getChannel(OORT_CLOUD_CHANNEL);
        oortCloudChannel.removeListener((ConfigurableServerChannel.ServerChannelListener)this._cloudListener);
        oortCloudChannel.removeAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
        BayeuxServer.Extension ackExtension = this._ackExtension;
        this._ackExtension = null;
        if (ackExtension != null) {
            this._bayeux.removeExtension(ackExtension);
        }
        this._bayeux.removeExtension(this._oortExtension);
        super.doStop();
    }

    public BayeuxServer getBayeuxServer() {
        return this._bayeux;
    }

    public String getURL() {
        return this._url;
    }

    public String getId() {
        return this._id;
    }

    public String getSecret() {
        return this._secret;
    }

    public void setSecret(String secret) {
        this._secret = secret;
    }

    public boolean isDebugEnabled() {
        return this._debug;
    }

    public void setDebugEnabled(boolean debug) {
        this._debug = debug;
    }

    private void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this._logger.info(message, args);
        } else {
            this._logger.debug(message, args);
        }
    }

    public boolean isClientDebugEnabled() {
        return this._clientDebug;
    }

    public void setClientDebugEnabled(boolean clientDebugEnabled) {
        this._clientDebug = clientDebugEnabled;
        for (ClientCometInfo cometInfo : this._clientComets.values()) {
            cometInfo.comet.setDebugEnabled(clientDebugEnabled);
        }
    }

    public boolean isAckExtensionEnabled() {
        return this._ackExtensionEnabled;
    }

    public void setAckExtensionEnabled(boolean value) {
        this._ackExtensionEnabled = value;
    }

    public JSONContext.Client getJSONContextClient() {
        return this._jsonContext;
    }

    public void setJSONContextClient(JSONContext.Client jsonContext) {
        this._jsonContext = jsonContext;
    }

    public OortComet observeComet(String cometURL) {
        return this.observeComet(cometURL, null);
    }

    protected OortComet observeComet(String cometURL, String cometAliasURL) {
        this.debug("Observing comet {}", cometURL);
        try {
            URI uri = new URI(cometURL);
            if (uri.getScheme() == null) {
                throw new IllegalArgumentException("Missing protocol in comet URL " + cometURL);
            }
            if (uri.getHost() == null) {
                throw new IllegalArgumentException("Missing host in comet URL " + cometURL);
            }
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x);
        }
        if (this._url.equals(cometURL)) {
            return null;
        }
        OortComet comet = this.getComet(cometURL);
        if (comet != null) {
            this.debug("Comet {} is already connected", cometURL);
            return comet;
        }
        comet = this.newOortComet(cometURL);
        this.configureOortComet(comet);
        OortComet existing = this._pendingComets.putIfAbsent(cometURL, comet);
        if (existing != null) {
            this.debug("Comet {} is already connecting", cometURL);
            return existing;
        }
        comet.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)new HandshakeListener(cometURL, comet));
        this.debug("Connecting to comet {}", cometURL);
        String b64Secret = this.encodeSecret(this.getSecret());
        HashMapMessage fields = new HashMapMessage();
        Map ext = fields.getExt(true);
        HashMap<String, String> oortExt = new HashMap<String, String>(4);
        ext.put(EXT_OORT_FIELD, oortExt);
        oortExt.put(EXT_OORT_URL_FIELD, this.getURL());
        oortExt.put(EXT_OORT_ID_FIELD, this.getId());
        oortExt.put(EXT_OORT_SECRET_FIELD, b64Secret);
        oortExt.put(EXT_COMET_URL_FIELD, cometURL);
        if (cometAliasURL != null) {
            oortExt.put(EXT_OORT_ALIAS_URL_FIELD, cometAliasURL);
        }
        this.connectComet(comet, (Message.Mutable)fields);
        return comet;
    }

    protected OortComet newOortComet(String cometURL) {
        String maxMessageSizeOption;
        Object option;
        HashMap<String, Object> options = new HashMap<String, Object>(1);
        JSONContext.Client jsonContext = this.getJSONContextClient();
        if (jsonContext != null) {
            options.put("jsonContext", jsonContext);
        }
        if ((option = this._bayeux.getOption(maxMessageSizeOption = "ws.maxMessageSize")) != null) {
            long value = option instanceof Number ? ((Number)option).longValue() : Long.parseLong(option.toString());
            options.put(maxMessageSizeOption, value);
        }
        return new OortComet(this, cometURL, options);
    }

    protected void configureOortComet(OortComet oortComet) {
        if (this.isAckExtensionEnabled()) {
            boolean present = false;
            for (ClientSession.Extension extension : oortComet.getExtensions()) {
                if (!(extension instanceof AckExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                oortComet.addExtension((ClientSession.Extension)new AckExtension());
            }
        }
    }

    protected String encodeSecret(String secret) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            return new String(B64Code.encode((byte[])digest.digest(secret.getBytes("UTF-8"))));
        }
        catch (Exception x) {
            throw new IllegalArgumentException(x);
        }
    }

    protected void connectComet(OortComet comet, Message.Mutable fields) {
        comet.handshake((Map)fields);
    }

    public OortComet deobserveComet(String cometURL) {
        if (this._url.equals(cometURL)) {
            return null;
        }
        OortComet comet = (OortComet)((Object)this._pendingComets.remove(cometURL));
        if (comet != null) {
            this.debug("Disconnecting pending comet {}", cometURL);
            comet.disconnect();
        }
        Iterator cometInfos = this._clientComets.values().iterator();
        while (cometInfos.hasNext()) {
            ClientCometInfo cometInfo = (ClientCometInfo)cometInfos.next();
            if (!cometInfo.matchesURL(cometURL)) continue;
            this.debug("Disconnecting comet {}", cometURL);
            comet = cometInfo.getOortComet();
            comet.disconnect();
            cometInfos.remove();
            break;
        }
        return comet;
    }

    public Set<String> getKnownComets() {
        HashSet<String> result = new HashSet<String>();
        for (ClientCometInfo cometInfo : this._clientComets.values()) {
            result.add(cometInfo.getOortURL());
        }
        return result;
    }

    public OortComet getComet(String cometURL) {
        for (ClientCometInfo cometInfo : this._clientComets.values()) {
            if (!cometInfo.matchesURL(cometURL)) continue;
            return cometInfo.getOortComet();
        }
        return null;
    }

    protected OortComet findComet(String cometURL) {
        OortComet result = this.getComet(cometURL);
        if (result == null) {
            result = (OortComet)((Object)this._pendingComets.get(cometURL));
        }
        return result;
    }

    public void observeChannel(String channelName) {
        this.debug("Observing channel {}", channelName);
        if (!ChannelId.isBroadcast((String)channelName)) {
            throw new IllegalArgumentException("Channel " + channelName + " cannot be observed because is not a broadcast channel");
        }
        if (this._channels.putIfAbsent(channelName, Boolean.TRUE) == null) {
            Set<String> observedChannels = this.getObservedChannels();
            for (ClientCometInfo cometInfo : this._clientComets.values()) {
                cometInfo.getOortComet().subscribe(observedChannels);
            }
        }
    }

    public void deobserveChannel(String channelId) {
        if (this._channels.remove(channelId) != null) {
            for (ClientCometInfo cometInfo : this._clientComets.values()) {
                cometInfo.getOortComet().unsubscribe(channelId);
            }
        }
    }

    public boolean isOort(ServerSession session) {
        String id = session.getId();
        if (id.equals(this._oortSession.getId())) {
            return true;
        }
        for (ServerCometInfo cometInfo : this._serverComets.values()) {
            if (!cometInfo.getServerSession().getId().equals(session.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean isOortHandshake(Message handshake) {
        if (!"/meta/handshake".equals(handshake.getChannel())) {
            return false;
        }
        Map ext = handshake.getExt();
        if (ext == null) {
            return false;
        }
        Object oortExtObject = ext.get(EXT_OORT_FIELD);
        if (!(oortExtObject instanceof Map)) {
            return false;
        }
        Map oortExt = (Map)oortExtObject;
        String cometURL = (String)oortExt.get(EXT_COMET_URL_FIELD);
        if (!this.getURL().equals(cometURL)) {
            return false;
        }
        String b64RemoteSecret = (String)oortExt.get(EXT_OORT_SECRET_FIELD);
        String b64LocalSecret = this.encodeSecret(this.getSecret());
        return b64LocalSecret.equals(b64RemoteSecret);
    }

    protected boolean isCometConnected(String oortURL) {
        for (ServerCometInfo serverCometInfo : this._serverComets.values()) {
            if (!serverCometInfo.getOortURL().equals(oortURL)) continue;
            return true;
        }
        return false;
    }

    protected boolean incomingCometHandshake(Map<String, Object> oortExt, ServerSession session) {
        String remoteOortURL = (String)oortExt.get(EXT_OORT_URL_FIELD);
        this.debug("Incoming comet handshake from comet {} with {}", remoteOortURL, session);
        String remoteOortId = (String)oortExt.get(EXT_OORT_ID_FIELD);
        ServerCometInfo serverCometInfo = new ServerCometInfo(remoteOortId, remoteOortURL, session);
        ServerCometInfo existing = this._serverComets.putIfAbsent(remoteOortId, serverCometInfo);
        if (existing != null) {
            this.debug("Comet {} is already known with {}", remoteOortURL, existing.getServerSession());
            return false;
        }
        session.setAttribute(COMET_URL_ATTRIBUTE, (Object)remoteOortURL);
        session.addListener((ServerSession.ServerSessionListener)new OortCometDisconnectListener(remoteOortURL, remoteOortId));
        session.addListener((ServerSession.ServerSessionListener)new OortCometLoopListener());
        return true;
    }

    public void addCometListener(CometListener listener) {
        this._cometListeners.add(listener);
    }

    public void removeCometListener(CometListener listener) {
        this._cometListeners.remove(listener);
    }

    private void notifyCometJoined(String remoteURL) {
        CometListener.Event event = new CometListener.Event(this, remoteURL);
        for (CometListener cometListener : this._cometListeners) {
            try {
                cometListener.cometJoined(event);
            }
            catch (Exception x) {
                this._logger.info("Exception while invoking listener " + cometListener, (Throwable)x);
            }
        }
    }

    private void notifyCometLeft(String remoteURL) {
        CometListener.Event event = new CometListener.Event(this, remoteURL);
        for (CometListener cometListener : this._cometListeners) {
            try {
                cometListener.cometLeft(event);
            }
            catch (Exception x) {
                this._logger.info("Exception while invoking listener " + cometListener, (Throwable)x);
            }
        }
    }

    protected void joinComets(Message message) {
        Object[] array;
        Object data = message.getData();
        for (Object element : array = data instanceof List ? ((List)data).toArray() : (Object[])data) {
            this.observeComet((String)element);
        }
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public WebSocketClientFactory getWebSocketClientFactory() {
        return this._wsFactory;
    }

    public void setWebSocketClientFactory(WebSocketClientFactory wsFactory) {
        this._wsFactory = wsFactory;
    }

    public HttpClient getHttpClient() {
        return this._httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    protected Logger getLogger() {
        return this._logger;
    }

    public Set<String> getObservedChannels() {
        return new HashSet<String>(this._channels.keySet());
    }

    public LocalSession getOortSession() {
        return this._oortSession;
    }

    protected static String replacePunctuation(String source, char replacement) {
        String replaced = source.replaceAll("[^\\p{Alnum}]", String.valueOf(replacement));
        return replaced.replaceAll("(" + replacement + ")\\1+", "$1");
    }

    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        final String eol = System.getProperty("line.separator");
        Dumpable comets = new Dumpable(){

            public String dump() {
                return null;
            }

            public void dump(Appendable out, String indent) throws IOException {
                Set<String> knownComets = Oort.this.getKnownComets();
                out.append("Connected comets: ").append(String.valueOf(knownComets.size())).append(eol);
                AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{knownComets});
            }
        };
        Dumpable channels = new Dumpable(){

            public String dump() {
                return null;
            }

            public void dump(Appendable out, String indent) throws IOException {
                Set<String> observedChannels = Oort.this.getObservedChannels();
                out.append("Observed channels: ").append(String.valueOf(observedChannels.size())).append(eol);
                AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{observedChannels});
            }
        };
        AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList(comets, channels)});
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.getURL());
    }

    protected static class ClientCometInfo
    extends CometInfo {
        private final OortComet comet;
        private final Map<String, Boolean> urls = new ConcurrentHashMap<String, Boolean>();

        protected ClientCometInfo(String oortId, String oortURL, OortComet comet) {
            super(oortId, oortURL);
            this.comet = comet;
        }

        public OortComet getOortComet() {
            return this.comet;
        }

        public void addAliasURL(String url) {
            this.urls.put(url, Boolean.TRUE);
        }

        public boolean matchesURL(String url) {
            return this.getOortURL().equals(url) || this.urls.containsKey(url);
        }
    }

    protected static class ServerCometInfo
    extends CometInfo {
        private final ServerSession session;

        protected ServerCometInfo(String oortId, String oortURL, ServerSession session) {
            super(oortId, oortURL);
            this.session = session;
        }

        public ServerSession getServerSession() {
            return this.session;
        }
    }

    protected static abstract class CometInfo {
        private final String oortId;
        private final String oortURL;

        protected CometInfo(String oortId, String oortURL) {
            this.oortId = oortId;
            this.oortURL = oortURL;
        }

        public String getOortId() {
            return this.oortId;
        }

        public String getOortURL() {
            return this.oortURL;
        }
    }

    private class HandshakeListener
    implements ClientSessionChannel.MessageListener {
        private final String cometURL;
        private final OortComet oortComet;

        private HandshakeListener(String cometURL, OortComet oortComet) {
            this.cometURL = cometURL;
            this.oortComet = oortComet;
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            Object oortExtObject;
            Map ext;
            OortComet comet = (OortComet)((Object)Oort.this._pendingComets.get(this.cometURL));
            if (comet != null && !message.isSuccessful()) {
                Oort.this.getLogger().warn("Failed to connect to comet {}, message {}", (Object)this.cometURL, (Object)message);
                Map advice = message.getAdvice();
                if (advice != null && "none".equals(advice.get("reconnect"))) {
                    Oort.this.debug("Disconnecting pending comet {}", new Object[]{this.cometURL});
                    comet.disconnect();
                }
            }
            if ((ext = message.getExt()) != null && (oortExtObject = ext.get(Oort.EXT_OORT_FIELD)) instanceof Map) {
                Map oortExt = (Map)oortExtObject;
                String oortURL = (String)oortExt.get(Oort.EXT_OORT_URL_FIELD);
                String oortId = (String)oortExt.get(Oort.EXT_OORT_ID_FIELD);
                ClientCometInfo cometInfo = new ClientCometInfo(oortId, oortURL, this.oortComet);
                ClientCometInfo existing = Oort.this._clientComets.putIfAbsent(oortId, cometInfo);
                if (existing != null) {
                    cometInfo = existing;
                }
                if (!this.cometURL.equals(oortURL)) {
                    cometInfo.addAliasURL(this.cometURL);
                    Oort.this.debug("Adding alias to {}: {}", new Object[]{oortURL, this.cometURL});
                }
                if (message.isSuccessful()) {
                    Oort.this.getLogger().debug("Connected to comet {} as {} with {}/{}", new Object[]{oortURL, this.cometURL, message.getClientId(), this.oortComet.getTransport()});
                }
            }
            if (message.isSuccessful() || comet != null && comet.isDisconnected()) {
                Oort.this._pendingComets.remove(this.cometURL);
            }
        }
    }

    private class OortCometLoopListener
    implements ServerSession.MessageListener {
        private OortCometLoopListener() {
        }

        public boolean onMessage(ServerSession to, ServerSession from, ServerMessage message) {
            if (to.getId().equals(from.getId()) || Oort.this.isOort(from)) {
                Oort.this.debug("{} --| {} {}", new Object[]{from, to, message});
                return false;
            }
            Oort.this.debug("{} --> {} {}", new Object[]{from, to, message});
            return true;
        }
    }

    private class OortCometDisconnectListener
    implements ServerSession.RemoveListener {
        private final String cometURL;
        private final String remoteOortId;

        public OortCometDisconnectListener(String cometURL, String remoteOortId) {
            this.cometURL = cometURL;
            this.remoteOortId = remoteOortId;
        }

        public void removed(ServerSession session, boolean timeout) {
            Iterator cometInfos = Oort.this._serverComets.values().iterator();
            while (cometInfos.hasNext()) {
                ServerCometInfo serverCometInfo = (ServerCometInfo)cometInfos.next();
                if (!serverCometInfo.getServerSession().getId().equals(session.getId())) continue;
                Oort.this._logger.debug("Disconnected from comet {} with session {}", (Object)this.cometURL, (Object)session);
                assert (this.remoteOortId.equals(serverCometInfo.getOortId()));
                cometInfos.remove();
                ClientCometInfo clientCometInfo = (ClientCometInfo)Oort.this._clientComets.remove(this.remoteOortId);
                if (clientCometInfo != null) {
                    clientCometInfo.getOortComet().disconnect();
                }
                if (!Oort.this.isRunning()) break;
                String remoteOortURL = serverCometInfo.getOortURL();
                Oort.this.debug("Comet {} left", new Object[]{remoteOortURL});
                Oort.this.notifyCometLeft(remoteOortURL);
                break;
            }
        }
    }

    public static interface CometListener
    extends EventListener {
        public void cometJoined(Event var1);

        public void cometLeft(Event var1);

        public static class Event
        extends EventObject {
            private final String cometURL;

            public Event(Oort source, String cometURL) {
                super((Object)source);
                this.cometURL = cometURL;
            }

            public Oort getOort() {
                return (Oort)((Object)this.getSource());
            }

            public String getCometURL() {
                return this.cometURL;
            }
        }

        public static class Adapter
        implements CometListener {
            public void cometJoined(Event event) {
            }

            public void cometLeft(Event event) {
            }
        }
    }

    protected class JoinListener
    implements ServerChannel.MessageListener {
        protected JoinListener() {
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            Map data = message.getDataAsMap();
            String remoteOortURL = (String)data.get(Oort.EXT_OORT_URL_FIELD);
            if (remoteOortURL != null) {
                Oort.this.debug("Comet {} joined", new Object[]{remoteOortURL});
                Oort.this.notifyCometJoined(remoteOortURL);
            }
            return true;
        }
    }

    protected class CloudListener
    implements ServerChannel.MessageListener {
        protected CloudListener() {
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (!from.isLocalSession()) {
                Oort.this.joinComets((Message)message);
            }
            return true;
        }
    }

    protected class OortExtension
    extends BayeuxServer.Extension.Adapter {
        protected OortExtension() {
        }

        public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
            if (to == null) {
                return true;
            }
            if (!"/meta/handshake".equals(message.getChannel())) {
                return true;
            }
            if (!message.isSuccessful()) {
                return true;
            }
            Map associatedExt = message.getAssociated().getExt();
            if (associatedExt == null) {
                return true;
            }
            Object associatedOortExtObject = associatedExt.get(Oort.EXT_OORT_FIELD);
            if (associatedOortExtObject instanceof Map) {
                Map associatedOortExt = (Map)associatedOortExtObject;
                String remoteOortURL = (String)associatedOortExt.get(Oort.EXT_OORT_URL_FIELD);
                String cometURL = (String)associatedOortExt.get(Oort.EXT_COMET_URL_FIELD);
                String remoteOortId = (String)associatedOortExt.get(Oort.EXT_OORT_ID_FIELD);
                if (Oort.this._id.equals(remoteOortId)) {
                    Oort.this._logger.warn("Detected self connect from {} to {}, disconnecting", (Object)remoteOortURL, (Object)cometURL);
                    this.disconnect(message);
                } else {
                    Map ext = message.getExt(true);
                    HashMap<String, String> oortExt = new HashMap<String, String>(2);
                    ext.put(Oort.EXT_OORT_FIELD, oortExt);
                    oortExt.put(Oort.EXT_OORT_URL_FIELD, Oort.this.getURL());
                    oortExt.put(Oort.EXT_OORT_ID_FIELD, Oort.this.getId());
                    boolean connectBack = Oort.this.incomingCometHandshake(Collections.unmodifiableMap(associatedOortExt), to);
                    if (connectBack) {
                        String cometAliasURL = (String)associatedOortExt.get(Oort.EXT_OORT_ALIAS_URL_FIELD);
                        if (cometAliasURL != null && Oort.this._pendingComets.containsKey(cometAliasURL)) {
                            Oort.this.debug("Comet {} is pending with alias {}, avoiding to establish connection", new Object[]{remoteOortURL, cometAliasURL});
                        } else {
                            Oort.this.debug("Comet {} is unknown, establishing connection", new Object[]{remoteOortURL});
                            Oort.this.observeComet(remoteOortURL, cometURL);
                        }
                    } else {
                        this.disconnect(message);
                    }
                }
            }
            return true;
        }

        private void disconnect(ServerMessage.Mutable message) {
            message.setSuccessful(false);
            Map advice = message.getAdvice(true);
            advice.put("reconnect", "none");
        }
    }
}

