/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.concurrent.atomic.AtomicLong;
import org.cometd.oort.Oort;
import org.cometd.oort.OortMasterService;
import org.cometd.oort.OortService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OortMasterLong
extends OortMasterService<Long, Context> {
    private final AtomicLong value = new AtomicLong();

    public OortMasterLong(Oort oort, String name, boolean master) {
        this(oort, name, master, 0L);
    }

    public OortMasterLong(Oort oort, String name, boolean master, long initial) {
        super(oort, name, master);
        this.value.set(initial);
    }

    protected long getValue() {
        return this.value.get();
    }

    public boolean get(Callback callback) {
        return this.getAndAdd(0L, callback);
    }

    public boolean addAndGet(long delta, Callback callback) {
        return this.forward(this.getMasterOortURL(), delta, new Context(delta, callback, true));
    }

    public boolean getAndAdd(long delta, Callback callback) {
        return this.forward(this.getMasterOortURL(), delta, new Context(delta, callback, false));
    }

    @Override
    protected OortService.Result<Long> onForward(OortService.Request request) {
        if (!this.isMaster()) {
            return OortService.Result.ignore(0L);
        }
        long delta = ((Number)request.getData()).longValue();
        long oldValue = this.value.get();
        while (!this.value.compareAndSet(oldValue, oldValue + delta)) {
            oldValue = this.value.get();
        }
        return OortService.Result.success(oldValue);
    }

    @Override
    protected void onForwardSucceeded(Long result, Context context) {
        context.callback.succeeded(context.compute ? result + context.delta : result);
    }

    @Override
    protected void onForwardFailed(Object failure, Context context) {
        context.callback.failed(failure);
    }

    protected static class Context {
        private final long delta;
        private final Callback callback;
        private final boolean compute;

        private Context(long delta, Callback callback, boolean compute) {
            this.delta = delta;
            this.callback = callback;
            this.compute = compute;
        }
    }

    public static interface Callback {
        public void succeeded(Long var1);

        public void failed(Object var1);

        public static class Adapter
        implements Callback {
            public void succeeded(Long result) {
            }

            public void failed(Object failure) {
            }
        }
    }
}

