/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.oort.Oort;
import org.cometd.oort.OortObject;
import org.cometd.oort.OortObjectFactories;
import org.cometd.oort.OortObjectMergers;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OortLong
extends AbstractLifeCycle {
    private final AtomicLong atomic = new AtomicLong();
    private final OortObject<Long> value;

    public OortLong(Oort oort, String name) {
        this(oort, name, 0L);
    }

    public OortLong(Oort oort, String name, long initial) {
        this.value = new OortObject<Long>(oort, name, OortObjectFactories.forLong(initial));
    }

    protected void doStart() throws Exception {
        this.value.start();
    }

    protected void doStop() throws Exception {
        this.value.stop();
    }

    public Oort getOort() {
        return this.value.getOort();
    }

    public LocalSession getLocalSession() {
        return this.value.getLocalSession();
    }

    public void addListener(OortObject.Listener<Long> listener) {
        this.value.addListener(listener);
    }

    public void removeListener(OortObject.Listener<Long> listener) {
        this.value.removeListener(listener);
    }

    public long get() {
        return this.atomic.get();
    }

    public long addAndGet(long delta) {
        long result = this.atomic.addAndGet(delta);
        this.value.setAndShare(result);
        return result;
    }

    public long getAndAdd(long delta) {
        long result = this.atomic.getAndAdd(delta);
        this.value.setAndShare(result);
        return result;
    }

    public long getAndSet(long newValue) {
        long result = this.atomic.getAndSet(newValue);
        this.value.setAndShare(newValue);
        return result;
    }

    public boolean compareAndSet(long expected, long newValue) {
        boolean result = this.atomic.compareAndSet(expected, newValue);
        if (result) {
            this.value.setAndShare(newValue);
        }
        return result;
    }

    public long sum() {
        return this.value.merge(OortObjectMergers.longSum());
    }
}

