/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.MarkedReference;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.oort.OortComet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OortObject<T>
extends AbstractLifeCycle
implements ConfigurableServerChannel.Initializer,
Oort.CometListener,
Iterable<Info<T>> {
    public static final String OORT_OBJECTS_CHANNEL = "/oort/objects";
    private final AtomicLong versions = new AtomicLong();
    private final ConcurrentMap<String, Holder<T>> infos = new ConcurrentHashMap<String, Holder<T>>();
    private final List<Listener<T>> listeners = new CopyOnWriteArrayList<Listener<T>>();
    protected final Logger logger;
    private final Oort oort;
    private final String name;
    private final Factory<T> factory;
    private final LocalSession sender;
    private final String channelName;
    private final ServerChannel.MessageListener messageListener;

    public OortObject(Oort oort, String name, Factory<T> factory) {
        this.oort = oort;
        this.name = name;
        this.factory = factory;
        this.logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "." + Oort.replacePunctuation(oort.getURL(), '_') + "." + name));
        this.sender = oort.getBayeuxServer().newLocalSession(this.getClass().getSimpleName() + "." + name);
        this.channelName = "/oort/objects/" + name;
        this.messageListener = new MessageListener();
    }

    protected void doStart() throws Exception {
        Holder holder = new Holder();
        Info<T> info = this.newInfo(this.factory.newObject(null));
        holder.set(info, null);
        this.infos.put(this.oort.getURL(), holder);
        this.logger.debug("Set local {}", info);
        this.sender.handshake();
        this.oort.addCometListener(this);
        BayeuxServer bayeuxServer = this.oort.getBayeuxServer();
        ServerChannel channel = (ServerChannel)bayeuxServer.createChannelIfAbsent(this.channelName, new ConfigurableServerChannel.Initializer[]{this}).getReference();
        channel.addListener((ConfigurableServerChannel.ServerChannelListener)this.messageListener);
        this.oort.observeChannel(this.channelName);
        channel.publish((Session)this.getLocalSession(), info);
        this.logger.debug("{} started", (Object)this);
    }

    protected void doStop() throws Exception {
        this.oort.deobserveChannel(this.channelName);
        ServerChannel channel = this.oort.getBayeuxServer().getChannel(this.channelName);
        if (channel != null) {
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this.messageListener);
        }
        this.oort.removeCometListener(this);
        this.sender.disconnect();
        this.infos.remove(this.oort.getURL());
        this.logger.debug("{} stopped", (Object)this);
    }

    public void configureChannel(ConfigurableServerChannel channel) {
    }

    public Oort getOort() {
        return this.oort;
    }

    public String getName() {
        return this.name;
    }

    public Factory<T> getFactory() {
        return this.factory;
    }

    public LocalSession getLocalSession() {
        return this.sender;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public T setAndShare(T newObject) {
        if (newObject == null) {
            throw new NullPointerException();
        }
        Data data = new Data(4);
        data.put("oort.info.version", this.nextVersion());
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", this.serialize(newObject));
        this.logger.debug("Sharing {}", data);
        BayeuxServer bayeuxServer = this.oort.getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), data);
        return data.getResult();
    }

    protected Object serialize(T object) {
        return object;
    }

    protected Object deserialize(Object object) {
        return object;
    }

    protected Info<T> newInfo(T local) {
        if (local == null) {
            throw new NullPointerException();
        }
        Info info = new Info(this.nextVersion(), this.oort.getURL());
        info.put("oort.info.url", this.oort.getURL());
        info.put("oort.info.name", this.getName());
        info.put("oort.info.object", local);
        return info;
    }

    protected long nextVersion() {
        return this.versions.getAndIncrement();
    }

    @Override
    public void cometJoined(Oort.CometListener.Event event) {
        String remoteOortURL = event.getCometURL();
        this.logger.debug("Oort {} joined", (Object)remoteOortURL);
        this.pushInfo(remoteOortURL, this.getInfo(this.oort.getURL()));
    }

    @Override
    public void cometLeft(Oort.CometListener.Event event) {
        this.logger.debug("Oort {} left", (Object)event.getCometURL());
        Holder holder = (Holder)this.infos.remove(event.getCometURL());
        if (holder != null) {
            Info info = holder.get();
            this.logger.debug("Removed remote {}", (Object)info);
            this.notifyRemoved(info);
        }
    }

    @Override
    public Iterator<Info<T>> iterator() {
        return this.getInfos().iterator();
    }

    public Info<T> getInfo(String oortURL) {
        Holder holder = (Holder)this.infos.get(oortURL);
        return holder == null ? null : holder.get();
    }

    public Info<T> getInfoByObject(T object) {
        for (Info<T> info : this) {
            if (!info.getObject().equals(object)) continue;
            return info;
        }
        return null;
    }

    public <R> R merge(Merger<T, R> strategy) {
        return strategy.merge(this.getInfos());
    }

    public void addListener(Listener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener<T> listener) {
        this.listeners.remove(listener);
    }

    protected void notifyUpdated(Info<T> oldInfo, Info<T> newInfo) {
        for (Listener<T> listener : this.listeners) {
            try {
                listener.onUpdated(oldInfo, newInfo);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    protected void notifyRemoved(Info<T> info) {
        for (Listener<T> listener : this.listeners) {
            try {
                listener.onRemoved(info);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    protected void onObject(Map<String, Object> data) {
        boolean isLocal = this.oort.getURL().equals(data.get("oort.info.url"));
        Object object = data.get("oort.info.object");
        if (!isLocal) {
            object = this.deserialize(object);
        }
        data.put("oort.info.object", this.getFactory().newObject(object));
        Info newInfo = new Info(this.oort.getURL(), data);
        MarkedReference old = this.setInfo(newInfo, null);
        Info oldInfo = (Info)old.getReference();
        this.logger.debug("{} {} update of {} with {}", new Object[]{old.isMarked() ? "Performed" : "Skipped", newInfo.isLocal() ? "local" : "remote", oldInfo, newInfo});
        if (old.isMarked()) {
            this.notifyUpdated(oldInfo, newInfo);
        }
        if (oldInfo == null && !this.oort.getURL().equals(data.get("oort.info.peer"))) {
            HashMap<String, Object> localInfo = new HashMap<String, Object>(this.getInfo(this.oort.getURL()));
            String oortURL = newInfo.getOortURL();
            localInfo.put("oort.info.peer", oortURL);
            this.pushInfo(oortURL, localInfo);
        }
        if (data instanceof Data) {
            ((Data)data).setResult(oldInfo == null ? null : (Object)oldInfo.getObject());
        }
    }

    protected MarkedReference<Info<T>> setInfo(Info<T> newInfo, Runnable action) {
        Holder existing;
        String newOortURL = newInfo.getOortURL();
        Holder holder = (Holder)this.infos.get(newOortURL);
        if (holder == null && (existing = this.infos.putIfAbsent(newOortURL, holder = new Holder())) != null) {
            holder = existing;
        }
        return holder.set(newInfo, action);
    }

    protected void pushInfo(String oortURL, Map<String, Object> info) {
        OortComet oortComet = this.oort.getComet(oortURL);
        this.logger.debug("Pushing (to {}) local {}", (Object)oortURL, info);
        if (oortComet != null) {
            oortComet.getChannel(this.channelName).publish(info);
        }
    }

    protected Collection<Info<T>> getInfos() {
        ArrayList<Info<T>> result = new ArrayList<Info<T>>(this.infos.size());
        for (Holder holders : this.infos.values()) {
            result.add(holders.get());
        }
        return result;
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getSimpleName(), this.getName(), this.getOort().getURL());
    }

    private class MessageListener
    implements ServerChannel.MessageListener {
        private MessageListener() {
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            Map data = message.getDataAsMap();
            boolean sameName = OortObject.this.getName().equals(data.get("oort.info.name"));
            if (sameName) {
                OortObject.this.logger.debug("Received {}", (Object)data);
                OortObject.this.onObject(data);
            }
            return true;
        }
    }

    private static class Holder<T> {
        private Info<T> info;

        private Holder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MarkedReference<Info<T>> set(Info<T> newInfo, Runnable action) {
            Holder holder = this;
            synchronized (holder) {
                Info<T> oldInfo = this.info;
                boolean marked = false;
                if (oldInfo == null || oldInfo.getId() < newInfo.getId()) {
                    this.info = newInfo;
                    marked = true;
                    if (action != null) {
                        action.run();
                    }
                }
                return new MarkedReference(oldInfo, marked);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Info<T> get() {
            Holder holder = this;
            synchronized (holder) {
                return this.info;
            }
        }
    }

    public static interface Listener<T>
    extends EventListener {
        public void onUpdated(Info<T> var1, Info<T> var2);

        public void onRemoved(Info<T> var1);

        public static class Adapter<T>
        implements Listener<T> {
            @Override
            public void onUpdated(Info<T> oldInfo, Info<T> newInfo) {
            }

            @Override
            public void onRemoved(Info<T> info) {
            }
        }
    }

    public static interface Merger<T, R> {
        public R merge(Collection<Info<T>> var1);
    }

    public static interface Factory<T> {
        public T newObject(Object var1);
    }

    protected static class Data<T>
    extends HashMap<String, Object> {
        private T result;

        public Data(int initialCapacity) {
            super(initialCapacity);
        }

        protected T getResult() {
            return this.result;
        }

        protected void setResult(T result) {
            this.result = result;
        }
    }

    public static class Info<T>
    extends HashMap<String, Object> {
        public static final String VERSION_FIELD = "oort.info.version";
        public static final String OORT_URL_FIELD = "oort.info.url";
        public static final String NAME_FIELD = "oort.info.name";
        public static final String OBJECT_FIELD = "oort.info.object";
        public static final String TYPE_FIELD = "oort.info.type";
        public static final String ACTION_FIELD = "oort.info.action";
        public static final String PEER_FIELD = "oort.info.peer";
        private final String oortURL;

        protected Info(long version, String oortURL) {
            super(4);
            this.oortURL = oortURL;
            this.put(VERSION_FIELD, version);
        }

        protected Info(String oortURL, Map<? extends String, ?> map) {
            this(((Number)map.get(VERSION_FIELD)).longValue(), oortURL);
            this.put(OORT_URL_FIELD, map.get(OORT_URL_FIELD));
            this.put(NAME_FIELD, map.get(NAME_FIELD));
            this.put(OBJECT_FIELD, map.get(OBJECT_FIELD));
        }

        protected long getId() {
            return ((Number)this.get(VERSION_FIELD)).longValue();
        }

        public String getOortURL() {
            return (String)this.get(OORT_URL_FIELD);
        }

        public String getName() {
            return (String)this.get(NAME_FIELD);
        }

        public T getObject() {
            return (T)this.get(OBJECT_FIELD);
        }

        public boolean isLocal() {
            return this.oortURL.equals(this.getOortURL());
        }

        @Override
        public String toString() {
            T object = this.getObject();
            String objectString = object instanceof Object[] ? Arrays.toString((Object[])object) : String.valueOf(object);
            return String.format("%s[%s/%d] (from %s): %s", this.getClass().getSimpleName(), this.getName(), this.getId(), this.getOortURL(), objectString);
        }
    }
}

