/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.cometd.client.BayeuxClient;
import org.cometd.oort.Oort;
import org.cometd.oort.OortComet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OortMulticastConfigurer
extends AbstractLifeCycle {
    private static final AtomicInteger ids = new AtomicInteger();
    private final Logger logger;
    private final Oort oort;
    private InetAddress bindAddress;
    private InetAddress groupAddress;
    private int groupPort = 5577;
    private int timeToLive = 1;
    private long advertiseInterval = 2000L;
    private long connectTimeout = 2000L;
    private int maxTransmissionLength = 1400;
    private Thread receiverThread;
    private Thread senderThread;
    private volatile boolean active;

    public OortMulticastConfigurer(Oort oort) {
        this.logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass() + "." + Oort.replacePunctuation(oort.getURL(), '_')));
        this.oort = oort;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public InetAddress getGroupAddress() {
        return this.groupAddress;
    }

    public void setGroupAddress(InetAddress groupAddress) {
        this.groupAddress = groupAddress;
    }

    public int getGroupPort() {
        return this.groupPort;
    }

    public void setGroupPort(int groupPort) {
        this.groupPort = groupPort;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public long getAdvertiseInterval() {
        return this.advertiseInterval;
    }

    public void setAdvertiseInterval(long advertiseInterval) {
        this.advertiseInterval = advertiseInterval;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getMaxTransmissionLength() {
        return this.maxTransmissionLength;
    }

    public void setMaxTransmissionLength(int maxTransmissionLength) {
        this.maxTransmissionLength = maxTransmissionLength;
    }

    protected void doStart() throws Exception {
        MulticastSocket sender = new MulticastSocket();
        sender.setTimeToLive(this.getTimeToLive());
        InetAddress bindTo = this.getBindAddress();
        InetSocketAddress bindSocketAddress = bindTo == null ? new InetSocketAddress(this.groupPort) : new InetSocketAddress(bindTo, this.groupPort);
        MulticastSocket receiver = new MulticastSocket(bindSocketAddress);
        if (this.groupAddress == null) {
            this.groupAddress = InetAddress.getByName("239.255.0.1");
        }
        receiver.joinGroup(this.groupAddress);
        this.active = true;
        this.senderThread = new Thread((Runnable)new MulticastSender(sender), "Oort-Multicast-Sender-" + ids.incrementAndGet());
        this.senderThread.setDaemon(true);
        this.senderThread.start();
        this.receiverThread = new Thread((Runnable)new MulticastReceiver(receiver), "Oort-Multicast-Receiver-" + ids.incrementAndGet());
        this.receiverThread.setDaemon(true);
        this.receiverThread.start();
    }

    protected void doStop() throws Exception {
        this.active = false;
        this.senderThread.interrupt();
    }

    public boolean join(long timeout) {
        try {
            this.senderThread.join(timeout);
            this.receiverThread.join(timeout);
            return true;
        }
        catch (InterruptedException x) {
            return false;
        }
    }

    protected void receive(String cometURL) {
        if (!this.oort.getKnownComets().contains(cometURL)) {
            this.logger.debug("Received comet URL via multicast: {}", (Object)cometURL);
            OortComet oortComet = this.oort.observeComet(cometURL);
            if (oortComet != null) {
                boolean elapsed;
                boolean bl = elapsed = !oortComet.waitFor(this.getConnectTimeout(), BayeuxClient.State.CONNECTED, new BayeuxClient.State[]{BayeuxClient.State.DISCONNECTED});
                if (elapsed) {
                    this.logger.debug("Interrupting attempts to connect to {}", (Object)cometURL);
                    this.oort.deobserveComet(cometURL);
                }
            }
        }
    }

    private class MulticastSender
    implements Runnable {
        private final MulticastSocket socket;

        public MulticastSender(MulticastSocket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OortMulticastConfigurer.this.logger.debug("Entering multicast sender thread");
            try {
                String cometURL = OortMulticastConfigurer.this.oort.getURL();
                byte[] cometURLBytes = cometURL.getBytes("UTF-8");
                if (cometURLBytes.length > OortMulticastConfigurer.this.getMaxTransmissionLength()) {
                    OortMulticastConfigurer.this.logger.warn("Oort URL {} exceeds max transmission unit and will not be advertised", (Object)cometURL);
                    return;
                }
                while (OortMulticastConfigurer.this.active) {
                    DatagramPacket packet = new DatagramPacket(cometURLBytes, 0, cometURLBytes.length, OortMulticastConfigurer.this.getGroupAddress(), OortMulticastConfigurer.this.getGroupPort());
                    this.socket.send(packet);
                    Thread.sleep(OortMulticastConfigurer.this.getAdvertiseInterval());
                }
            }
            catch (IOException x) {
                OortMulticastConfigurer.this.logger.warn("Unexpected exception", (Throwable)x);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                OortMulticastConfigurer.this.logger.debug("Exiting multicast sender thread");
                this.socket.close();
            }
        }
    }

    private class MulticastReceiver
    implements Runnable {
        private final MulticastSocket socket;

        public MulticastReceiver(MulticastSocket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OortMulticastConfigurer.this.logger.debug("Entering multicast receiver thread on {}", (Object)this.socket.getLocalSocketAddress());
            try {
                this.socket.setSoTimeout((int)(2L * OortMulticastConfigurer.this.advertiseInterval));
                byte[] buffer = new byte[OortMulticastConfigurer.this.getMaxTransmissionLength()];
                String url = null;
                while (OortMulticastConfigurer.this.active) {
                    if (url != null) {
                        OortMulticastConfigurer.this.receive(url);
                    }
                    url = this.receive(buffer);
                    if (!OortMulticastConfigurer.this.oort.getURL().equals(url)) continue;
                    url = null;
                }
            }
            catch (IOException x) {
                OortMulticastConfigurer.this.logger.warn("Unexpected exception", (Throwable)x);
            }
            finally {
                OortMulticastConfigurer.this.logger.debug("Exiting multicast receiver thread");
                this.socket.close();
            }
        }

        private String receive(byte[] buffer) throws IOException {
            try {
                DatagramPacket packet = new DatagramPacket(buffer, 0, buffer.length);
                this.socket.receive(packet);
                return new String(buffer, packet.getOffset(), packet.getLength(), "UTF-8");
            }
            catch (SocketTimeoutException x) {
                return null;
            }
        }
    }
}

