/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.client.ext.AckExtension;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.LongPollingTransport;
import org.cometd.common.JSONContext;
import org.cometd.oort.OortComet;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.cometd.server.ext.AcknowledgedMessagesExtension;
import org.cometd.websocket.client.WebSocketTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="CometD cloud node")
public class Oort
extends ContainerLifeCycle {
    public static final String OORT_ATTRIBUTE = Oort.class.getName();
    public static final String EXT_OORT_FIELD = "org.cometd.oort";
    public static final String EXT_OORT_URL_FIELD = "oortURL";
    public static final String EXT_OORT_ID_FIELD = "oortId";
    public static final String EXT_OORT_SECRET_FIELD = "oortSecret";
    public static final String EXT_COMET_URL_FIELD = "cometURL";
    public static final String EXT_OORT_ALIAS_URL_FIELD = "oortAliasURL";
    public static final String OORT_CLOUD_CHANNEL = "/oort/cloud";
    public static final String OORT_SERVICE_CHANNEL = "/service/oort";
    private static final String COMET_URL_ATTRIBUTE = "org.cometd.oort.cometURL";
    private final ConcurrentMap<String, OortComet> _pendingComets = new ConcurrentHashMap<String, OortComet>();
    private final ConcurrentMap<String, ClientCometInfo> _clientComets = new ConcurrentHashMap<String, ClientCometInfo>();
    private final ConcurrentMap<String, ServerCometInfo> _serverComets = new ConcurrentHashMap<String, ServerCometInfo>();
    private final ConcurrentMap<String, Boolean> _channels = new ConcurrentHashMap<String, Boolean>();
    private final CopyOnWriteArrayList<CometListener> _cometListeners = new CopyOnWriteArrayList();
    private final BayeuxServer.Extension _oortExtension = new OortExtension();
    private final ServerChannel.MessageListener _cloudListener = new CloudListener();
    private final ServerChannel.MessageListener _joinListener = new JoinListener();
    private final List<ClientTransport.Factory> _transportFactories = new ArrayList<ClientTransport.Factory>();
    private final BayeuxServer _bayeux;
    private final String _url;
    private final String _id;
    private final Logger _logger;
    private final LocalSession _oortSession;
    private ScheduledExecutorService _scheduler;
    private String _secret;
    private boolean _ackExtensionEnabled;
    private BayeuxServer.Extension _ackExtension;
    private JSONContext.Client _jsonContext;

    public Oort(BayeuxServer bayeux, String url) {
        this._bayeux = bayeux;
        this._url = url;
        this._id = UUID.randomUUID().toString();
        this._logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + Oort.replacePunctuation(this._url, '_')));
        this._oortSession = bayeux.newLocalSession("oort");
        this._secret = Long.toHexString(new SecureRandom().nextLong());
    }

    protected void doStart() throws Exception {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
        scheduler.setRemoveOnCancelPolicy(true);
        this._scheduler = scheduler;
        if (this._transportFactories.isEmpty()) {
            this._transportFactories.add((ClientTransport.Factory)new WebSocketTransport.Factory());
            this._transportFactories.add((ClientTransport.Factory)new LongPollingTransport.Factory(new HttpClient()));
        }
        for (ClientTransport.Factory factory : this._transportFactories) {
            this.addBean(factory);
        }
        super.doStart();
        if (this.isAckExtensionEnabled()) {
            boolean present = false;
            for (BayeuxServer.Extension extension : this._bayeux.getExtensions()) {
                if (!(extension instanceof AcknowledgedMessagesExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                this._ackExtension = new AcknowledgedMessagesExtension();
                this._bayeux.addExtension(this._ackExtension);
            }
        }
        this._bayeux.addExtension(this._oortExtension);
        ServerChannel oortCloudChannel = (ServerChannel)this._bayeux.createChannelIfAbsent(OORT_CLOUD_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference();
        oortCloudChannel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
        oortCloudChannel.addListener((ConfigurableServerChannel.ServerChannelListener)this._cloudListener);
        ServerChannel serverChannel = (ServerChannel)this._bayeux.createChannelIfAbsent(OORT_SERVICE_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference();
        serverChannel.addListener((ConfigurableServerChannel.ServerChannelListener)this._joinListener);
        this._oortSession.handshake();
    }

    protected void doStop() throws Exception {
        this._oortSession.disconnect();
        for (OortComet comet : this._pendingComets.values()) {
            comet.disconnect(1000L);
        }
        this._pendingComets.clear();
        for (ClientCometInfo cometInfo : this._clientComets.values()) {
            cometInfo.comet.disconnect(1000L);
        }
        this._clientComets.clear();
        this._serverComets.clear();
        this._channels.clear();
        ServerChannel channel = this._bayeux.getChannel(OORT_SERVICE_CHANNEL);
        if (channel != null) {
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this._joinListener);
        }
        if ((channel = this._bayeux.getChannel(OORT_CLOUD_CHANNEL)) != null) {
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this._cloudListener);
            channel.removeAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
        }
        BayeuxServer.Extension ackExtension = this._ackExtension;
        this._ackExtension = null;
        if (ackExtension != null) {
            this._bayeux.removeExtension(ackExtension);
        }
        this._bayeux.removeExtension(this._oortExtension);
        this._scheduler.shutdownNow();
        super.doStop();
    }

    @ManagedAttribute(value="The BayeuxServer of this Oort", readonly=true)
    public BayeuxServer getBayeuxServer() {
        return this._bayeux;
    }

    @ManagedAttribute(value="The URL of this Oort", readonly=true)
    public String getURL() {
        return this._url;
    }

    @ManagedAttribute(value="The unique ID of this Oort", readonly=true)
    public String getId() {
        return this._id;
    }

    @ManagedAttribute(value="The secret of this Oort")
    public String getSecret() {
        return this._secret;
    }

    public void setSecret(String secret) {
        this._secret = secret;
    }

    @ManagedAttribute(value="Whether the acknowledgement extension is enabled")
    public boolean isAckExtensionEnabled() {
        return this._ackExtensionEnabled;
    }

    public void setAckExtensionEnabled(boolean value) {
        this._ackExtensionEnabled = value;
    }

    public JSONContext.Client getJSONContextClient() {
        return this._jsonContext;
    }

    public void setJSONContextClient(JSONContext.Client jsonContext) {
        this._jsonContext = jsonContext;
    }

    public List<ClientTransport.Factory> getClientTransportFactories() {
        return this._transportFactories;
    }

    public OortComet observeComet(String cometURL) {
        return this.observeComet(cometURL, null);
    }

    protected OortComet observeComet(String cometURL, String oortAliasURL) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Observing comet {}", (Object)cometURL);
        }
        try {
            URI uri = new URI(cometURL);
            if (uri.getScheme() == null) {
                throw new IllegalArgumentException("Missing protocol in comet URL " + cometURL);
            }
            if (uri.getHost() == null) {
                throw new IllegalArgumentException("Missing host in comet URL " + cometURL);
            }
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x);
        }
        if (this._url.equals(cometURL)) {
            return null;
        }
        OortComet comet = this.getComet(cometURL);
        if (comet != null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Comet {} is already connected", (Object)cometURL);
            }
            return comet;
        }
        comet = this.newOortComet(cometURL);
        this.configureOortComet(comet);
        OortComet existing = this._pendingComets.putIfAbsent(cometURL, comet);
        if (existing != null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Comet {} is already connecting", (Object)cometURL);
            }
            return existing;
        }
        comet.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)new HandshakeListener(cometURL, comet));
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Connecting to comet {}", (Object)cometURL);
        }
        Map<String, Object> fields = this.newOortHandshakeFields(cometURL, oortAliasURL);
        this.connectComet(comet, fields);
        return comet;
    }

    protected OortComet newOortComet(String cometURL) {
        String idleTimeoutOption;
        String maxMessageSizeOption;
        Object option;
        HashMap<String, Object> options = new HashMap<String, Object>(2);
        options.put("scheduler", this._scheduler);
        JSONContext.Client jsonContext = this.getJSONContextClient();
        if (jsonContext != null) {
            options.put("jsonContext", jsonContext);
        }
        if ((option = this._bayeux.getOption(maxMessageSizeOption = "ws.maxMessageSize")) != null) {
            options.put(maxMessageSizeOption, option);
        }
        if ((option = this._bayeux.getOption(idleTimeoutOption = "ws.idleTimeout")) != null) {
            options.put(idleTimeoutOption, option);
        }
        ArrayList<ClientTransport> transports = new ArrayList<ClientTransport>();
        for (ClientTransport.Factory factory : this.getClientTransportFactories()) {
            transports.add(factory.newClientTransport(cometURL, options));
        }
        ClientTransport transport = (ClientTransport)transports.get(0);
        int size = transports.size();
        ClientTransport[] otherTransports = transports.subList(1, size).toArray(new ClientTransport[size - 1]);
        return new OortComet(this, cometURL, this._scheduler, transport, otherTransports);
    }

    protected void configureOortComet(OortComet oortComet) {
        if (this.isAckExtensionEnabled()) {
            boolean present = false;
            for (ClientSession.Extension extension : oortComet.getExtensions()) {
                if (!(extension instanceof AckExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                oortComet.addExtension((ClientSession.Extension)new AckExtension());
            }
        }
    }

    protected String encodeSecret(String secret) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            return new String(B64Code.encode((byte[])digest.digest(secret.getBytes("UTF-8"))));
        }
        catch (Exception x) {
            throw new IllegalArgumentException(x);
        }
    }

    protected void connectComet(OortComet comet, Map<String, Object> fields) {
        comet.handshake(fields);
    }

    public OortComet deobserveComet(String cometURL) {
        if (this._url.equals(cometURL)) {
            return null;
        }
        OortComet comet = (OortComet)((Object)this._pendingComets.remove(cometURL));
        if (comet != null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Disconnecting pending comet {}", (Object)cometURL);
            }
            comet.disconnect();
        }
        Iterator cometInfos = this._clientComets.values().iterator();
        while (cometInfos.hasNext()) {
            ClientCometInfo cometInfo = (ClientCometInfo)cometInfos.next();
            if (!cometInfo.matchesURL(cometURL)) continue;
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Disconnecting comet {}", (Object)cometURL);
            }
            comet = cometInfo.getOortComet();
            comet.disconnect();
            cometInfos.remove();
            break;
        }
        return comet;
    }

    @ManagedAttribute(value="URLs of known Oorts in the cluster", readonly=true)
    public Set<String> getKnownComets() {
        HashSet<String> result = new HashSet<String>();
        for (ClientCometInfo cometInfo : this._clientComets.values()) {
            result.add(cometInfo.getOortURL());
        }
        return result;
    }

    public OortComet getComet(String cometURL) {
        for (ClientCometInfo cometInfo : this._clientComets.values()) {
            if (!cometInfo.matchesURL(cometURL)) continue;
            return cometInfo.getOortComet();
        }
        return null;
    }

    protected OortComet findComet(String cometURL) {
        OortComet result = (OortComet)((Object)this._pendingComets.get(cometURL));
        if (result == null) {
            result = this.getComet(cometURL);
        }
        return result;
    }

    @ManagedOperation(value="Observes the given channel", impact="ACTION")
    public void observeChannel(@Name(value="channel", description="The channel to observe") String channelName) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Observing channel {}", (Object)channelName);
        }
        if (!ChannelId.isBroadcast((String)channelName)) {
            throw new IllegalArgumentException("Channel " + channelName + " cannot be observed because is not a broadcast channel");
        }
        if (this._channels.putIfAbsent(channelName, Boolean.TRUE) == null) {
            Set<String> observedChannels = this.getObservedChannels();
            for (ClientCometInfo cometInfo : this._clientComets.values()) {
                cometInfo.getOortComet().subscribe(observedChannels);
            }
        }
    }

    @ManagedOperation(value="Deobserves the given channel", impact="ACTION")
    public void deobserveChannel(@Name(value="channel", description="The channel to deobserve") String channelId) {
        if (this._channels.remove(channelId) != null) {
            for (ClientCometInfo cometInfo : this._clientComets.values()) {
                cometInfo.getOortComet().unsubscribe(channelId);
            }
        }
    }

    public boolean isOort(ServerSession session) {
        String id = session.getId();
        if (id.equals(this._oortSession.getId())) {
            return true;
        }
        for (ServerCometInfo cometInfo : this._serverComets.values()) {
            if (!cometInfo.getServerSession().getId().equals(session.getId())) continue;
            return true;
        }
        return session.getAttribute(COMET_URL_ATTRIBUTE) != null;
    }

    public boolean isOortHandshake(Message handshake) {
        if (!"/meta/handshake".equals(handshake.getChannel())) {
            return false;
        }
        Map ext = handshake.getExt();
        if (ext == null) {
            return false;
        }
        Object oortExtObject = ext.get(EXT_OORT_FIELD);
        if (!(oortExtObject instanceof Map)) {
            return false;
        }
        Map oortExt = (Map)oortExtObject;
        String cometURL = (String)oortExt.get(EXT_COMET_URL_FIELD);
        if (!this.getURL().equals(cometURL)) {
            return false;
        }
        String b64RemoteSecret = (String)oortExt.get(EXT_OORT_SECRET_FIELD);
        String b64LocalSecret = this.encodeSecret(this.getSecret());
        return b64LocalSecret.equals(b64RemoteSecret);
    }

    protected Map<String, Object> newOortHandshakeFields(String cometURL, String oortAliasURL) {
        HashMap<String, Object> fields = new HashMap<String, Object>(1);
        HashMap ext = new HashMap(1);
        fields.put("ext", ext);
        HashMap<String, String> oortExt = new HashMap<String, String>(4);
        ext.put(EXT_OORT_FIELD, oortExt);
        oortExt.put(EXT_OORT_URL_FIELD, this.getURL());
        oortExt.put(EXT_OORT_ID_FIELD, this.getId());
        String b64Secret = this.encodeSecret(this.getSecret());
        oortExt.put(EXT_OORT_SECRET_FIELD, b64Secret);
        oortExt.put(EXT_COMET_URL_FIELD, cometURL);
        if (oortAliasURL != null) {
            oortExt.put(EXT_OORT_ALIAS_URL_FIELD, oortAliasURL);
        }
        return fields;
    }

    protected boolean isCometConnected(String oortURL) {
        for (ServerCometInfo serverCometInfo : this._serverComets.values()) {
            if (!serverCometInfo.getOortURL().equals(oortURL)) continue;
            return true;
        }
        return false;
    }

    protected boolean incomingCometHandshake(Map<String, Object> oortExt, ServerSession session) {
        ServerCometInfo serverCometInfo;
        String remoteOortId;
        ServerCometInfo existing;
        String remoteOortURL = (String)oortExt.get(EXT_OORT_URL_FIELD);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Incoming comet handshake from comet {} with {}", (Object)remoteOortURL, (Object)session);
        }
        if ((existing = this._serverComets.putIfAbsent(remoteOortId = (String)oortExt.get(EXT_OORT_ID_FIELD), serverCometInfo = new ServerCometInfo(remoteOortId, remoteOortURL, session))) != null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Comet {} is already known with {}", (Object)remoteOortURL, (Object)existing.getServerSession());
            }
            return false;
        }
        session.addListener((ServerSession.ServerSessionListener)new OortCometDisconnectListener());
        session.addListener((ServerSession.ServerSessionListener)new OortCometLoopListener());
        return true;
    }

    public void addCometListener(CometListener listener) {
        this._cometListeners.add(listener);
    }

    public void removeCometListener(CometListener listener) {
        this._cometListeners.remove(listener);
    }

    private void notifyCometJoined(String remoteOortId, String remoteOortURL) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Comet joined: {}|{}", (Object)remoteOortId, (Object)remoteOortURL);
        }
        CometListener.Event event = new CometListener.Event(this, remoteOortId, remoteOortURL);
        for (CometListener cometListener : this._cometListeners) {
            try {
                cometListener.cometJoined(event);
            }
            catch (Throwable x) {
                this._logger.info("Exception while invoking listener " + cometListener, x);
            }
        }
    }

    private void notifyCometLeft(String remoteOortId, String remoteOortURL) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Comet left: {}|{}", (Object)remoteOortId, (Object)remoteOortURL);
        }
        CometListener.Event event = new CometListener.Event(this, remoteOortId, remoteOortURL);
        for (CometListener cometListener : this._cometListeners) {
            try {
                cometListener.cometLeft(event);
            }
            catch (Throwable x) {
                this._logger.info("Exception while invoking listener " + cometListener, x);
            }
        }
    }

    protected void joinComets(Message message) {
        Object[] array;
        Object data = message.getData();
        for (Object element : array = data instanceof List ? ((List)data).toArray() : (Object[])data) {
            this.observeComet((String)element);
        }
    }

    public Set<String> getObservedChannels() {
        return new HashSet<String>(this._channels.keySet());
    }

    public LocalSession getOortSession() {
        return this._oortSession;
    }

    protected static String replacePunctuation(String source, char replacement) {
        String replaced = source.replaceAll("[^\\p{Alnum}]", String.valueOf(replacement));
        return replaced.replaceAll("(" + replacement + ")\\1+", "$1");
    }

    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(new Dumpable(){

            public String dump() {
                return null;
            }

            public void dump(Appendable out, String indent) throws IOException {
                Set<String> knownComets = Oort.this.getKnownComets();
                ContainerLifeCycle.dumpObject((Appendable)out, (Object)("connected comets: " + knownComets.size()));
                ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{knownComets});
            }
        });
        children.add(new Dumpable(){

            public String dump() {
                return null;
            }

            public void dump(Appendable out, String indent) throws IOException {
                Set<String> observedChannels = Oort.this.getObservedChannels();
                ContainerLifeCycle.dumpObject((Appendable)out, (Object)("observed channels: " + observedChannels.size()));
                ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{observedChannels});
            }
        });
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{children});
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.getURL());
    }

    protected static class ClientCometInfo
    extends CometInfo {
        private final OortComet comet;
        private final Map<String, Boolean> urls = new ConcurrentHashMap<String, Boolean>();

        protected ClientCometInfo(String oortId, String oortURL, OortComet comet) {
            super(oortId, oortURL);
            this.comet = comet;
        }

        public OortComet getOortComet() {
            return this.comet;
        }

        public void addAliasURL(String url) {
            this.urls.put(url, Boolean.TRUE);
        }

        public boolean matchesURL(String url) {
            return this.getOortURL().equals(url) || this.urls.containsKey(url);
        }
    }

    protected static class ServerCometInfo
    extends CometInfo {
        private final ServerSession session;

        protected ServerCometInfo(String oortId, String oortURL, ServerSession session) {
            super(oortId, oortURL);
            this.session = session;
        }

        public ServerSession getServerSession() {
            return this.session;
        }
    }

    protected static abstract class CometInfo {
        private final String oortId;
        private final String oortURL;

        protected CometInfo(String oortId, String oortURL) {
            this.oortId = oortId;
            this.oortURL = oortURL;
        }

        public String getOortId() {
            return this.oortId;
        }

        public String getOortURL() {
            return this.oortURL;
        }
    }

    private class HandshakeListener
    implements ClientSessionChannel.MessageListener {
        private final String cometURL;
        private final OortComet oortComet;

        private HandshakeListener(String cometURL, OortComet oortComet) {
            this.cometURL = cometURL;
            this.oortComet = oortComet;
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            Object oortExtObject;
            Map ext;
            OortComet comet = (OortComet)((Object)Oort.this._pendingComets.get(this.cometURL));
            if (comet != null && !message.isSuccessful()) {
                Oort.this._logger.warn("Failed to connect to comet {}, message {}", (Object)this.cometURL, (Object)message);
                Map advice = message.getAdvice();
                if (advice != null && "none".equals(advice.get("reconnect"))) {
                    if (Oort.this._logger.isDebugEnabled()) {
                        Oort.this._logger.debug("Disconnecting pending comet {}", (Object)this.cometURL);
                    }
                    comet.disconnect();
                }
            }
            if ((ext = message.getExt()) != null && (oortExtObject = ext.get(Oort.EXT_OORT_FIELD)) instanceof Map) {
                Map oortExt = (Map)oortExtObject;
                String url = (String)oortExt.get(Oort.EXT_OORT_URL_FIELD);
                String id = (String)oortExt.get(Oort.EXT_OORT_ID_FIELD);
                ClientCometInfo cometInfo = new ClientCometInfo(id, url, this.oortComet);
                ClientCometInfo existing = Oort.this._clientComets.putIfAbsent(id, cometInfo);
                if (existing != null) {
                    cometInfo = existing;
                }
                if (!this.cometURL.equals(url)) {
                    cometInfo.addAliasURL(this.cometURL);
                    if (Oort.this._logger.isDebugEnabled()) {
                        Oort.this._logger.debug("Adding alias to {}: {}", (Object)url, (Object)this.cometURL);
                    }
                }
                if (message.isSuccessful() && Oort.this._logger.isDebugEnabled()) {
                    Oort.this._logger.debug("Connected to comet {} as {} with {}/{}", new Object[]{url, this.cometURL, message.getClientId(), this.oortComet.getTransport()});
                }
            }
            if (message.isSuccessful() || comet != null && comet.isDisconnected()) {
                Oort.this._pendingComets.remove(this.cometURL);
            }
        }
    }

    private class OortCometLoopListener
    implements ServerSession.MessageListener {
        private OortCometLoopListener() {
        }

        public boolean onMessage(ServerSession session, ServerSession sender, ServerMessage message) {
            if (session.getId().equals(sender.getId()) || Oort.this.isOort(sender)) {
                if (Oort.this._logger.isDebugEnabled()) {
                    Oort.this._logger.debug("{} --| {} {}", new Object[]{sender, session, message});
                }
                return false;
            }
            if (Oort.this._logger.isDebugEnabled()) {
                Oort.this._logger.debug("{} --> {} {}", new Object[]{sender, session, message});
            }
            return true;
        }
    }

    private class OortCometDisconnectListener
    implements ServerSession.RemoveListener {
        private OortCometDisconnectListener() {
        }

        public void removed(ServerSession session, boolean timeout) {
            Iterator cometInfos = Oort.this._serverComets.values().iterator();
            while (cometInfos.hasNext()) {
                ClientCometInfo clientCometInfo;
                ServerCometInfo serverCometInfo = (ServerCometInfo)cometInfos.next();
                if (!serverCometInfo.getServerSession().getId().equals(session.getId())) continue;
                String remoteOortId = serverCometInfo.getOortId();
                String remoteOortURL = serverCometInfo.getOortURL();
                if (Oort.this._logger.isDebugEnabled()) {
                    Oort.this._logger.debug("Disconnected from comet {} with server session {}", (Object)remoteOortURL, (Object)session);
                }
                cometInfos.remove();
                if (!timeout && (clientCometInfo = (ClientCometInfo)Oort.this._clientComets.remove(remoteOortId)) != null) {
                    OortComet oortComet = clientCometInfo.getOortComet();
                    if (Oort.this._logger.isDebugEnabled()) {
                        Oort.this._logger.debug("Disconnecting from comet {} with client session {}", (Object)remoteOortURL, (Object)oortComet);
                    }
                    oortComet.disconnect();
                }
                if (!Oort.this.isRunning()) break;
                Oort.this.notifyCometLeft(remoteOortId, remoteOortURL);
                break;
            }
        }
    }

    public static interface CometListener
    extends EventListener {
        public void cometJoined(Event var1);

        public void cometLeft(Event var1);

        public static class Event
        extends EventObject {
            private final String cometId;
            private final String cometURL;

            public Event(Oort source, String cometId, String cometURL) {
                super((Object)source);
                this.cometId = cometId;
                this.cometURL = cometURL;
            }

            public Oort getOort() {
                return (Oort)((Object)this.getSource());
            }

            public String getCometId() {
                return this.cometId;
            }

            public String getCometURL() {
                return this.cometURL;
            }
        }

        public static class Adapter
        implements CometListener {
            @Override
            public void cometJoined(Event event) {
            }

            @Override
            public void cometLeft(Event event) {
            }
        }
    }

    protected class JoinListener
    implements ServerChannel.MessageListener {
        protected JoinListener() {
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            Map data = message.getDataAsMap();
            String remoteOortId = (String)data.get(Oort.EXT_OORT_ID_FIELD);
            String remoteOortURL = (String)data.get(Oort.EXT_OORT_URL_FIELD);
            if (remoteOortURL != null) {
                if (remoteOortId != null) {
                    Iterator iterator = Oort.this._serverComets.values().iterator();
                    while (iterator.hasNext()) {
                        String oortId;
                        ServerCometInfo serverCometInfo = (ServerCometInfo)iterator.next();
                        if (!remoteOortURL.equals(serverCometInfo.getOortURL()) || remoteOortId.equals(oortId = serverCometInfo.getOortId())) continue;
                        iterator.remove();
                        Oort.this.notifyCometLeft(oortId, remoteOortURL);
                    }
                }
                Oort.this.notifyCometJoined(remoteOortId, remoteOortURL);
            }
            return true;
        }
    }

    protected class CloudListener
    implements ServerChannel.MessageListener {
        protected CloudListener() {
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (!from.isLocalSession()) {
                Oort.this.joinComets((Message)message);
            }
            return true;
        }
    }

    protected class OortExtension
    extends BayeuxServer.Extension.Adapter {
        protected OortExtension() {
        }

        public boolean sendMeta(ServerSession session, ServerMessage.Mutable message) {
            if (session == null) {
                return true;
            }
            if (!"/meta/handshake".equals(message.getChannel())) {
                return true;
            }
            if (!message.isSuccessful()) {
                return true;
            }
            Map associatedExt = message.getAssociated().getExt();
            if (associatedExt == null) {
                return true;
            }
            Object associatedOortExtObject = associatedExt.get(Oort.EXT_OORT_FIELD);
            if (associatedOortExtObject instanceof Map) {
                Map associatedOortExt = (Map)associatedOortExtObject;
                String remoteOortURL = (String)associatedOortExt.get(Oort.EXT_OORT_URL_FIELD);
                String cometURL = (String)associatedOortExt.get(Oort.EXT_COMET_URL_FIELD);
                String remoteOortId = (String)associatedOortExt.get(Oort.EXT_OORT_ID_FIELD);
                session.setAttribute(Oort.COMET_URL_ATTRIBUTE, (Object)remoteOortURL);
                if (Oort.this._id.equals(remoteOortId)) {
                    if (Oort.this._logger.isDebugEnabled()) {
                        Oort.this._logger.debug("Detected self connect from {} to {}, disconnecting", (Object)remoteOortURL, (Object)cometURL);
                    }
                    this.disconnect(session, message);
                } else {
                    Map ext = message.getExt(true);
                    HashMap<String, String> oortExt = new HashMap<String, String>(2);
                    ext.put(Oort.EXT_OORT_FIELD, oortExt);
                    oortExt.put(Oort.EXT_OORT_URL_FIELD, Oort.this.getURL());
                    oortExt.put(Oort.EXT_OORT_ID_FIELD, Oort.this.getId());
                    boolean connectBack = Oort.this.incomingCometHandshake(Collections.unmodifiableMap(associatedOortExt), session);
                    if (connectBack) {
                        String cometAliasURL = (String)associatedOortExt.get(Oort.EXT_OORT_ALIAS_URL_FIELD);
                        if (cometAliasURL != null && Oort.this.findComet(cometAliasURL) != null) {
                            if (Oort.this._logger.isDebugEnabled()) {
                                Oort.this._logger.debug("Comet {} exists with alias {}, avoiding to establish connection", (Object)remoteOortURL, (Object)cometAliasURL);
                            }
                        } else {
                            if (Oort.this._logger.isDebugEnabled()) {
                                Oort.this._logger.debug("Comet {} is unknown, establishing connection", (Object)remoteOortURL);
                            }
                            Oort.this.observeComet(remoteOortURL, cometURL);
                        }
                    } else {
                        this.disconnect(session, message);
                    }
                }
            }
            return true;
        }

        private void disconnect(ServerSession session, ServerMessage.Mutable message) {
            Oort.this._bayeux.removeSession(session);
            message.setSuccessful(false);
            Map advice = message.getAdvice(true);
            advice.put("reconnect", "none");
        }
    }
}

