/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.oort.OortComet;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="CometD cloud peer discovery component")
public class Seti
extends AbstractLifeCycle
implements Dumpable {
    public static final String SETI_ATTRIBUTE = Seti.class.getName();
    private static final String SETI_ALL_CHANNEL = "/seti/all";
    private final Map<String, Set<Location>> _uid2Location = new HashMap<String, Set<Location>>();
    private final List<PresenceListener> _presenceListeners = new CopyOnWriteArrayList<PresenceListener>();
    private final Oort.CometListener _cometListener = new CometListener();
    private final Oort _oort;
    private final String _setiId;
    private final Logger _logger;
    private final LocalSession _session;

    public Seti(Oort oort) {
        this._oort = oort;
        this._setiId = this.generateSetiId(oort.getURL());
        this._logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + this._setiId));
        this._session = oort.getBayeuxServer().newLocalSession(this._setiId);
    }

    @ManagedAttribute(value="The Oort of this Seti", readonly=true)
    public Oort getOort() {
        return this._oort;
    }

    @ManagedAttribute(value="The unique ID of this Seti", readonly=true)
    public String getId() {
        return this._setiId;
    }

    protected void doStart() throws Exception {
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        this._session.handshake();
        ((ServerChannel)bayeux.createChannelIfAbsent(SETI_ALL_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference()).setPersistent(true);
        this._oort.observeChannel(SETI_ALL_CHANNEL);
        this._session.getChannel(SETI_ALL_CHANNEL).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receiveBroadcast(message);
            }
        });
        String setiChannel = this.generateSetiChannel(this._setiId);
        ((ServerChannel)bayeux.createChannelIfAbsent(setiChannel, new ConfigurableServerChannel.Initializer[0]).getReference()).setPersistent(true);
        this._session.getChannel(setiChannel).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receiveDirect(message);
            }
        });
        this._oort.observeChannel(setiChannel);
        this._oort.addCometListener(this._cometListener);
        Set<String> associatedUserIds = this.getAssociatedUserIds();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Broadcasting associated users {}", associatedUserIds);
        }
        SetiPresence presence = new SetiPresence(true, associatedUserIds);
        presence.put("alive", true);
        this._session.getChannel(SETI_ALL_CHANNEL).publish((Object)presence);
    }

    protected void doStop() throws Exception {
        this.removeAssociationsAndPresences();
        this._presenceListeners.clear();
        this._session.disconnect();
        this._oort.removeCometListener(this._cometListener);
        String setiChannel = this.generateSetiChannel(this._setiId);
        this._oort.deobserveChannel(setiChannel);
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        ServerChannel channel = bayeux.getChannel(setiChannel);
        if (channel != null) {
            channel.setPersistent(false);
        }
        this._oort.deobserveChannel(SETI_ALL_CHANNEL);
        channel = bayeux.getChannel(SETI_ALL_CHANNEL);
        if (channel != null) {
            channel.setPersistent(false);
        }
    }

    protected String generateSetiId(String oortURL) {
        return Oort.replacePunctuation(oortURL, '_');
    }

    protected String generateSetiChannel(String setiId) {
        return "/seti/" + setiId;
    }

    public boolean associate(String userId, ServerSession session) {
        if (session == null) {
            throw new NullPointerException();
        }
        LocalLocation location = new LocalLocation(userId, session);
        boolean wasAssociated = this.isAssociated(userId);
        boolean added = this.associate(userId, location);
        if (added) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Associated session {} to user {}", (Object)session, (Object)userId);
            }
            session.addListener((ServerSession.ServerSessionListener)location);
            session.setAttribute(LocalLocation.class.getName(), (Object)location);
            if (!wasAssociated) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Broadcasting association addition for user {}", (Object)userId);
                }
                this._session.getChannel(SETI_ALL_CHANNEL).publish((Object)new SetiPresence(true, userId));
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean associate(String userId, Location location) {
        if (!this.isRunning()) {
            return false;
        }
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                locations = new HashSet<Location>();
                this._uid2Location.put(userId, locations);
            }
            boolean result = locations.add(location);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Associations: {}", (Object)this._uid2Location.size());
            }
            if (this._logger.isTraceEnabled()) {
                this._logger.trace("Associations: {}", this._uid2Location);
            }
            return result;
        }
    }

    private boolean associateRemote(String userId, SetiLocation location) {
        boolean associated = this.associate(userId, location);
        String oortURL = location._oortURL;
        if (associated && !this._oort.isCometConnected(oortURL)) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Disassociating {} since comet {} just disconnected", (Object)userId, (Object)oortURL);
            }
            this.disassociate(userId, location);
            return false;
        }
        return associated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="Whether the given userId is associated locally", impact="INFO")
    public boolean isAssociated(@Name(value="userId", description="The userId to test for local association") String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                return false;
            }
            for (Location location : locations) {
                if (!(location instanceof LocalLocation)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="The number of local associations for the given userId", impact="INFO")
    public int getAssociationCount(@Name(value="userId", description="The userId to test for local association count") String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                return 0;
            }
            int result = 0;
            for (Location location : locations) {
                if (!(location instanceof LocalLocation)) continue;
                ++result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="Whether the given userId is present in the cloud", impact="INFO")
    public boolean isPresent(@Name(value="userId", description="The userId to test for presence in the cloud") String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            return locations != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="The number of local and remote associations for the given userId", impact="INFO")
    public int getPresenceCount(@Name(value="userId", description="The userId to test for presence count") String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            return locations == null ? 0 : locations.size();
        }
    }

    public boolean disassociate(String userId, ServerSession session) {
        LocalLocation location = new LocalLocation(userId, session);
        boolean removed = this.disassociate(userId, location);
        if (removed) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Disassociated session {} from user {}", (Object)session, (Object)userId);
            }
            location = (LocalLocation)session.removeAttribute(LocalLocation.class.getName());
            session.removeListener((ServerSession.ServerSessionListener)location);
            if (this._session.isConnected() && !this.isAssociated(userId)) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Broadcasting association removal for user {}", (Object)userId);
                }
                this._session.getChannel(SETI_ALL_CHANNEL).publish((Object)new SetiPresence(false, userId));
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean disassociate(String userId, Location location) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            boolean result = false;
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations != null) {
                result = locations.remove(location);
                if (locations.isEmpty()) {
                    this._uid2Location.remove(userId);
                }
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Associations: {}", (Object)this._uid2Location.size());
            }
            if (this._logger.isTraceEnabled()) {
                this._logger.trace("Associations: {}", this._uid2Location);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAssociationsAndPresences() {
        HashSet<String> userIds = new HashSet<String>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            this.getAssociatedUserIds(userIds);
            this._uid2Location.clear();
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Broadcasting association removal for users {}", userIds);
        }
        SetiPresence presence = new SetiPresence(false, userIds);
        presence.put("alive", false);
        this._session.getChannel(SETI_ALL_CHANNEL).publish((Object)presence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePresences(String oortURL) {
        ArrayList<String> userIds = new ArrayList<String>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Iterator<Map.Entry<String, Set<Location>>> entries = this._uid2Location.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, Set<Location>> entry = entries.next();
                Set<Location> userLocations = entry.getValue();
                Iterator<Location> iterator = userLocations.iterator();
                while (iterator.hasNext()) {
                    Location location = iterator.next();
                    if (!(location instanceof SetiLocation) || !oortURL.equals(((SetiLocation)location)._oortURL)) continue;
                    iterator.remove();
                    userIds.add(entry.getKey());
                    break;
                }
                if (!userLocations.isEmpty()) continue;
                entries.remove();
            }
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Removing presences of comet {} for users {}", (Object)oortURL, userIds);
        }
        for (String userId : userIds) {
            this.notifyPresenceRemoved(oortURL, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(value="The set of userIds known to this Seti", readonly=true)
    public Set<String> getUserIds() {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            return new HashSet<String>(this._uid2Location.keySet());
        }
    }

    public Set<String> getAssociatedUserIds() {
        HashSet<String> result = new HashSet<String>();
        this.getAssociatedUserIds(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAssociatedUserIds(Set<String> result) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            block3: for (Map.Entry<String, Set<Location>> entry : this._uid2Location.entrySet()) {
                for (Location location : entry.getValue()) {
                    if (!(location instanceof LocalLocation)) continue;
                    result.add(entry.getKey());
                    continue block3;
                }
            }
        }
    }

    public void sendMessage(String toUserId, String toChannel, Object data) {
        this.sendMessage(Collections.singleton(toUserId), toChannel, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Collection<String> toUserIds, String toChannel, Object data) {
        for (String toUserId : toUserIds) {
            HashSet<Location> copy = new HashSet<Location>();
            Map<String, Set<Location>> map = this._uid2Location;
            synchronized (map) {
                Set<Location> locations = this._uid2Location.get(toUserId);
                if (locations == null) {
                    copy.add(new SetiLocation(toUserId, null));
                } else {
                    copy.addAll(locations);
                }
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Sending message to locations {}", copy);
            }
            for (Location location : copy) {
                location.send(toUserId, toChannel, data);
            }
        }
    }

    protected void receiveDirect(Message message) {
        Map data;
        Boolean presence;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Received direct message {}", (Object)message);
        }
        if ((presence = (Boolean)(data = message.getDataAsMap()).get("presence")) != null) {
            this.receivePresence(data);
        } else {
            this.receiveMessage(data);
        }
    }

    protected void receiveBroadcast(Message message) {
        Map data;
        Boolean presence;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Received broadcast message {}", (Object)message);
        }
        if ((presence = (Boolean)(data = message.getDataAsMap()).get("presence")) != null) {
            this.receivePresence(data);
        } else {
            this.receiveMessage(data);
        }
    }

    protected void receivePresence(Map<String, Object> presence) {
        String oortURL;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Received presence message {}", presence);
        }
        if (this._setiId.equals(this.generateSetiId(oortURL = (String)presence.get("oortURL")))) {
            this.receiveLocalPresence(presence);
        } else {
            this.receiveRemotePresence(presence);
        }
    }

    private void receiveLocalPresence(Map<String, Object> presence) {
        String oortURL = (String)presence.get("oortURL");
        boolean present = (Boolean)presence.get("presence");
        Set<String> userIds = this.convertPresenceUsers(presence);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Notifying presence listeners {}", presence);
        }
        for (String userId : userIds) {
            if (present) {
                this.notifyPresenceAdded(oortURL, userId);
                continue;
            }
            this.notifyPresenceRemoved(oortURL, userId);
        }
    }

    private void receiveRemotePresence(Map<String, Object> presence) {
        OortComet oortComet;
        String oortURL = (String)presence.get("oortURL");
        boolean present = (Boolean)presence.get("presence");
        Set<String> userIds = this.convertPresenceUsers(presence);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Received remote presence message from comet {} for {}", (Object)oortURL, userIds);
        }
        for (String userId : userIds) {
            SetiLocation location = new SetiLocation(userId, oortURL);
            if (present) {
                if (!this.associateRemote(userId, location)) continue;
                this.notifyPresenceAdded(oortURL, userId);
                continue;
            }
            if (!this.disassociate(userId, location)) continue;
            this.notifyPresenceRemoved(oortURL, userId);
        }
        if (presence.get("alive") == Boolean.TRUE && (oortComet = this._oort.findComet(oortURL)) != null) {
            Set<String> associatedUserIds = this.getAssociatedUserIds();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Pushing associated users {} to comet {}", associatedUserIds, (Object)oortURL);
            }
            ClientSessionChannel channel = oortComet.getChannel(this.generateSetiChannel(this.generateSetiId(oortURL)));
            channel.publish((Object)new SetiPresence(true, associatedUserIds));
        }
    }

    public void addPresenceListener(PresenceListener listener) {
        this._presenceListeners.add(listener);
    }

    public void removePresenceListener(PresenceListener listener) {
        this._presenceListeners.remove(listener);
    }

    private void notifyPresenceAdded(String oortURL, String userId) {
        PresenceListener.Event event = new PresenceListener.Event(this, userId, oortURL);
        for (PresenceListener listener : this._presenceListeners) {
            try {
                listener.presenceAdded(event);
            }
            catch (Throwable x) {
                this._logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    private void notifyPresenceRemoved(String oortURL, String userId) {
        PresenceListener.Event event = new PresenceListener.Event(this, userId, oortURL);
        for (PresenceListener listener : this._presenceListeners) {
            try {
                listener.presenceRemoved(event);
            }
            catch (Throwable x) {
                this._logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveMessage(Map<String, Object> message) {
        String userId = (String)message.get("userId");
        String channel = (String)message.get("channel");
        Object data = message.get("data");
        HashSet<Location> copy = new HashSet<Location>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations != null) {
                for (Location location : locations) {
                    if (!(location instanceof LocalLocation)) continue;
                    copy.add(location);
                }
            }
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Received message {} for locations {}", message, copy);
        }
        for (Location location : copy) {
            location.receive(userId, channel, data);
        }
    }

    private Set<String> convertPresenceUsers(Map<String, Object> presence) {
        Object value = presence.get("userIds");
        if (value instanceof Set) {
            return (Set)value;
        }
        if (value instanceof Collection) {
            return new HashSet<String>((Collection)value);
        }
        if (value.getClass().isArray()) {
            HashSet<String> result = new HashSet<String>();
            for (Object item : (Object[])value) {
                result.add(item.toString());
            }
            return result;
        }
        throw new IllegalArgumentException();
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject((Appendable)out, (Object)((Object)this));
        ArrayList<3> children = new ArrayList<3>();
        children.add(new Dumpable(){

            public String dump() {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dump(Appendable out, String indent) throws IOException {
                ArrayList<String> state = new ArrayList<String>();
                Map map = Seti.this._uid2Location;
                synchronized (map) {
                    for (Map.Entry entry : Seti.this._uid2Location.entrySet()) {
                        state.add(String.format("%s @ %s", entry.getKey(), entry.getValue()));
                    }
                }
                ContainerLifeCycle.dumpObject((Appendable)out, (Object)("locations: " + state.size()));
                if (((BayeuxServerImpl)Seti.this.getOort().getBayeuxServer()).isDetailedDump()) {
                    ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{state});
                }
            }
        });
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{children});
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getName(), this.getId());
    }

    private class CometListener
    implements Oort.CometListener {
        private CometListener() {
        }

        @Override
        public void cometJoined(Oort.CometListener.Event event) {
            String oortURL = event.getCometURL();
            OortComet oortComet = Seti.this._oort.findComet(oortURL);
            if (Seti.this._logger.isDebugEnabled()) {
                Seti.this._logger.debug("Comet joined: {} with {}", (Object)oortURL, (Object)oortComet);
            }
            if (oortComet != null) {
                ClientSessionChannel channel = oortComet.getChannel(Seti.this.generateSetiChannel(Seti.this.generateSetiId(oortURL)));
                Set<String> userIds = Seti.this.getAssociatedUserIds();
                if (Seti.this._logger.isDebugEnabled()) {
                    Seti.this._logger.debug("Pushing associated users {} to comet {}", userIds, (Object)oortURL);
                }
                channel.publish((Object)new SetiPresence(true, userIds));
            }
        }

        @Override
        public void cometLeft(Oort.CometListener.Event event) {
            String oortURL = event.getCometURL();
            if (Seti.this._logger.isDebugEnabled()) {
                Seti.this._logger.debug("Comet left: {}", (Object)oortURL);
            }
            Seti.this.removePresences(oortURL);
        }
    }

    public static interface PresenceListener
    extends EventListener {
        public void presenceAdded(Event var1);

        public void presenceRemoved(Event var1);

        public static class Event
        extends EventObject {
            private final String userId;
            private final String url;

            public Event(Seti source, String userId, String url) {
                super((Object)source);
                this.userId = userId;
                this.url = url;
            }

            public Seti getSeti() {
                return (Seti)((Object)this.getSource());
            }

            public String getUserId() {
                return this.userId;
            }

            public String getOortURL() {
                return this.url;
            }

            public boolean isLocal() {
                return this.getSeti().getOort().getURL().equals(this.getOortURL());
            }

            @Override
            public String toString() {
                return String.format("%s[%s %s on %s]", new Object[]{this.getClass().getName(), this.getUserId(), this.isLocal() ? "local" : "remote", this.getSeti()});
            }
        }

        public static class Adapter
        implements PresenceListener {
            @Override
            public void presenceAdded(Event event) {
            }

            @Override
            public void presenceRemoved(Event event) {
            }
        }
    }

    private class SetiPresence
    extends HashMap<String, Object> {
        private static final String USER_IDS_FIELD = "userIds";
        private static final String OORT_URL_FIELD = "oortURL";
        private static final String ALIVE_FIELD = "alive";
        private static final String PRESENCE_FIELD = "presence";

        private SetiPresence(boolean present, String userId) {
            this(present, Collections.singleton(userId));
        }

        private SetiPresence(boolean present, Set<String> userIds) {
            super(4);
            this.put(USER_IDS_FIELD, userIds);
            this.put(OORT_URL_FIELD, Seti.this._oort.getURL());
            this.put(PRESENCE_FIELD, present);
        }
    }

    private class SetiMessage
    extends HashMap<String, Object> {
        private static final String USER_ID_FIELD = "userId";
        private static final String CHANNEL_FIELD = "channel";
        private static final String SETI_ID_FIELD = "setiId";
        private static final String DATA_FIELD = "data";

        private SetiMessage(String toUser, String toChannel, Object data) {
            super(4);
            this.put(USER_ID_FIELD, toUser);
            this.put(CHANNEL_FIELD, toChannel);
            this.put(SETI_ID_FIELD, Seti.this._setiId);
            this.put(DATA_FIELD, data);
        }
    }

    protected class SetiLocation
    implements Location {
        private final String _userId;
        private final String _oortURL;
        private final String _setiChannel;

        protected SetiLocation(String userId, String oortURL) {
            this._userId = userId;
            this._oortURL = oortURL;
            this._setiChannel = oortURL == null ? Seti.SETI_ALL_CHANNEL : Seti.this.generateSetiChannel(Seti.this.generateSetiId(oortURL));
        }

        @Override
        public void send(String toUser, String toChannel, Object data) {
            Seti.this._session.getChannel(this._setiChannel).publish((Object)new SetiMessage(toUser, toChannel, data));
        }

        @Override
        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SetiLocation)) {
                return false;
            }
            SetiLocation that = (SetiLocation)obj;
            return this._userId.equals(that._userId) && this._setiChannel.equals(that._setiChannel);
        }

        @Override
        public int hashCode() {
            return 31 * this._userId.hashCode() + this._setiChannel.hashCode();
        }

        public String toString() {
            return String.format("%s[%s]", this.getClass().getSimpleName(), this._setiChannel);
        }
    }

    protected class LocalLocation
    implements Location,
    ServerSession.RemoveListener {
        private final String _userId;
        private final ServerSession _session;

        protected LocalLocation(String userId, ServerSession session) {
            this._userId = userId;
            this._session = session;
        }

        @Override
        public void send(String toUser, String toChannel, Object data) {
            this._session.deliver((Session)Seti.this._session.getServerSession(), toChannel, data);
        }

        @Override
        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        public void removed(ServerSession session, boolean timeout) {
            Seti.this.disassociate(this._userId, session);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LocalLocation)) {
                return false;
            }
            LocalLocation that = (LocalLocation)obj;
            return this._userId.equals(that._userId) && this._session.getId().equals(that._session.getId());
        }

        @Override
        public int hashCode() {
            return 31 * this._userId.hashCode() + this._session.getId().hashCode();
        }

        public String toString() {
            return String.format("%s[%s]", this.getClass().getSimpleName(), this._session);
        }
    }

    protected static interface Location {
        public void send(String var1, String var2, Object var3);

        public void receive(String var1, String var2, Object var3);

        public int hashCode();

        public boolean equals(Object var1);
    }
}

