/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.oort.OortComet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OortObject<T>
extends AbstractLifeCycle
implements ConfigurableServerChannel.Initializer,
Oort.CometListener,
Iterable<Info<T>> {
    public static final String OORT_OBJECTS_CHANNEL = "/oort/objects";
    private static final String ACTION_FIELD_PUSH_VALUE = "oort.object.push";
    private static final String ACTION_FIELD_PULL_VALUE = "oort.object.pull";
    private final ConcurrentMap<String, ObjectPart> parts = new ConcurrentHashMap<String, ObjectPart>();
    private final List<Listener<T>> listeners = new CopyOnWriteArrayList<Listener<T>>();
    protected final Logger logger;
    private final Oort oort;
    private final String name;
    private final Factory<T> factory;
    private final LocalSession sender;
    private final String broadcastChannel;
    private final ServerChannel.MessageListener broadcastListener;
    private final ServerChannel.SubscriptionListener initialStateListener;
    private final String serviceChannel;
    private final ServerChannel.MessageListener serviceListener;

    public OortObject(Oort oort, String name, Factory<T> factory) {
        this.oort = oort;
        this.name = name;
        this.factory = factory;
        this.logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "." + Oort.replacePunctuation(oort.getURL(), '_') + "." + name));
        this.sender = oort.getBayeuxServer().newLocalSession(this.getClass().getSimpleName() + "." + name);
        this.broadcastChannel = "/oort/objects/" + name;
        this.broadcastListener = new BroadcastListener();
        this.initialStateListener = new InitialStateListener();
        this.serviceChannel = "/service" + this.broadcastChannel;
        this.serviceListener = new ServiceListener();
    }

    protected void doStart() throws Exception {
        ObjectPart part = new ObjectPart();
        this.parts.put(this.oort.getURL(), part);
        Info<T> info = this.newInfo(this.factory.newObject(null));
        part.update(info);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Set local {}", info);
        }
        this.sender.handshake();
        this.oort.addCometListener(this);
        BayeuxServer bayeuxServer = this.oort.getBayeuxServer();
        ServerChannel channel = (ServerChannel)bayeuxServer.createChannelIfAbsent(this.broadcastChannel, new ConfigurableServerChannel.Initializer[]{this}).getReference();
        channel.addListener((ConfigurableServerChannel.ServerChannelListener)this.broadcastListener);
        channel.addListener((ConfigurableServerChannel.ServerChannelListener)this.initialStateListener);
        this.oort.observeChannel(this.broadcastChannel);
        ((ServerChannel)bayeuxServer.createChannelIfAbsent(this.serviceChannel, new ConfigurableServerChannel.Initializer[]{this}).getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)this.serviceListener);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} started", (Object)this);
        }
    }

    protected void doStop() throws Exception {
        this.oort.deobserveChannel(this.broadcastChannel);
        BayeuxServer bayeuxServer = this.oort.getBayeuxServer();
        ServerChannel channel = bayeuxServer.getChannel(this.broadcastChannel);
        if (channel != null) {
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this.initialStateListener);
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this.broadcastListener);
        }
        if ((channel = bayeuxServer.getChannel(this.serviceChannel)) != null) {
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this.serviceListener);
        }
        this.oort.removeCometListener(this);
        this.sender.disconnect();
        this.parts.clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} stopped", (Object)this);
        }
    }

    public void configureChannel(ConfigurableServerChannel channel) {
    }

    public Oort getOort() {
        return this.oort;
    }

    public String getName() {
        return this.name;
    }

    public Factory<T> getFactory() {
        return this.factory;
    }

    public LocalSession getLocalSession() {
        return this.sender;
    }

    public String getChannelName() {
        return this.broadcastChannel;
    }

    @Deprecated
    public T setAndShare(T newObject) {
        Result.Deferred result = new Result.Deferred();
        this.setAndShare(newObject, result);
        return (T)result.get();
    }

    public void setAndShare(T newObject, Result<T> callback) {
        if (newObject == null) {
            throw new NullPointerException();
        }
        Data<T> data = new Data<T>(4, callback);
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", this.serialize(newObject));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sharing {}", data);
        }
        BayeuxServer bayeuxServer = this.oort.getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), data);
    }

    protected Object serialize(T object) {
        return object;
    }

    protected Object deserialize(Object object) {
        return object;
    }

    protected Info<T> newInfo(T local) {
        if (local == null) {
            throw new NullPointerException();
        }
        Info info = new Info(this.oort.getURL(), null);
        info.put("oort.info.url", this.oort.getURL());
        info.put("oort.info.name", this.getName());
        info.put("oort.info.object", local);
        info.put("oort.info.version", 0);
        return info;
    }

    @Override
    public void cometJoined(Oort.CometListener.Event event) {
        String remoteOortURL = event.getCometURL();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Oort {} joined", (Object)remoteOortURL);
        }
        this.pushInfo(remoteOortURL, null);
    }

    @Override
    public void cometLeft(Oort.CometListener.Event event) {
        Info<T> info;
        String remoteOortURL = event.getCometURL();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Oort {} left", (Object)remoteOortURL);
        }
        if ((info = this.removeInfo(remoteOortURL)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removed remote {}", info);
            }
            this.notifyRemoved(info);
        }
    }

    @Override
    public Iterator<Info<T>> iterator() {
        return this.getInfos().iterator();
    }

    public Info<T> getInfo(String oortURL) {
        ObjectPart part = (ObjectPart)this.parts.get(oortURL);
        return part == null ? null : part.getInfo();
    }

    Info<T> removeInfo(String oortURL) {
        ObjectPart part = (ObjectPart)this.parts.remove(oortURL);
        return part == null ? null : part.getInfo();
    }

    public Info<T> getInfoByObject(T object) {
        for (Info<T> info : this) {
            if (!info.getObject().equals(object)) continue;
            return info;
        }
        return null;
    }

    public <R> R merge(Merger<T, R> strategy) {
        return strategy.merge(this.getInfos());
    }

    public void addListener(Listener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener<T> listener) {
        this.listeners.remove(listener);
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    protected void notifyUpdated(Info<T> oldInfo, Info<T> newInfo) {
        for (Listener<T> listener : this.listeners) {
            try {
                listener.onUpdated(oldInfo, newInfo);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    protected void notifyRemoved(Info<T> info) {
        for (Listener<T> listener : this.listeners) {
            try {
                listener.onRemoved(info);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    protected void onObject(Map<String, Object> data) {
        String oortURL = (String)data.get("oort.info.url");
        boolean local = this.oort.getURL().equals(oortURL);
        Object object = data.get("oort.info.object");
        if (!local) {
            object = this.deserialize(object);
            object = this.getFactory().newObject(object);
        }
        Info newInfo = new Info(this.oort.getURL(), data);
        newInfo.put("oort.info.object", object);
        ObjectPart part = this.part(oortURL);
        Info oldInfo = part.update(newInfo);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Performed {} update of {} with {}", new Object[]{newInfo.isLocal() ? "local" : "remote", oldInfo, newInfo});
        }
        this.notifyUpdated(oldInfo, newInfo);
        if (oldInfo == null && !this.oort.getURL().equals(data.get("oort.info.peer"))) {
            this.pushInfoReply(oortURL);
        }
        if (data instanceof Data) {
            ((Data)data).setResult(oldInfo == null ? null : (Object)oldInfo.getObject());
        }
    }

    private ObjectPart part(String oortURL) {
        ObjectPart part = (ObjectPart)this.parts.get(oortURL);
        if (part == null) {
            part = new ObjectPart();
            ObjectPart existing = this.parts.putIfAbsent(oortURL, part);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Created part {} for {}{}", new Object[]{part, oortURL, existing != null ? ", existing " + existing : ""});
            }
            if (existing != null) {
                part = existing;
            }
        }
        return part;
    }

    protected void pushInfo(String oortURL, Map<String, Object> fields) {
        OortComet oortComet = this.oort.findComet(oortURL);
        Info<T> info = this.getInfo(this.oort.getURL());
        if (oortComet != null && info != null) {
            Map<String, Object> message = fields;
            if (message == null) {
                message = new HashMap<String, Object>();
            }
            message.putAll(info);
            message.put("oort.info.action", ACTION_FIELD_PUSH_VALUE);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Pushing (to {}): {}", (Object)oortURL, message);
            }
            oortComet.getChannel(this.serviceChannel).publish(message);
        }
    }

    private void pushInfoReply(String oortURL) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("oort.info.peer", oortURL);
        this.pushInfo(oortURL, fields);
    }

    protected void pullInfo(String oortURL) {
        OortComet oortComet = this.oort.getComet(oortURL);
        if (oortComet != null) {
            HashMap<String, String> message = new HashMap<String, String>();
            message.put("oort.info.url", this.getOort().getURL());
            message.put("oort.info.name", this.getName());
            message.put("oort.info.action", ACTION_FIELD_PULL_VALUE);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Pulling (from {}): {}", (Object)oortURL, message);
            }
            oortComet.getChannel(this.serviceChannel).publish(message);
        }
    }

    protected Collection<Info<T>> getInfos() {
        ArrayList<Info<T>> result = new ArrayList<Info<T>>(this.parts.size());
        for (ObjectPart part : this.parts.values()) {
            Info info = part.getInfo();
            if (info == null) continue;
            result.add(info);
        }
        return result;
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getSimpleName(), this.getName(), this.getOort().getURL());
    }

    private class ObjectPart {
        private final Deque<Map<String, Object>> updates = new ArrayDeque<Map<String, Object>>();
        private boolean active;
        private long versions;
        private Info<T> info;

        private ObjectPart() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Info<T> getInfo() {
            ObjectPart objectPart = this;
            synchronized (objectPart) {
                return this.info;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Info<T> update(Info<T> newInfo) {
            ObjectPart objectPart = this;
            synchronized (objectPart) {
                Info oldInfo = this.info;
                this.info = newInfo;
                return oldInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueue(Map<String, Object> data) {
            ObjectPart objectPart = this;
            synchronized (objectPart) {
                boolean local = OortObject.this.oort.getURL().equals(data.get("oort.info.url"));
                if (local) {
                    long version = ++this.versions;
                    data.put("oort.info.version", version);
                    if (OortObject.this.logger.isDebugEnabled()) {
                        OortObject.this.logger.debug("Generated version={} for {}", (Object)version, data);
                    }
                }
                this.updates.offer(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process() {
            ObjectPart objectPart = this;
            synchronized (objectPart) {
                if (this.active) {
                    return;
                }
                this.active = true;
            }
            while (true) {
                long current;
                Map<String, Object> data;
                ObjectPart objectPart2 = this;
                synchronized (objectPart2) {
                    data = this.updates.poll();
                    if (data == null) {
                        this.active = false;
                        return;
                    }
                    current = this.info == null ? -1L : this.info.getVersion();
                }
                String oortURL = (String)data.get("oort.info.url");
                if (OortObject.ACTION_FIELD_PULL_VALUE.equals(data.get("oort.info.action"))) {
                    OortObject.this.pushInfoReply(oortURL);
                    continue;
                }
                if (OortObject.ACTION_FIELD_PUSH_VALUE.equals(data.get("oort.info.action")) && !OortObject.this.oort.getURL().equals(data.get("oort.info.peer"))) {
                    OortObject.this.pushInfoReply(oortURL);
                }
                long version = ((Number)data.get("oort.info.version")).longValue();
                if (OortObject.this.logger.isDebugEnabled()) {
                    OortObject.this.logger.debug("Processing update, version={}, data={}", (Object)current, data);
                }
                if (version <= current) continue;
                OortObject.this.onObject(data);
            }
        }
    }

    public static interface Factory<T> {
        public T newObject(Object var1);
    }

    private class BroadcastListener
    implements ServerChannel.MessageListener {
        private BroadcastListener() {
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (OortObject.this.logger.isDebugEnabled()) {
                OortObject.this.logger.debug("Received broadcast {}", (Object)message);
            }
            Map data = message.getDataAsMap();
            String oortURL = (String)data.get("oort.info.url");
            ObjectPart part = OortObject.this.part(oortURL);
            part.enqueue(data);
            part.process();
            return true;
        }
    }

    private class InitialStateListener
    implements ServerChannel.SubscriptionListener {
        private InitialStateListener() {
        }

        public void subscribed(ServerSession session, ServerChannel channel, ServerMessage message) {
            session.deliver((Session)OortObject.this.getLocalSession(), channel.getId(), OortObject.this.getInfo(OortObject.this.getOort().getURL()));
        }

        public void unsubscribed(ServerSession session, ServerChannel channel, ServerMessage message) {
        }
    }

    private class ServiceListener
    implements ServerChannel.MessageListener {
        private ServiceListener() {
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (OortObject.this.logger.isDebugEnabled()) {
                OortObject.this.logger.debug("Received service {}", (Object)message);
            }
            Map data = message.getDataAsMap();
            String oortURL = (String)data.get("oort.info.url");
            if (OortObject.ACTION_FIELD_PULL_VALUE.equals(data.get("oort.info.action"))) {
                oortURL = OortObject.this.oort.getURL();
            }
            ObjectPart part = OortObject.this.part(oortURL);
            part.enqueue(data);
            part.process();
            return true;
        }
    }

    public static class Info<T>
    extends HashMap<String, Object> {
        public static final String VERSION_FIELD = "oort.info.version";
        public static final String OORT_URL_FIELD = "oort.info.url";
        public static final String NAME_FIELD = "oort.info.name";
        public static final String OBJECT_FIELD = "oort.info.object";
        public static final String TYPE_FIELD = "oort.info.type";
        public static final String ACTION_FIELD = "oort.info.action";
        public static final String PEER_FIELD = "oort.info.peer";
        private final String oortURL;

        protected Info(String oortURL, Map<? extends String, ?> map) {
            super(4);
            this.oortURL = oortURL;
            if (map != null) {
                this.putAll(map);
            }
        }

        protected long getVersion() {
            return ((Number)this.get(VERSION_FIELD)).longValue();
        }

        public String getOortURL() {
            return (String)this.get(OORT_URL_FIELD);
        }

        public String getName() {
            return (String)this.get(NAME_FIELD);
        }

        public T getObject() {
            return (T)this.get(OBJECT_FIELD);
        }

        public boolean isLocal() {
            return this.oortURL.equals(this.getOortURL());
        }

        @Override
        public String toString() {
            T object = this.getObject();
            String objectString = object instanceof Object[] ? Arrays.toString((Object[])object) : String.valueOf(object);
            long version = this.containsKey(VERSION_FIELD) ? ((Number)this.get(VERSION_FIELD)).longValue() : -1L;
            return String.format("%s[%s/%d] (from %s): %s", this.getClass().getSimpleName(), this.getName(), version, this.getOortURL(), objectString);
        }
    }

    public static interface Result<R> {
        public void onResult(R var1);

        public static class Deferred<D>
        implements Result<D> {
            private final CountDownLatch latch = new CountDownLatch(1);
            private D result;

            @Override
            public void onResult(D result) {
                this.result = result;
                this.latch.countDown();
            }

            public D get(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
                if (this.latch.await(time, unit)) {
                    return this.result;
                }
                throw new TimeoutException();
            }

            D get() {
                try {
                    this.latch.await();
                    return this.result;
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException();
                }
            }
        }
    }

    protected static class Data<T>
    extends HashMap<String, Object> {
        private final Result<T> callback;

        protected Data(int initialCapacity, Result<T> callback) {
            super(initialCapacity);
            this.callback = callback;
        }

        protected void setResult(T result) {
            if (this.callback != null) {
                this.callback.onResult(result);
            }
        }
    }

    public static interface Merger<T, R> {
        public R merge(Collection<Info<T>> var1);
    }

    public static interface Listener<T>
    extends EventListener {
        public void onUpdated(Info<T> var1, Info<T> var2);

        public void onRemoved(Info<T> var1);

        public static class Adapter<T>
        implements Listener<T> {
            @Override
            public void onUpdated(Info<T> oldInfo, Info<T> newInfo) {
            }

            @Override
            public void onRemoved(Info<T> info) {
            }
        }
    }
}

