/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.client.ext.AckExtension;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.LongPollingTransport;
import org.cometd.common.JSONContext;
import org.cometd.oort.OortComet;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.cometd.server.ext.AcknowledgedMessagesExtension;
import org.cometd.server.ext.BinaryExtension;
import org.cometd.websocket.client.WebSocketTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="CometD cloud node")
public class Oort
extends ContainerLifeCycle {
    public static final String OORT_ATTRIBUTE = Oort.class.getName();
    public static final String EXT_OORT_FIELD = "org.cometd.oort";
    public static final String EXT_OORT_URL_FIELD = "oortURL";
    public static final String EXT_OORT_ID_FIELD = "oortId";
    public static final String EXT_OORT_SECRET_FIELD = "oortSecret";
    public static final String EXT_COMET_URL_FIELD = "cometURL";
    public static final String EXT_OORT_ALIAS_URL_FIELD = "oortAliasURL";
    public static final String OORT_CLOUD_CHANNEL = "/oort/cloud";
    public static final String OORT_SERVICE_CHANNEL = "/service/oort";
    private static final String COMET_URL_ATTRIBUTE = "org.cometd.oort.cometURL";
    private static final String JOIN_MESSAGE_ATTRIBUTE = Oort.class.getName() + ".joinMessage";
    private final Map<String, OortComet> _pendingComets = new HashMap<String, OortComet>();
    private final Map<String, ClientCometInfo> _clientComets = new HashMap<String, ClientCometInfo>();
    private final Map<String, ServerCometInfo> _serverComets = new HashMap<String, ServerCometInfo>();
    private final ConcurrentMap<String, Boolean> _channels = new ConcurrentHashMap<String, Boolean>();
    private final CopyOnWriteArrayList<CometListener> _cometListeners = new CopyOnWriteArrayList();
    private final BayeuxServer.Extension _oortExtension = new OortExtension();
    private final ServerChannel.MessageListener _cloudListener = new CloudListener();
    private final ServerChannel.MessageListener _joinListener = new JoinListener();
    private final List<ClientTransport.Factory> _transportFactories = new ArrayList<ClientTransport.Factory>();
    private final BayeuxServer _bayeux;
    private final String _url;
    private final String _id;
    private final Logger _logger;
    private final LocalSession _oortSession;
    private final Object _lock = this;
    private ScheduledExecutorService _scheduler;
    private String _secret;
    private boolean _ackExtensionEnabled;
    private BayeuxServer.Extension _ackExtension;
    private boolean _binaryExtensionEnabled;
    private BayeuxServer.Extension _serverBinaryExtension;
    private ClientSession.Extension _binaryExtension;
    private JSONContext.Client _jsonContext;

    public Oort(BayeuxServer bayeux, String url) {
        this._bayeux = bayeux;
        this._url = url;
        this._id = UUID.randomUUID().toString();
        this._logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + Oort.replacePunctuation(this._url, '_')));
        this._oortSession = bayeux.newLocalSession("oort");
        this._secret = Long.toHexString(new SecureRandom().nextLong());
    }

    protected void doStart() throws Exception {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        scheduler.setRemoveOnCancelPolicy(true);
        this._scheduler = scheduler;
        if (this._transportFactories.isEmpty()) {
            this._transportFactories.add((ClientTransport.Factory)new WebSocketTransport.Factory());
            this._transportFactories.add((ClientTransport.Factory)new LongPollingTransport.Factory(new HttpClient()));
        }
        for (ClientTransport.Factory factory : this._transportFactories) {
            this.addBean(factory);
        }
        super.doStart();
        if (this.isAckExtensionEnabled()) {
            boolean present = false;
            for (BayeuxServer.Extension extension : this._bayeux.getExtensions()) {
                if (!(extension instanceof AcknowledgedMessagesExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                this._ackExtension = new AcknowledgedMessagesExtension();
                this._bayeux.addExtension(this._ackExtension);
            }
        }
        if (this.isBinaryExtensionEnabled()) {
            this._binaryExtension = new org.cometd.client.ext.BinaryExtension();
            this._oortSession.addExtension(this._binaryExtension);
            boolean present = false;
            for (BayeuxServer.Extension extension : this._bayeux.getExtensions()) {
                if (!(extension instanceof BinaryExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                this._serverBinaryExtension = new BinaryExtension();
                this._bayeux.addExtension(this._serverBinaryExtension);
            }
        }
        this._bayeux.addExtension(this._oortExtension);
        ServerChannel oortCloudChannel = (ServerChannel)this._bayeux.createChannelIfAbsent(OORT_CLOUD_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference();
        oortCloudChannel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
        oortCloudChannel.addListener((ConfigurableServerChannel.ServerChannelListener)this._cloudListener);
        ServerChannel serverChannel = (ServerChannel)this._bayeux.createChannelIfAbsent(OORT_SERVICE_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference();
        serverChannel.addListener((ConfigurableServerChannel.ServerChannelListener)this._joinListener);
        this._oortSession.handshake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        this._oortSession.disconnect();
        this._oortSession.removeExtension(this._binaryExtension);
        ArrayList<OortComet> comets = new ArrayList<OortComet>();
        Iterator iterator = this._lock;
        synchronized (iterator) {
            comets.addAll(this._pendingComets.values());
            this._pendingComets.clear();
            for (ClientCometInfo cometInfo : this._clientComets.values()) {
                comets.add(cometInfo.getOortComet());
            }
            this._clientComets.clear();
            this._serverComets.clear();
        }
        for (OortComet comet : comets) {
            comet.disconnect(1000L);
        }
        this._channels.clear();
        ServerChannel channel = this._bayeux.getChannel(OORT_SERVICE_CHANNEL);
        if (channel != null) {
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this._joinListener);
        }
        if ((channel = this._bayeux.getChannel(OORT_CLOUD_CHANNEL)) != null) {
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this._cloudListener);
            channel.removeAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
        }
        BayeuxServer.Extension ackExtension = this._ackExtension;
        this._ackExtension = null;
        if (ackExtension != null) {
            this._bayeux.removeExtension(ackExtension);
        }
        BayeuxServer.Extension binaryExtension = this._serverBinaryExtension;
        this._serverBinaryExtension = null;
        if (binaryExtension != null) {
            this._bayeux.removeExtension(binaryExtension);
        }
        this._bayeux.removeExtension(this._oortExtension);
        this._scheduler.shutdown();
        super.doStop();
        for (ClientTransport.Factory factory : this._transportFactories) {
            this.removeBean(factory);
        }
    }

    @ManagedAttribute(value="The BayeuxServer of this Oort", readonly=true)
    public BayeuxServer getBayeuxServer() {
        return this._bayeux;
    }

    @ManagedAttribute(value="The URL of this Oort", readonly=true)
    public String getURL() {
        return this._url;
    }

    @ManagedAttribute(value="The unique ID of this Oort", readonly=true)
    public String getId() {
        return this._id;
    }

    @ManagedAttribute(value="The secret of this Oort")
    public String getSecret() {
        return this._secret;
    }

    public void setSecret(String secret) {
        this._secret = secret;
    }

    @ManagedAttribute(value="Whether the acknowledgement extension is enabled")
    public boolean isAckExtensionEnabled() {
        return this._ackExtensionEnabled;
    }

    public void setAckExtensionEnabled(boolean value) {
        this._ackExtensionEnabled = value;
    }

    @ManagedAttribute(value="Whether the binary extension is enabled")
    public boolean isBinaryExtensionEnabled() {
        return this._binaryExtensionEnabled;
    }

    public void setBinaryExtensionEnabled(boolean value) {
        this._binaryExtensionEnabled = value;
    }

    public JSONContext.Client getJSONContextClient() {
        return this._jsonContext;
    }

    public void setJSONContextClient(JSONContext.Client jsonContext) {
        this._jsonContext = jsonContext;
    }

    public List<ClientTransport.Factory> getClientTransportFactories() {
        return this._transportFactories;
    }

    public void setClientTransportFactories(List<ClientTransport.Factory> factories) {
        this._transportFactories.clear();
        this._transportFactories.addAll(factories);
    }

    public OortComet observeComet(String cometURL) {
        return this.observeComet(cometURL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OortComet observeComet(String cometURL, String oortAliasURL) {
        OortComet oortComet;
        try {
            URI uri = new URI(cometURL);
            if (uri.getScheme() == null) {
                throw new IllegalArgumentException("Missing protocol in comet URL " + cometURL);
            }
            if (uri.getHost() == null) {
                throw new IllegalArgumentException("Missing host in comet URL " + cometURL);
            }
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x);
        }
        if (this._url.equals(cometURL)) {
            return null;
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Observing comet {}", (Object)cometURL);
        }
        Object object = this._lock;
        synchronized (object) {
            oortComet = this.getComet(cometURL);
            if (oortComet != null) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Comet {} is already connected with {}", (Object)cometURL, (Object)oortComet);
                }
                return oortComet;
            }
            oortComet = this._pendingComets.get(cometURL);
            if (oortComet != null) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Comet {} is already connecting with {}", (Object)cometURL, (Object)oortComet);
                }
                return oortComet;
            }
            oortComet = this.newOortComet(cometURL);
            this.configureOortComet(oortComet);
            this._pendingComets.put(cometURL, oortComet);
        }
        oortComet.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)new HandshakeListener(cometURL, oortComet));
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Connecting to comet {} with {}", (Object)cometURL, (Object)oortComet);
        }
        Map<String, Object> fields = this.newOortHandshakeFields(cometURL, oortAliasURL);
        this.connectComet(oortComet, fields);
        return oortComet;
    }

    protected OortComet newOortComet(String cometURL) {
        String idleTimeoutOption;
        String maxMessageSizeOption;
        Object option;
        HashMap<String, Object> options = new HashMap<String, Object>(2);
        options.put("scheduler", this._scheduler);
        JSONContext.Client jsonContext = this.getJSONContextClient();
        if (jsonContext != null) {
            options.put("jsonContext", jsonContext);
        }
        if ((option = this._bayeux.getOption(maxMessageSizeOption = "maxMessageSize")) != null) {
            options.put(maxMessageSizeOption, option);
        }
        if ((option = this._bayeux.getOption(maxMessageSizeOption = "ws.maxMessageSize")) != null) {
            options.put(maxMessageSizeOption, option);
        }
        if ((option = this._bayeux.getOption(idleTimeoutOption = "ws.idleTimeout")) != null) {
            options.put(idleTimeoutOption, option);
        }
        ArrayList<ClientTransport> transports = new ArrayList<ClientTransport>();
        for (ClientTransport.Factory factory : this.getClientTransportFactories()) {
            transports.add(factory.newClientTransport(cometURL, options));
        }
        ClientTransport transport = (ClientTransport)transports.get(0);
        int size = transports.size();
        ClientTransport[] otherTransports = transports.subList(1, size).toArray(new ClientTransport[size - 1]);
        return new OortComet(this, cometURL, this._scheduler, transport, otherTransports);
    }

    protected void configureOortComet(OortComet oortComet) {
        boolean present;
        if (this.isAckExtensionEnabled()) {
            present = false;
            for (ClientSession.Extension extension : oortComet.getExtensions()) {
                if (!(extension instanceof AckExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                oortComet.addExtension((ClientSession.Extension)new AckExtension());
            }
        }
        if (this.isBinaryExtensionEnabled()) {
            present = false;
            for (ClientSession.Extension extension : oortComet.getExtensions()) {
                if (!(extension instanceof org.cometd.client.ext.BinaryExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                oortComet.addExtension((ClientSession.Extension)new org.cometd.client.ext.BinaryExtension());
            }
        }
    }

    protected String encodeSecret(String secret) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            return new String(B64Code.encode((byte[])digest.digest(secret.getBytes("UTF-8"))));
        }
        catch (Exception x) {
            throw new IllegalArgumentException(x);
        }
    }

    protected void connectComet(OortComet comet, Map<String, Object> fields) {
        comet.handshake(fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OortComet deobserveComet(String cometURL) {
        OortComet comet;
        block8: {
            if (this._url.equals(cometURL)) {
                return null;
            }
            Object object = this._lock;
            synchronized (object) {
                block7: {
                    comet = this._pendingComets.remove(cometURL);
                    if (comet == null) break block7;
                    if (!this._logger.isDebugEnabled()) break block8;
                    this._logger.debug("Disconnecting pending comet {} with {}", (Object)cometURL, (Object)comet);
                    break block8;
                }
                Iterator<ClientCometInfo> cometInfos = this._clientComets.values().iterator();
                while (cometInfos.hasNext()) {
                    ClientCometInfo cometInfo = cometInfos.next();
                    if (!cometInfo.matchesURL(cometURL)) continue;
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug("Disconnecting comet {}", (Object)cometInfo);
                    }
                    comet = cometInfo.getOortComet();
                    cometInfos.remove();
                    break;
                }
            }
        }
        if (comet != null) {
            comet.disconnect();
        }
        return comet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(value="URLs of known Oorts in the cluster", readonly=true)
    public Set<String> getKnownComets() {
        HashSet<String> result = new HashSet<String>();
        Object object = this._lock;
        synchronized (object) {
            for (ClientCometInfo cometInfo : this._clientComets.values()) {
                result.add(cometInfo.getOortURL());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OortComet getComet(String cometURL) {
        Object object = this._lock;
        synchronized (object) {
            for (ClientCometInfo cometInfo : this._clientComets.values()) {
                if (!cometInfo.matchesURL(cometURL)) continue;
                return cometInfo.getOortComet();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OortComet findComet(String cometURL) {
        Object object = this._lock;
        synchronized (object) {
            OortComet result = this._pendingComets.get(cometURL);
            if (result == null) {
                result = this.getComet(cometURL);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="Observes the given channel", impact="ACTION")
    public void observeChannel(@Name(value="channel", description="The channel to observe") String channelName) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Observing channel {}", (Object)channelName);
        }
        if (!ChannelId.isBroadcast((String)channelName)) {
            throw new IllegalArgumentException("Channel " + channelName + " cannot be observed because is not a broadcast channel");
        }
        if (this._channels.putIfAbsent(channelName, Boolean.TRUE) == null) {
            Set<String> observedChannels = this.getObservedChannels();
            ArrayList<OortComet> oortComets = new ArrayList<OortComet>();
            Iterator iterator = this._lock;
            synchronized (iterator) {
                for (ClientCometInfo cometInfo : this._clientComets.values()) {
                    oortComets.add(cometInfo.getOortComet());
                }
            }
            for (OortComet oortComet : oortComets) {
                oortComet.subscribe(observedChannels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="Deobserves the given channel", impact="ACTION")
    public void deobserveChannel(@Name(value="channel", description="The channel to deobserve") String channelId) {
        if (this._channels.remove(channelId) != null) {
            ArrayList<OortComet> oortComets = new ArrayList<OortComet>();
            Iterator iterator = this._lock;
            synchronized (iterator) {
                for (ClientCometInfo cometInfo : this._clientComets.values()) {
                    oortComets.add(cometInfo.getOortComet());
                }
            }
            for (OortComet oortComet : oortComets) {
                oortComet.unsubscribe(channelId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOort(ServerSession session) {
        String id = session.getId();
        if (id.equals(this._oortSession.getId())) {
            return true;
        }
        Object object = this._lock;
        synchronized (object) {
            for (ServerCometInfo cometInfo : this._serverComets.values()) {
                if (!cometInfo.getServerSession().getId().equals(session.getId())) continue;
                return true;
            }
        }
        return session.getAttribute(COMET_URL_ATTRIBUTE) != null;
    }

    public boolean isOortHandshake(Message handshake) {
        if (!"/meta/handshake".equals(handshake.getChannel())) {
            return false;
        }
        Map ext = handshake.getExt();
        if (ext == null) {
            return false;
        }
        Object oortExtObject = ext.get(EXT_OORT_FIELD);
        if (!(oortExtObject instanceof Map)) {
            return false;
        }
        Map oortExt = (Map)oortExtObject;
        String cometURL = (String)oortExt.get(EXT_COMET_URL_FIELD);
        if (!this.getURL().equals(cometURL)) {
            return false;
        }
        String b64RemoteSecret = (String)oortExt.get(EXT_OORT_SECRET_FIELD);
        String b64LocalSecret = this.encodeSecret(this.getSecret());
        return b64LocalSecret.equals(b64RemoteSecret);
    }

    protected Map<String, Object> newOortHandshakeFields(String cometURL, String oortAliasURL) {
        HashMap<String, Object> fields = new HashMap<String, Object>(1);
        HashMap ext = new HashMap(1);
        fields.put("ext", ext);
        HashMap<String, String> oortExt = new HashMap<String, String>(4);
        ext.put(EXT_OORT_FIELD, oortExt);
        oortExt.put(EXT_OORT_URL_FIELD, this.getURL());
        oortExt.put(EXT_OORT_ID_FIELD, this.getId());
        String b64Secret = this.encodeSecret(this.getSecret());
        oortExt.put(EXT_OORT_SECRET_FIELD, b64Secret);
        oortExt.put(EXT_COMET_URL_FIELD, cometURL);
        if (oortAliasURL != null) {
            oortExt.put(EXT_OORT_ALIAS_URL_FIELD, oortAliasURL);
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCometConnected(String oortURL) {
        Object object = this._lock;
        synchronized (object) {
            for (ServerCometInfo serverCometInfo : this._serverComets.values()) {
                if (!serverCometInfo.getOortURL().equals(oortURL)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean incomingCometHandshake(Map<String, Object> oortExt, ServerSession session) {
        ClientCometInfo clientCometInfo;
        String remoteOortURL = (String)oortExt.get(EXT_OORT_URL_FIELD);
        String remoteOortId = (String)oortExt.get(EXT_OORT_ID_FIELD);
        ServerCometInfo serverCometInfo = new ServerCometInfo(remoteOortId, remoteOortURL, session);
        Object object = this._lock;
        synchronized (object) {
            ServerCometInfo existing = this._serverComets.get(remoteOortId);
            if (existing != null) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Comet already known {}", (Object)existing);
                }
                return false;
            }
            this._serverComets.put(remoteOortId, serverCometInfo);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Registered server comet {}", (Object)serverCometInfo);
            }
            clientCometInfo = this._clientComets.get(remoteOortId);
        }
        session.addListener((ServerSession.ServerSessionListener)new OortCometDisconnectListener());
        session.addListener((ServerSession.ServerSessionListener)new OortCometLoopListener());
        if (clientCometInfo != null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Client comet present {}", (Object)clientCometInfo);
            }
            clientCometInfo.getOortComet().open();
        } else if (this._logger.isDebugEnabled()) {
            this._logger.debug("Client comet not yet present");
        }
        return true;
    }

    public void addCometListener(CometListener listener) {
        this._cometListeners.add(listener);
    }

    public void removeCometListener(CometListener listener) {
        this._cometListeners.remove(listener);
    }

    public void removeCometListeners() {
        this._cometListeners.clear();
    }

    private void notifyCometJoined(String remoteOortId, String remoteOortURL) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Comet joined: {}|{}", (Object)remoteOortId, (Object)remoteOortURL);
        }
        CometListener.Event event = new CometListener.Event(this, remoteOortId, remoteOortURL);
        for (CometListener cometListener : this._cometListeners) {
            try {
                cometListener.cometJoined(event);
            }
            catch (Throwable x) {
                this._logger.info("Exception while invoking listener " + cometListener, x);
            }
        }
    }

    private void notifyCometLeft(String remoteOortId, String remoteOortURL) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Comet left: {}|{}", (Object)remoteOortId, (Object)remoteOortURL);
        }
        CometListener.Event event = new CometListener.Event(this, remoteOortId, remoteOortURL);
        for (CometListener cometListener : this._cometListeners) {
            try {
                cometListener.cometLeft(event);
            }
            catch (Throwable x) {
                this._logger.info("Exception while invoking listener " + cometListener, x);
            }
        }
    }

    protected void joinComets(Message message) {
        Object[] array;
        Object data = message.getData();
        for (Object element : array = data instanceof List ? ((List)data).toArray() : (Object[])data) {
            this.observeComet((String)element);
        }
    }

    public Set<String> getObservedChannels() {
        return new HashSet<String>(this._channels.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> knownOortIds() {
        ArrayList<String> result = new ArrayList<String>();
        Object object = this._lock;
        synchronized (object) {
            result.addAll(this._clientComets.keySet());
        }
        return result;
    }

    public LocalSession getOortSession() {
        return this._oortSession;
    }

    protected static String replacePunctuation(String source, char replacement) {
        String replaced = source.replaceAll("[^\\p{Alnum}]", String.valueOf(replacement));
        return replaced.replaceAll("(" + replacement + ")\\1+", "$1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<ClientCometInfo> clientInfos;
        super.dump(out, indent);
        ArrayList<DumpableCollection> children = new ArrayList<DumpableCollection>();
        Set<String> observedChannels = this.getObservedChannels();
        children.add(new DumpableCollection("observed channels: " + observedChannels.size(), observedChannels));
        Object object = this._lock;
        synchronized (object) {
            clientInfos = new ArrayList<ClientCometInfo>(this._clientComets.values());
        }
        children.add(new DumpableCollection("connected comets: " + clientInfos.size(), clientInfos));
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{children});
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.getURL());
    }

    private static class DumpableCollection
    implements Dumpable {
        private final String name;
        private final Collection<?> collection;

        private DumpableCollection(String name, Collection<?> collection) {
            this.name = name;
            this.collection = collection;
        }

        public String dump() {
            return ContainerLifeCycle.dump((Dumpable)this);
        }

        public void dump(Appendable out, String indent) throws IOException {
            out.append(this.name).append(System.lineSeparator());
            if (this.collection != null) {
                ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{this.collection});
            }
        }
    }

    private static class ClientCometInfo
    extends CometInfo {
        private final OortComet oortComet;
        private Set<String> urls;

        private ClientCometInfo(String oortId, String oortURL, OortComet oortComet) {
            super(oortId, oortURL);
            this.oortComet = oortComet;
        }

        private OortComet getOortComet() {
            return this.oortComet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addAliasURL(String url) {
            ClientCometInfo clientCometInfo = this;
            synchronized (clientCometInfo) {
                if (this.urls == null) {
                    this.urls = new HashSet<String>();
                }
                this.urls.add(url);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean matchesURL(String url) {
            if (this.getOortURL().equals(url)) {
                return true;
            }
            ClientCometInfo clientCometInfo = this;
            synchronized (clientCometInfo) {
                return this.urls != null && this.urls.contains(url);
            }
        }

        @Override
        public String toString() {
            return String.format("%s[%s]%s", new Object[]{super.toString(), this.oortComet, Objects.toString(this.urls, "")});
        }
    }

    private static class ServerCometInfo
    extends CometInfo {
        private final ServerSession session;

        private ServerCometInfo(String oortId, String oortURL, ServerSession session) {
            super(oortId, oortURL);
            this.session = session;
        }

        private ServerSession getServerSession() {
            return this.session;
        }

        @Override
        public String toString() {
            return String.format("%s[%s]", super.toString(), this.session);
        }
    }

    private static abstract class CometInfo {
        private final String oortId;
        private final String oortURL;

        protected CometInfo(String oortId, String oortURL) {
            this.oortId = oortId;
            this.oortURL = oortURL;
        }

        protected String getOortId() {
            return this.oortId;
        }

        protected String getOortURL() {
            return this.oortURL;
        }

        public String toString() {
            return String.format("%s@%x[%s|%s]", this.getClass().getSimpleName(), this.hashCode(), this.oortId, this.oortURL);
        }
    }

    private class HandshakeListener
    implements ClientSessionChannel.MessageListener {
        private final String cometURL;
        private final OortComet oortComet;

        private HandshakeListener(String cometURL, OortComet oortComet) {
            this.cometURL = cometURL;
            this.oortComet = oortComet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(ClientSessionChannel channel, Message message) {
            ServerCometInfo serverCometInfo;
            ClientCometInfo clientCometInfo;
            Map ext = message.getExt();
            if (ext == null) {
                return;
            }
            Object oortExtObject = ext.get(Oort.EXT_OORT_FIELD);
            if (!(oortExtObject instanceof Map)) {
                return;
            }
            Map oortExt = (Map)oortExtObject;
            String oortId = (String)oortExt.get(Oort.EXT_OORT_ID_FIELD);
            String oortURL = (String)oortExt.get(Oort.EXT_OORT_URL_FIELD);
            boolean ready = false;
            Object object = Oort.this._lock;
            synchronized (object) {
                Oort.this._pendingComets.remove(this.cometURL);
                Iterator iterator = Oort.this._clientComets.values().iterator();
                while (iterator.hasNext()) {
                    clientCometInfo = (ClientCometInfo)iterator.next();
                    if (clientCometInfo.getOortId().equals(oortId) || !clientCometInfo.matchesURL(this.cometURL) && !clientCometInfo.matchesURL(oortURL)) continue;
                    iterator.remove();
                    if (!Oort.this._logger.isDebugEnabled()) continue;
                    Oort.this._logger.debug("Unregistered client comet {}", (Object)clientCometInfo);
                }
                clientCometInfo = (ClientCometInfo)Oort.this._clientComets.get(oortId);
                if (clientCometInfo == null) {
                    clientCometInfo = new ClientCometInfo(oortId, oortURL, this.oortComet);
                    Oort.this._clientComets.put(oortId, clientCometInfo);
                    if (Oort.this._logger.isDebugEnabled()) {
                        Oort.this._logger.debug("Registered client comet {}", (Object)clientCometInfo);
                    }
                }
                if ((serverCometInfo = (ServerCometInfo)Oort.this._serverComets.get(oortId)) != null && serverCometInfo.getServerSession().removeAttribute(JOIN_MESSAGE_ATTRIBUTE) != null) {
                    ready = true;
                }
            }
            if (!this.cometURL.equals(oortURL)) {
                clientCometInfo.addAliasURL(this.cometURL);
                if (Oort.this._logger.isDebugEnabled()) {
                    Oort.this._logger.debug("Added comet alias {}", (Object)clientCometInfo);
                }
            }
            if (message.isSuccessful()) {
                if (serverCometInfo != null) {
                    if (Oort.this._logger.isDebugEnabled()) {
                        Oort.this._logger.debug("Server comet present {}", (Object)serverCometInfo);
                    }
                    this.oortComet.open();
                    if (ready) {
                        Oort.this.notifyCometJoined(oortId, oortURL);
                    }
                } else if (Oort.this._logger.isDebugEnabled()) {
                    Oort.this._logger.debug("Server comet not yet present");
                }
            } else {
                if (Oort.this._logger.isDebugEnabled()) {
                    Oort.this._logger.debug("Handshake failed to comet {}, message {}", (Object)this.cometURL, (Object)message);
                }
                this.oortComet.disconnect();
            }
        }
    }

    private class OortCometLoopListener
    implements ServerSession.MessageListener {
        private OortCometLoopListener() {
        }

        public boolean onMessage(ServerSession session, ServerSession sender, ServerMessage message) {
            if (session.getId().equals(sender.getId()) || Oort.this.isOort(sender)) {
                if (Oort.this._logger.isDebugEnabled()) {
                    Oort.this._logger.debug("{} --| {} {}", new Object[]{sender, session, message});
                }
                return false;
            }
            if (Oort.this._logger.isDebugEnabled()) {
                Oort.this._logger.debug("{} --> {} {}", new Object[]{sender, session, message});
            }
            return true;
        }
    }

    private class OortCometDisconnectListener
    implements ServerSession.RemoveListener {
        private OortCometDisconnectListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removed(ServerSession session, boolean timeout) {
            CometInfo serverCometInfo = null;
            Object object = Oort.this._lock;
            synchronized (object) {
                Iterator cometInfos = Oort.this._serverComets.values().iterator();
                while (cometInfos.hasNext()) {
                    ServerCometInfo info = (ServerCometInfo)cometInfos.next();
                    if (!info.getServerSession().getId().equals(session.getId())) continue;
                    cometInfos.remove();
                    serverCometInfo = info;
                    break;
                }
            }
            if (serverCometInfo != null) {
                if (Oort.this._logger.isDebugEnabled()) {
                    Oort.this._logger.debug("Disconnected from {}", (Object)serverCometInfo);
                }
                String remoteOortId = serverCometInfo.getOortId();
                String remoteOortURL = serverCometInfo.getOortURL();
                if (!timeout) {
                    OortComet oortComet;
                    Object object2 = Oort.this._lock;
                    synchronized (object2) {
                        ClientCometInfo clientCometInfo;
                        oortComet = (OortComet)((Object)Oort.this._pendingComets.remove(remoteOortURL));
                        if (oortComet == null && (clientCometInfo = (ClientCometInfo)Oort.this._clientComets.remove(remoteOortId)) != null) {
                            oortComet = clientCometInfo.getOortComet();
                        }
                    }
                    if (oortComet != null) {
                        if (Oort.this._logger.isDebugEnabled()) {
                            Oort.this._logger.debug("Disconnecting from comet {} with {}", (Object)remoteOortURL, (Object)oortComet);
                        }
                        oortComet.disconnect();
                    }
                }
                if (Oort.this.isRunning()) {
                    Oort.this.notifyCometLeft(remoteOortId, remoteOortURL);
                }
            }
        }
    }

    public static interface CometListener
    extends EventListener {
        public void cometJoined(Event var1);

        public void cometLeft(Event var1);

        public static class Event
        extends EventObject {
            private final String cometId;
            private final String cometURL;

            public Event(Oort source, String cometId, String cometURL) {
                super((Object)source);
                this.cometId = cometId;
                this.cometURL = cometURL;
            }

            public Oort getOort() {
                return (Oort)((Object)this.getSource());
            }

            public String getCometId() {
                return this.cometId;
            }

            public String getCometURL() {
                return this.cometURL;
            }
        }

        public static class Adapter
        implements CometListener {
            @Override
            public void cometJoined(Event event) {
            }

            @Override
            public void cometLeft(Event event) {
            }
        }
    }

    protected class JoinListener
    implements ServerChannel.MessageListener {
        protected JoinListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            Map data = message.getDataAsMap();
            String remoteOortId = (String)data.get(Oort.EXT_OORT_ID_FIELD);
            String remoteOortURL = (String)data.get(Oort.EXT_OORT_URL_FIELD);
            if (remoteOortURL != null && remoteOortId != null) {
                boolean ready = false;
                HashSet<String> staleComets = null;
                Iterator iterator = Oort.this._lock;
                synchronized (iterator) {
                    Iterator iterator2 = Oort.this._serverComets.values().iterator();
                    while (iterator2.hasNext()) {
                        ServerCometInfo serverCometInfo = (ServerCometInfo)iterator2.next();
                        if (!remoteOortURL.equals(serverCometInfo.getOortURL())) continue;
                        String oortId = serverCometInfo.getOortId();
                        if (remoteOortId.equals(oortId)) {
                            if (Oort.this._clientComets.containsKey(remoteOortId)) {
                                ready = true;
                                continue;
                            }
                            serverCometInfo.getServerSession().setAttribute(JOIN_MESSAGE_ATTRIBUTE, (Object)message);
                            continue;
                        }
                        iterator2.remove();
                        if (staleComets == null) {
                            staleComets = new HashSet<String>(1);
                        }
                        staleComets.add(oortId);
                    }
                }
                if (staleComets != null) {
                    for (String oortId : staleComets) {
                        Oort.this.notifyCometLeft(oortId, remoteOortURL);
                    }
                }
                if (ready) {
                    Oort.this.notifyCometJoined(remoteOortId, remoteOortURL);
                } else if (Oort.this._logger.isDebugEnabled()) {
                    Oort.this._logger.debug("Delaying comet joined: {}|{}", (Object)remoteOortId, (Object)remoteOortURL);
                }
            }
            return true;
        }
    }

    protected class CloudListener
    implements ServerChannel.MessageListener {
        protected CloudListener() {
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (!from.isLocalSession()) {
                Oort.this.joinComets((Message)message);
            }
            return true;
        }
    }

    protected class OortExtension
    extends BayeuxServer.Extension.Adapter {
        protected OortExtension() {
        }

        public boolean sendMeta(ServerSession session, ServerMessage.Mutable reply) {
            if (!"/meta/handshake".equals(reply.getChannel())) {
                return true;
            }
            if (!reply.isSuccessful()) {
                return true;
            }
            if (session == null || session.isLocalSession()) {
                return true;
            }
            Map messageExt = reply.getAssociated().getExt();
            if (messageExt == null) {
                return true;
            }
            Object messageOortExtObject = messageExt.get(Oort.EXT_OORT_FIELD);
            if (messageOortExtObject instanceof Map) {
                Map messageOortExt = (Map)messageOortExtObject;
                String remoteOortURL = (String)messageOortExt.get(Oort.EXT_OORT_URL_FIELD);
                String cometURL = (String)messageOortExt.get(Oort.EXT_COMET_URL_FIELD);
                String remoteOortId = (String)messageOortExt.get(Oort.EXT_OORT_ID_FIELD);
                session.setAttribute(Oort.COMET_URL_ATTRIBUTE, (Object)remoteOortURL);
                if (Oort.this._id.equals(remoteOortId)) {
                    if (Oort.this._logger.isDebugEnabled()) {
                        Oort.this._logger.debug("Detected self connect from {} to {}, disconnecting", (Object)remoteOortURL, (Object)cometURL);
                    }
                    this.disconnect(session, reply);
                } else {
                    Map replyExt = reply.getExt(true);
                    HashMap<String, String> replyOortExt = new HashMap<String, String>(2);
                    replyExt.put(Oort.EXT_OORT_FIELD, replyOortExt);
                    replyOortExt.put(Oort.EXT_OORT_URL_FIELD, Oort.this.getURL());
                    replyOortExt.put(Oort.EXT_OORT_ID_FIELD, Oort.this.getId());
                    boolean connectBack = Oort.this.incomingCometHandshake(messageOortExt, session);
                    if (connectBack) {
                        String cometAliasURL = (String)messageOortExt.get(Oort.EXT_OORT_ALIAS_URL_FIELD);
                        if (cometAliasURL != null && Oort.this.findComet(cometAliasURL) != null) {
                            if (Oort.this._logger.isDebugEnabled()) {
                                Oort.this._logger.debug("Comet {} exists with alias {}, avoiding to establish connection", (Object)remoteOortURL, (Object)cometAliasURL);
                            }
                        } else {
                            if (Oort.this._logger.isDebugEnabled()) {
                                Oort.this._logger.debug("Comet {} is unknown, establishing connection", (Object)remoteOortURL);
                            }
                            Oort.this.observeComet(remoteOortURL, cometURL);
                        }
                    } else {
                        this.disconnect(session, reply);
                    }
                }
            }
            return true;
        }

        private void disconnect(ServerSession session, ServerMessage.Mutable message) {
            Oort.this._bayeux.removeSession(session);
            message.setSuccessful(false);
            Map advice = message.getAdvice(true);
            advice.put("reconnect", "none");
        }
    }
}

