/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.ClientTransport;
import org.cometd.oort.Oort;

public class OortComet
extends BayeuxClient {
    private final ConcurrentMap<String, ClientSessionChannel.MessageListener> _subscriptions = new ConcurrentHashMap<String, ClientSessionChannel.MessageListener>();
    private final Oort _oort;
    private final String _cometURL;
    private volatile boolean _subscriptionsAllowed;

    public OortComet(Oort oort, String cometURL, ScheduledExecutorService scheduler, ClientTransport transport, ClientTransport ... transports) {
        super(cometURL, scheduler, transport, transports);
        this._oort = oort;
        this._cometURL = cometURL;
    }

    protected void subscribe(Set<String> observedChannels) {
        if (!this._subscriptionsAllowed) {
            return;
        }
        for (String channel : observedChannels) {
            ClientSessionChannel.MessageListener listener;
            ClientSessionChannel.MessageListener existing;
            if (this._subscriptions.containsKey(channel) || (existing = this._subscriptions.putIfAbsent(channel, listener = new ClientSessionChannel.MessageListener(){

                public void onMessage(ClientSessionChannel channel, Message message) {
                    if (OortComet.this.logger.isDebugEnabled()) {
                        OortComet.this.logger.debug("Republishing message {} from {}", (Object)message, (Object)OortComet.this._cometURL);
                    }
                    OortComet.this._oort.getOortSession().getChannel(message.getChannel()).publish((Object)message);
                }
            })) != null) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Subscribing to messages on {} from {}", (Object)channel, (Object)this._cometURL);
            }
            this.getChannel(channel).subscribe(listener);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Subscriptions to messages on {} from {}", this._subscriptions, (Object)this._cometURL);
        }
    }

    protected void unsubscribe(String channel) {
        ClientSessionChannel.MessageListener listener = (ClientSessionChannel.MessageListener)this._subscriptions.remove(channel);
        if (listener != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unsubscribing to messages on {} from {}", (Object)channel, (Object)this._cometURL);
            }
            this.getChannel(channel).unsubscribe(listener);
        }
    }

    protected void clearSubscriptions() {
        for (String channel : this._oort.getObservedChannels()) {
            this.unsubscribe(channel);
        }
    }

    void open(final ClientSessionChannel.MessageListener callback) {
        this.batch(new Runnable(){

            @Override
            public void run() {
                OortComet.this.getChannel("/oort/cloud").subscribe(new ClientSessionChannel.MessageListener(){

                    public void onMessage(ClientSessionChannel channel, Message message) {
                        if (message.isSuccessful()) {
                            OortComet.this._oort.joinComets(message);
                        }
                    }
                });
                OortComet.this.clearSubscriptions();
                OortComet.this._subscriptionsAllowed = true;
                Set<String> channels = OortComet.this._oort.getObservedChannels();
                if (OortComet.this.logger.isDebugEnabled()) {
                    OortComet.this.logger.debug("Observing channels {}", channels);
                }
                OortComet.this.subscribe(channels);
                OortComet.this.getChannel("/oort/cloud").publish(new ArrayList<String>(OortComet.this._oort.getKnownComets()));
                HashMap<String, String> data = new HashMap<String, String>(2);
                data.put("oortId", OortComet.this._oort.getId());
                data.put("oortURL", OortComet.this._oort.getURL());
                if (OortComet.this.logger.isDebugEnabled()) {
                    OortComet.this.logger.debug("Sending join data {}", data);
                }
                OortComet.this.getChannel("/service/oort").publish(data, callback);
            }
        });
    }

    public String toString() {
        return String.format("%s[%s]", super.toString(), this._cometURL);
    }
}

