/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.List;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.common.BufferingJSONAsyncParser;
import org.cometd.common.JSONContext;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.CometDRequest;
import org.cometd.server.HttpException;
import org.cometd.server.JSONContextServer;
import org.cometd.server.http.AbstractHttpTransport;
import org.cometd.server.http.TransportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONHttpTransport
extends AbstractHttpTransport {
    public static final String NAME = "long-polling";
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONHttpTransport.class);
    private static final String PREFIX = "long-polling.json";

    public JSONHttpTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public boolean accept(CometDRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod());
    }

    @Override
    protected void handle(TransportContext context) {
        AbstractReader reader;
        CometDRequest request = context.request();
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if ("UTF-8".equalsIgnoreCase(encoding)) {
            reader = new UTF8Reader(context);
        } else {
            Charset charset = Charset.forName(encoding);
            reader = new CharsetReader(context, charset);
        }
        CometDRequest.Input input = request.getInput();
        input.demand(reader::read);
    }

    private void process(TransportContext context, String json) {
        try {
            List<ServerMessage.Mutable> messages = this.parseMessages(json);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Parsed {} messages", (Object)(messages == null ? -1 : messages.size()));
            }
            this.process(context, messages == null ? List.of() : messages);
        }
        catch (ParseException x) {
            LOGGER.warn("Could not parse JSON: {}", (Object)x.getMessage(), (Object)x);
            context.promise().fail((Throwable)new HttpException(400, x.getCause()));
        }
        catch (Throwable x) {
            context.promise().fail(x);
        }
    }

    private void process(TransportContext context, List<ServerMessage.Mutable> messages) {
        try {
            this.processMessages(context, messages == null ? List.of() : messages);
        }
        catch (Throwable x) {
            context.promise().fail(x);
        }
    }

    private class UTF8Reader
    extends AbstractReader {
        private final JSONContext.AsyncParser parser;

        private UTF8Reader(TransportContext context) {
            super(context);
            JSONContextServer jsonContext = JSONHttpTransport.this.getJSONContextServer();
            JSONContext.AsyncParser asyncParser = jsonContext.newAsyncParser();
            if (asyncParser == null) {
                asyncParser = new BufferingJSONAsyncParser((JSONContext)jsonContext);
            }
            this.parser = asyncParser;
        }

        @Override
        protected void onChunk(CometDRequest.Input.Chunk chunk) {
            this.parser.parse(chunk.byteBuffer());
        }

        @Override
        protected void onEOF() {
            List messages = (List)this.parser.complete();
            this.finish(messages);
        }

        private void finish(List<ServerMessage.Mutable> messages) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Asynchronous read end from {}: {}", (Object)this.context().request().getInput(), messages);
            }
            JSONHttpTransport.this.process(this.context(), messages);
        }
    }

    private class CharsetReader
    extends AbstractReader {
        private final Charset charset;
        private ByteBuffer aggregator;

        private CharsetReader(TransportContext context, Charset charset) {
            super(context);
            this.aggregator = ByteBuffer.allocateDirect(256);
            this.charset = charset;
        }

        @Override
        protected void onChunk(CometDRequest.Input.Chunk chunk) {
            ByteBuffer byteBuffer = chunk.byteBuffer();
            int remaining = byteBuffer.remaining();
            if (this.aggregator.remaining() < remaining) {
                ByteBuffer newAggregator = ByteBuffer.allocateDirect(this.aggregator.position() + 2 * remaining);
                newAggregator.put(this.aggregator.flip());
                this.aggregator = newAggregator;
            }
            this.aggregator.put(byteBuffer);
        }

        @Override
        protected void onEOF() {
            String json = this.charset.decode(this.aggregator.flip()).toString();
            this.finish(json);
        }

        private void finish(String json) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Asynchronous read end from {}: {}", (Object)this.context().request().getInput(), (Object)json);
            }
            JSONHttpTransport.this.process(this.context(), json);
        }
    }

    private abstract class AbstractReader {
        private final TransportContext context;
        private int total;

        private AbstractReader(TransportContext context) {
            this.context = context;
        }

        protected TransportContext context() {
            return this.context;
        }

        private void read() {
            try {
                this.onDataAvailable();
            }
            catch (Throwable x) {
                this.context().promise().fail(x);
            }
        }

        private void onDataAvailable() throws IOException {
            CometDRequest.Input.Chunk chunk;
            CometDRequest.Input input = this.context.request().getInput();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Asynchronous read start from {}", (Object)input);
            }
            long maxMessageSize = JSONHttpTransport.this.getMaxMessageSize();
            do {
                int read;
                if ((chunk = input.read()) == null) {
                    input.demand(this::read);
                    return;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Asynchronous read {} from {}", (Object)chunk, (Object)input);
                }
                if ((read = chunk.byteBuffer().remaining()) > 0) {
                    if (maxMessageSize > 0L) {
                        this.total += read;
                        if ((long)this.total > maxMessageSize) {
                            throw new IOException("Max message size " + maxMessageSize + " exceeded");
                        }
                    }
                    this.processChunk(chunk);
                }
                chunk.release();
            } while (!chunk.isLast());
            this.processEOF();
        }

        private void processChunk(CometDRequest.Input.Chunk chunk) {
            try {
                this.onChunk(chunk);
            }
            catch (Throwable x) {
                throw new HttpException(400, x);
            }
        }

        private void processEOF() {
            try {
                this.onEOF();
            }
            catch (Throwable x) {
                throw new HttpException(400, x);
            }
        }

        protected abstract void onChunk(CometDRequest.Input.Chunk var1);

        protected abstract void onEOF();
    }
}

