/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.AbstractRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;

public class ArtifactRepositoryMetadata
extends AbstractRepositoryMetadata {
    private Artifact artifact;

    public ArtifactRepositoryMetadata(Artifact artifact) {
        this(artifact, null);
    }

    public ArtifactRepositoryMetadata(Artifact artifact, Versioning versioning) {
        super(ArtifactRepositoryMetadata.createMetadata(artifact, versioning));
        this.artifact = artifact;
    }

    public boolean storedInGroupDirectory() {
        return false;
    }

    public boolean storedInArtifactVersionDirectory() {
        return false;
    }

    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    public String getBaseVersion() {
        return null;
    }

    public Object getKey() {
        return "artifact " + this.artifact.getGroupId() + ":" + this.artifact.getArtifactId();
    }

    public boolean isSnapshot() {
        return false;
    }

    public int getNature() {
        if (this.artifact.getVersion() != null) {
            return this.artifact.isSnapshot() ? 2 : 1;
        }
        VersionRange range = this.artifact.getVersionRange();
        if (range != null) {
            for (Restriction restriction : range.getRestrictions()) {
                if (!this.isSnapshot(restriction.getLowerBound()) && !this.isSnapshot(restriction.getUpperBound())) continue;
                return 3;
            }
        }
        return 1;
    }

    private boolean isSnapshot(ArtifactVersion version) {
        return version != null && ArtifactUtils.isSnapshot(version.getQualifier());
    }

    public ArtifactRepository getRepository() {
        return null;
    }

    public void setRepository(ArtifactRepository remoteRepository) {
    }
}

