/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.ref;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.TypeAndClassifier;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;
import org.commonjava.maven.atlas.ident.version.SingleVersion;
import org.commonjava.maven.atlas.ident.version.VersionSpec;

public class ArtifactRef
extends ProjectVersionRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TypeAndClassifier tc;
    private final boolean optional;

    public ArtifactRef(String groupId, String artifactId, VersionSpec version, String type, String classifier, boolean optional) {
        super(groupId, artifactId, version);
        this.optional = optional;
        this.tc = new TypeAndClassifier(type, classifier);
    }

    public ArtifactRef(ProjectVersionRef ref, String type, String classifier, boolean optional) {
        super(ref.getGroupId(), ref.getArtifactId(), ref.getVersionSpecRaw(), ref.getVersionStringRaw());
        this.optional = optional;
        this.tc = new TypeAndClassifier(type, classifier);
    }

    public ArtifactRef(ProjectVersionRef ref, TypeAndClassifier tc, boolean optional) {
        super(ref.getGroupId(), ref.getArtifactId(), ref.getVersionSpecRaw(), ref.getVersionStringRaw());
        this.tc = tc;
        this.optional = optional;
    }

    public ArtifactRef(String groupId, String artifactId, String versionSpec, String type, String classifier, boolean optional) throws InvalidVersionSpecificationException {
        super(groupId, artifactId, versionSpec);
        this.tc = new TypeAndClassifier(type, classifier);
        this.optional = optional;
    }

    @Override
    public String toString() {
        return String.format("%s:%s:%s:%s%s", this.getGroupId(), this.getArtifactId(), this.getType(), this.getVersionString(), this.getClassifier() == null ? "" : ":" + this.getClassifier());
    }

    public static ArtifactRef parse(String spec) {
        String[] parts = spec.split(":");
        if (parts.length < 3 || StringUtils.isEmpty(parts[0]) || StringUtils.isEmpty(parts[1]) || StringUtils.isEmpty(parts[2])) {
            throw new InvalidRefException("ArtifactRef must contain AT LEAST non-empty groupId, artifactId, AND version. (Given: '" + spec + "')", new Object[0]);
        }
        String g = parts[0];
        String a = parts[1];
        String v = parts[2];
        String t = "pom";
        String c = null;
        if (parts.length > 3) {
            t = v;
            v = parts[3];
            if (parts.length > 4) {
                c = parts[4];
            }
        }
        return new ArtifactRef(g, a, v, t, c, false);
    }

    @Override
    protected ProjectVersionRef newRef(String groupId, String artifactId, SingleVersion version) {
        return new ArtifactRef(groupId, artifactId, version, this.tc.getType(), this.tc.getClassifier(), this.optional);
    }

    public String getType() {
        return this.tc.getType();
    }

    public String getClassifier() {
        return this.tc.getClassifier();
    }

    public TypeAndClassifier getTypeAndClassifier() {
        return this.tc;
    }

    public ArtifactRef setOptional(boolean optional) {
        if (this.optional == optional) {
            return this;
        }
        return new ArtifactRef(this, this.getType(), this.getClassifier(), optional);
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.tc == null ? 0 : this.tc.hashCode());
        result = 31 * result + Boolean.valueOf(this.optional).hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactRef other = (ArtifactRef)obj;
        return this.artifactFieldsEqual(other);
    }

    private boolean artifactFieldsEqual(ArtifactRef other) {
        return !(this.tc == null ? other.tc != null : !this.tc.equals(other.tc));
    }

    @Override
    public boolean versionlessEquals(ProjectVersionRef other) {
        if (!super.versionlessEquals(other)) {
            return false;
        }
        if (!(other instanceof ArtifactRef)) {
            return this.artifactFieldsEqual(new ArtifactRef(other, "pom", null, false));
        }
        return this.artifactFieldsEqual((ArtifactRef)other);
    }
}

