/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.ref;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.TypeAndClassifier;
import org.commonjava.maven.atlas.ident.ref.VersionlessArtifactRef;

public class ProjectRef
implements Serializable,
Comparable<ProjectRef> {
    private static final long serialVersionUID = 1L;
    private final String groupId;
    private final String artifactId;

    public ProjectRef(String groupId, String artifactId) {
        if (StringUtils.isEmpty(groupId) || StringUtils.isEmpty(artifactId)) {
            throw new InvalidRefException("ProjectId must contain non-empty groupId AND artifactId. (Given: '" + groupId + "':'" + artifactId + "')", new Object[0]);
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public static ProjectRef parse(String ga) {
        String[] parts = ga.split(":");
        if (parts.length < 2 || StringUtils.isEmpty(parts[0]) || StringUtils.isEmpty(parts[1])) {
            throw new InvalidRefException("ProjectRef must contain non-empty groupId AND artifactId. (Given: '" + ga + "')", new Object[0]);
        }
        return new ProjectRef(parts[0], parts[1]);
    }

    public final String getGroupId() {
        return this.groupId;
    }

    public final String getArtifactId() {
        return this.artifactId;
    }

    public ProjectRef asProjectRef() {
        return ProjectRef.class.equals(this.getClass()) ? this : new ProjectRef(this.getGroupId(), this.getArtifactId());
    }

    public VersionlessArtifactRef asVersionlessPomArtifact() {
        return this.asVersionlessArtifactRef("pom", null, false);
    }

    public VersionlessArtifactRef asVersionlessJarArtifact() {
        return this.asVersionlessArtifactRef("jar", null, false);
    }

    public VersionlessArtifactRef asVersionlessArtifactRef(String type, String classifier) {
        return this.asVersionlessArtifactRef(type, classifier, false);
    }

    public VersionlessArtifactRef asVersionlessArtifactRef(String type, String classifier, boolean optional) {
        return new VersionlessArtifactRef(this, type, classifier, optional);
    }

    public VersionlessArtifactRef asVersionlessArtifactRef(TypeAndClassifier tc) {
        return this.asVersionlessArtifactRef(tc, false);
    }

    public VersionlessArtifactRef asVersionlessArtifactRef(TypeAndClassifier tc, boolean optional) {
        return new VersionlessArtifactRef(this, tc, optional);
    }

    public String toString() {
        return String.format("%s:%s", this.groupId, this.artifactId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.groupId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectRef other = (ProjectRef)obj;
        if (!this.artifactId.equals(other.artifactId)) {
            return false;
        }
        return this.groupId.equals(other.groupId);
    }

    @Override
    public int compareTo(ProjectRef o) {
        int comp = this.groupId.compareTo(o.groupId);
        if (comp == 0) {
            comp = this.artifactId.compareTo(o.artifactId);
        }
        return 0;
    }

    public boolean matches(ProjectRef ref) {
        if (this.equals(ref)) {
            return true;
        }
        String gidPattern = this.toWildcard(this.getGroupId());
        if (!ref.getGroupId().matches(gidPattern)) {
            return false;
        }
        String aidPattern = this.toWildcard(this.getArtifactId());
        return ref.getArtifactId().matches(aidPattern);
    }

    private String toWildcard(String val) {
        return val.replaceAll("\\.", "\\.").replaceAll("\\*", ".*");
    }
}

