/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.ref;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.TypeAndClassifier;
import org.commonjava.maven.atlas.ident.ref.VersionedRef;
import org.commonjava.maven.atlas.ident.util.VersionUtils;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;
import org.commonjava.maven.atlas.ident.version.SingleVersion;
import org.commonjava.maven.atlas.ident.version.VersionSpec;

public class ProjectVersionRef
extends ProjectRef
implements VersionedRef<ProjectVersionRef>,
Serializable {
    private static final long serialVersionUID = 1L;
    private VersionSpec versionSpec;
    private String versionString;

    public ProjectVersionRef(ProjectRef ref, VersionSpec versionSpec) {
        this(ref.getGroupId(), ref.getArtifactId(), versionSpec, null);
    }

    public ProjectVersionRef(ProjectRef ref, String versionSpec) throws InvalidVersionSpecificationException {
        this(ref.getGroupId(), ref.getArtifactId(), versionSpec);
    }

    ProjectVersionRef(String groupId, String artifactId, VersionSpec versionSpec, String versionString) {
        super(groupId, artifactId);
        if (versionSpec == null && versionString == null) {
            throw new InvalidRefException("Version spec AND string cannot both be null for '" + groupId + ":" + artifactId + "'", new Object[0]);
        }
        this.versionString = versionString;
        this.versionSpec = versionSpec;
    }

    public ProjectVersionRef(String groupId, String artifactId, VersionSpec versionSpec) {
        this(groupId, artifactId, versionSpec, null);
    }

    public ProjectVersionRef(String groupId, String artifactId, String versionString) throws InvalidVersionSpecificationException {
        this(groupId, artifactId, null, versionString);
    }

    public static ProjectVersionRef parse(String gav) {
        String[] parts = gav.split(":");
        if (parts.length < 3 || StringUtils.isEmpty(parts[0]) || StringUtils.isEmpty(parts[1]) || StringUtils.isEmpty(parts[2])) {
            throw new InvalidRefException("ProjectVersionRef must contain non-empty groupId, artifactId, AND version. (Given: '" + gav + "')", new Object[0]);
        }
        return new ProjectVersionRef(parts[0], parts[1], parts[2]);
    }

    public ProjectVersionRef asProjectVersionRef() {
        return ProjectVersionRef.class.equals(this.getClass()) ? this : new ProjectVersionRef(this.getGroupId(), this.getArtifactId(), this.getVersionSpecRaw(), this.getVersionStringRaw());
    }

    public ArtifactRef asPomArtifact() {
        return this.asArtifactRef("pom", null, false);
    }

    public ArtifactRef asJarArtifact() {
        return this.asArtifactRef("jar", null, false);
    }

    public ArtifactRef asArtifactRef(String type, String classifier) {
        return this.asArtifactRef(type, classifier, false);
    }

    public ArtifactRef asArtifactRef(String type, String classifier, boolean optional) {
        return new ArtifactRef(this, type, classifier, optional);
    }

    public ArtifactRef asArtifactRef(TypeAndClassifier tc) {
        return this.asArtifactRef(tc, false);
    }

    public ArtifactRef asArtifactRef(TypeAndClassifier tc, boolean optional) {
        return new ArtifactRef(this, tc, optional);
    }

    VersionSpec getVersionSpecRaw() {
        return this.versionSpec;
    }

    String getVersionStringRaw() {
        return this.versionString;
    }

    @Override
    public boolean isRelease() {
        return this.getVersionSpec().isRelease();
    }

    @Override
    public boolean isSpecificVersion() {
        return this.getVersionSpec().isSingle();
    }

    @Override
    public boolean matchesVersion(SingleVersion version) {
        return this.getVersionSpec().contains(version);
    }

    @Override
    public ProjectVersionRef selectVersion(String version) {
        SingleVersion single = VersionUtils.createSingleVersion(version);
        return this.selectVersion(single, false);
    }

    @Override
    public ProjectVersionRef selectVersion(String version, boolean force) {
        SingleVersion single = VersionUtils.createSingleVersion(version);
        return this.selectVersion(single, force);
    }

    @Override
    public ProjectVersionRef selectVersion(SingleVersion version) {
        return this.selectVersion(version, false);
    }

    @Override
    public ProjectVersionRef selectVersion(SingleVersion version, boolean force) {
        VersionSpec versionSpec = this.getVersionSpec();
        if (versionSpec.equals(version)) {
            return this;
        }
        if (!force && !versionSpec.contains(version)) {
            throw new IllegalArgumentException("Specified version: " + version.renderStandard() + " is not contained in spec: " + versionSpec.renderStandard());
        }
        return this.newRef(this.getGroupId(), this.getArtifactId(), version);
    }

    protected ProjectVersionRef newRef(String groupId, String artifactId, SingleVersion version) {
        return new ProjectVersionRef(groupId, artifactId, version);
    }

    @Override
    public VersionSpec getVersionSpec() {
        if (this.versionSpec == null) {
            this.versionSpec = VersionUtils.createFromSpec(this.versionString);
        }
        return this.versionSpec;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getVersionString() == null ? 0 : this.getVersionString().hashCode());
        return result;
    }

    public boolean versionlessEquals(ProjectVersionRef other) {
        if (this == other) {
            return true;
        }
        return super.equals(other);
    }

    @Override
    public boolean equals(Object obj) {
        boolean result;
        block11: {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectVersionRef other = (ProjectVersionRef)obj;
            result = true;
            try {
                if (this.getVersionSpec() == null) {
                    if (other.getVersionSpec() != null) {
                        result = false;
                    }
                } else if (!this.getVersionSpec().equals(other.getVersionSpec())) {
                    result = false;
                }
            }
            catch (InvalidVersionSpecificationException e) {
                if (this.getVersionString() == null) {
                    if (other.getVersionString() != null) {
                        result = false;
                    }
                }
                if (this.getVersionString().equals(other.getVersionString())) break block11;
                result = false;
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return String.format("%s:%s:%s", this.getGroupId(), this.getArtifactId(), this.getVersionString());
    }

    @Override
    public boolean isCompound() {
        return !this.getVersionSpec().isSingle();
    }

    @Override
    public boolean isSnapshot() {
        return this.getVersionSpec().isSnapshot();
    }

    @Override
    public String getVersionString() {
        if (this.versionString == null) {
            this.versionString = this.versionSpec.renderStandard();
        }
        return this.versionString;
    }

    public boolean isVariableVersion() {
        return this.isCompound() || this.isSpecificVersion() && ((SingleVersion)this.getVersionSpec()).isLocalSnapshot();
    }

    @Override
    public int compareTo(ProjectRef o) {
        int comp = super.compareTo(o);
        if (comp == 0 && o instanceof ProjectVersionRef) {
            ProjectVersionRef or = (ProjectVersionRef)o;
            comp = this.getVersionString().compareTo(or.getVersionString());
        }
        return comp;
    }
}

