/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.ref;

import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.TypeAndClassifier;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;

public class VersionlessArtifactRef
extends ProjectRef {
    private static final long serialVersionUID = 1L;
    private final TypeAndClassifier tc;
    private final boolean optional;

    public VersionlessArtifactRef(ArtifactRef ref) {
        super(ref.getGroupId(), ref.getArtifactId());
        this.optional = ref.isOptional();
        this.tc = ref.getTypeAndClassifier();
    }

    public VersionlessArtifactRef(ProjectRef ref, String type, String classifier, boolean optional) {
        super(ref.getGroupId(), ref.getArtifactId());
        this.optional = optional;
        this.tc = new TypeAndClassifier(type, classifier);
    }

    public VersionlessArtifactRef(ProjectRef ref, TypeAndClassifier tc, boolean optional) {
        super(ref.getGroupId(), ref.getArtifactId());
        this.tc = tc == null ? new TypeAndClassifier() : tc;
        this.optional = optional;
    }

    public VersionlessArtifactRef(String groupId, String artifactId, String type, String classifier, boolean optional) throws InvalidVersionSpecificationException {
        super(groupId, artifactId);
        this.tc = new TypeAndClassifier(type, classifier);
        this.optional = optional;
    }

    @Override
    public String toString() {
        return String.format("%s:%s:%s", this.getGroupId(), this.getArtifactId(), this.getTypeAndClassifier());
    }

    public static VersionlessArtifactRef parse(String spec) {
        String[] parts = spec.split(":");
        if (parts.length < 2 || StringUtils.isEmpty(parts[0]) || StringUtils.isEmpty(parts[1])) {
            throw new InvalidRefException("VersionlessArtifactRef must contain AT LEAST non-empty groupId and artifactId. (Given: '" + spec + "')", new Object[0]);
        }
        String g = parts[0];
        String a = parts[1];
        String t = "pom";
        String c = null;
        if (parts.length > 2) {
            t = parts[2];
            if (parts.length > 3) {
                c = parts[3];
                if (parts.length > 4) {
                    c = parts[4];
                }
            }
        }
        return new VersionlessArtifactRef(g, a, t, c, false);
    }

    public String getType() {
        return this.tc.getType();
    }

    public String getClassifier() {
        return this.tc.getClassifier();
    }

    public TypeAndClassifier getTypeAndClassifier() {
        return this.tc;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.optional ? 1231 : 1237);
        result = 31 * result + (this.tc == null ? 0 : this.tc.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionlessArtifactRef other = (VersionlessArtifactRef)obj;
        if (this.optional != other.optional) {
            return false;
        }
        return !(this.tc == null ? other.tc != null : !this.tc.equals(other.tc));
    }

    @Override
    public VersionlessArtifactRef asVersionlessPomArtifact() {
        return this.asVersionlessArtifactRef("pom", null, false);
    }

    @Override
    public VersionlessArtifactRef asVersionlessJarArtifact() {
        return this.asVersionlessArtifactRef("jar", null, false);
    }

    @Override
    public VersionlessArtifactRef asVersionlessArtifactRef(String type, String classifier) {
        return this.asVersionlessArtifactRef(type, classifier, false);
    }

    @Override
    public VersionlessArtifactRef asVersionlessArtifactRef(String type, String classifier, boolean optional) {
        TypeAndClassifier tc = new TypeAndClassifier(type, classifier);
        if (VersionlessArtifactRef.class.equals(this.getClass()) && this.tc.equals(tc) && this.optional == optional) {
            return this;
        }
        return super.asVersionlessArtifactRef(type, classifier, optional);
    }

    @Override
    public VersionlessArtifactRef asVersionlessArtifactRef(TypeAndClassifier tc) {
        return this.asVersionlessArtifactRef(tc, false);
    }

    @Override
    public VersionlessArtifactRef asVersionlessArtifactRef(TypeAndClassifier tc, boolean optional) {
        if (VersionlessArtifactRef.class.equals(this.getClass()) && this.tc.equals(tc) && this.optional == optional) {
            return this;
        }
        return super.asVersionlessArtifactRef(tc, optional);
    }
}

