/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.util;

import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;

public final class IdentityUtils {
    private IdentityUtils() {
    }

    public static ArtifactRef artifact(String groupId, String artifactId, String version) throws InvalidVersionSpecificationException {
        return new ArtifactRef(IdentityUtils.projectVersion(groupId, artifactId, version), null, null, false);
    }

    public static ArtifactRef artifact(ProjectVersionRef ref) throws InvalidVersionSpecificationException {
        return new ArtifactRef(ref, null, null, false);
    }

    public static ArtifactRef artifact(String groupId, String artifactId, String version, String type, String classifier, boolean optional) throws InvalidVersionSpecificationException {
        return new ArtifactRef(IdentityUtils.projectVersion(groupId, artifactId, version), type, classifier, optional);
    }

    public static ArtifactRef artifact(ProjectVersionRef dep, String type, String classifier, boolean optional) {
        return new ArtifactRef(dep, type, classifier, optional);
    }

    public static ProjectVersionRef projectVersion(String src) {
        String[] parts = src.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid: '" + src + "'. Must contain exactly three fields separated by ':'");
        }
        try {
            return new ProjectVersionRef(parts[0], parts[1], parts[2]);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Invalid: '" + src + "'. Version: '" + parts[2] + "' is invalid: " + e.getMessage(), e);
        }
    }

    public static ProjectVersionRef projectVersion(String groupId, String artifactId, String version) throws InvalidVersionSpecificationException {
        return new ProjectVersionRef(groupId, artifactId, version);
    }

    public static ProjectRef project(String src) {
        String[] parts = src.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid: '" + src + "'. Must contain at least two fields separated by ':'");
        }
        return new ProjectRef(parts[0], parts[1]);
    }

    public static ProjectRef project(String groupId, String artifactId) throws InvalidVersionSpecificationException {
        return new ProjectRef(groupId, artifactId);
    }
}

