/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;
import org.commonjava.maven.atlas.ident.version.VersionSpec;
import org.commonjava.maven.atlas.ident.version.VersionSpecComparisons;
import org.commonjava.maven.atlas.ident.version.part.NumericPart;
import org.commonjava.maven.atlas.ident.version.part.SeparatorPart;
import org.commonjava.maven.atlas.ident.version.part.SnapshotPart;
import org.commonjava.maven.atlas.ident.version.part.StringPart;
import org.commonjava.maven.atlas.ident.version.part.VersionPart;
import org.commonjava.maven.atlas.ident.version.part.VersionPartSeparator;
import org.commonjava.maven.atlas.ident.version.part.VersionPhrase;

public class SingleVersion
implements VersionSpec,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<VersionPhrase> phrases;
    private final String rawExpression;

    private SingleVersion(List<VersionPhrase> phrases) {
        this.phrases = new ArrayList<VersionPhrase>(phrases);
        this.rawExpression = StringUtils.join(phrases, "");
    }

    public SingleVersion(String rawExpression, VersionPart ... parts) throws InvalidVersionSpecificationException {
        this(rawExpression, Arrays.asList(parts));
    }

    public SingleVersion(String rawExpression, List<VersionPart> parts) throws InvalidVersionSpecificationException {
        this.rawExpression = rawExpression;
        this.phrases = this.parsePhrases(parts);
        this.validatePhrases();
    }

    private void validatePhrases() throws InvalidVersionSpecificationException {
    }

    private List<VersionPhrase> parsePhrases(List<VersionPart> p) throws InvalidVersionSpecificationException {
        List<VersionPart> parts = this.normalize(p);
        this.validate(parts);
        ArrayList<VersionPhrase> phrases = new ArrayList<VersionPhrase>();
        VersionPartSeparator currentPhraseSep = VersionPartSeparator.BLANK;
        ArrayList<VersionPart> current = new ArrayList<VersionPart>();
        for (int i = 0; i < parts.size(); ++i) {
            VersionPart next;
            VersionPart prev = i == 0 ? null : parts.get(i - 1);
            VersionPart part = parts.get(i);
            VersionPart versionPart = next = i >= parts.size() - 1 ? null : parts.get(i + 1);
            if (part instanceof SeparatorPart && VersionPartSeparator.DASH == ((SeparatorPart)part).getValue()) {
                if (prev != null && !(prev instanceof StringPart)) {
                    try {
                        phrases.add(new VersionPhrase(currentPhraseSep, current));
                    }
                    catch (InvalidVersionSpecificationException e) {
                        // empty catch block
                    }
                    current = new ArrayList();
                    currentPhraseSep = VersionPartSeparator.DASH;
                } else {
                    current.add(part);
                }
                if (next == null) continue;
                current.add(next);
                ++i;
                continue;
            }
            if (!(!(part instanceof SnapshotPart) && !(part instanceof StringPart) || prev == null || prev instanceof SeparatorPart && ((SeparatorPart)prev).getValue() == VersionPartSeparator.DASH)) {
                VersionPartSeparator sep = null;
                sep = prev instanceof SeparatorPart ? ((SeparatorPart)current.remove(current.size() - 1)).getValue() : VersionPartSeparator.BLANK;
                try {
                    phrases.add(new VersionPhrase(currentPhraseSep, current));
                }
                catch (InvalidVersionSpecificationException e) {
                    // empty catch block
                }
                current = new ArrayList();
                current.add(part);
                currentPhraseSep = sep;
                continue;
            }
            current.add(part);
        }
        if (!current.isEmpty()) {
            phrases.add(new VersionPhrase(currentPhraseSep, current));
        }
        return phrases;
    }

    private List<VersionPart> normalize(List<VersionPart> parts) {
        VersionPart prev = null;
        ArrayList<VersionPart> result = new ArrayList<VersionPart>(parts.size());
        for (int i = 0; i < parts.size(); ++i) {
            VersionPart part = parts.get(i);
            if (part instanceof SnapshotPart && (parts.size() == 1 || i < parts.size() - 1)) {
                SnapshotPart snap = (SnapshotPart)part;
                if (snap.isLocalSnapshot()) {
                    StringPart sub = new StringPart(((SnapshotPart)part).getLiteral());
                    result.add(sub);
                    prev = sub;
                    continue;
                }
                StringTokenizer st = new StringTokenizer(snap.getLiteral(), ".-", true);
                int idx = 0;
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (idx % 2 == 1) {
                        SeparatorPart sep = new SeparatorPart(VersionPartSeparator.find(tok));
                        result.add(sep);
                        prev = sep;
                    } else {
                        NumericPart np = new NumericPart(tok);
                        result.add(np);
                        prev = np;
                    }
                    ++idx;
                }
                continue;
            }
            if (prev != null && !(prev instanceof SeparatorPart) && !(part instanceof SeparatorPart)) {
                SeparatorPart sep = new SeparatorPart(VersionPartSeparator.BLANK);
                result.add(sep);
                prev = sep;
                --i;
                continue;
            }
            result.add(part);
            prev = part;
        }
        if (result.get(result.size() - 1) instanceof SeparatorPart) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    private void validate(List<VersionPart> parts) throws InvalidVersionSpecificationException {
        if (parts.isEmpty()) {
            throw new InvalidVersionSpecificationException(this.rawExpression, "Empty versions are not allowed", new Object[0]);
        }
        if (parts.size() == 1 && parts.get(0) instanceof SnapshotPart) {
            throw new InvalidVersionSpecificationException(this.rawExpression, "Cannot have a version of 'SNAPSHOT'; version must be releasable by dropping the snapshot marker!", new Object[0]);
        }
        for (VersionPart part : parts) {
            if (part == parts.get(parts.size() - 1) || !(part instanceof SnapshotPart)) continue;
            throw new InvalidVersionSpecificationException(this.rawExpression, "Snapshot marker MUST appear at the end of the version", new Object[0]);
        }
    }

    public SingleVersion getBaseVersion() {
        if (this.isRelease()) {
            return this;
        }
        return new SingleVersion(this.phrases.subList(0, this.phrases.size() - 1));
    }

    @Override
    public String renderStandard() {
        return this.rawExpression;
    }

    @Override
    public boolean contains(VersionSpec version) {
        if (version.isSingle()) {
            SingleVersion sv = version.getSingleVersion();
            if (!this.getBaseVersion().equals(sv.getBaseVersion())) {
                return false;
            }
            if (this.isLocalSnapshot()) {
                return version.isSnapshot();
            }
            return !sv.isLocalSnapshot();
        }
        return false;
    }

    @Override
    public int compareTo(VersionSpec other) {
        return VersionSpecComparisons.compareTo(this, other);
    }

    @Override
    public boolean isRelease() {
        return !this.isSnapshot();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SingleVersion: [");
        for (VersionPhrase phrase : this.phrases) {
            sb.append(phrase).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("] (").append(this.renderStandard()).append(")");
        return sb.toString();
    }

    @Override
    public boolean isSnapshot() {
        VersionPhrase last = this.phrases.get(this.phrases.size() - 1);
        return last.isSnapshot();
    }

    public boolean isLocalSnapshot() {
        VersionPart lastPart = this.getLastPart();
        if (lastPart instanceof SnapshotPart) {
            SnapshotPart part = (SnapshotPart)lastPart;
            return part.isLocalSnapshot();
        }
        return false;
    }

    private VersionPart getLastPart() {
        List<VersionPart> parts;
        int idx = this.phrases.size();
        do {
            VersionPhrase last = this.phrases.get(--idx);
            parts = last.getVersionParts();
        } while (idx > 0 && parts.isEmpty());
        return parts == null || parts.isEmpty() ? null : parts.get(parts.size() - 1);
    }

    @Override
    public boolean isConcrete() {
        return this.isRelease() || !this.isLocalSnapshot();
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public SingleVersion getConcreteVersion() {
        return this.isConcrete() ? this : null;
    }

    @Override
    public SingleVersion getSingleVersion() {
        return this.isSingle() ? this : null;
    }

    public List<VersionPhrase> getVersionPhrases() {
        return this.phrases;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.phrases != null) {
            for (VersionPhrase phrase : this.phrases) {
                if (phrase.isSilent()) continue;
                result += phrase.hashCode();
            }
        }
        return 31 * result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleVersion other = (SingleVersion)obj;
        if (this.phrases == null) {
            if (other.phrases != null) {
                return false;
            }
        } else {
            VersionPhrase theirs;
            int i;
            for (i = 0; i < Math.min(this.phrases.size(), other.phrases.size()); ++i) {
                VersionPhrase mine = this.phrases.get(i);
                theirs = other.phrases.get(i);
                if (mine.isSilent() != theirs.isSilent()) {
                    return false;
                }
                if (mine.isSilent() || theirs.isSilent() || mine.equals(theirs)) continue;
                return false;
            }
            if (i < this.phrases.size()) {
                for (int j = i; j < this.phrases.size(); ++j) {
                    VersionPhrase mine = this.phrases.get(j);
                    if (mine.isSilent()) continue;
                    return false;
                }
            }
            if (i < other.phrases.size()) {
                for (int j = i; j < other.phrases.size(); ++j) {
                    theirs = other.phrases.get(j);
                    if (theirs.isSilent()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public SnapshotPart getSnapshotPart() {
        return this.isSnapshot() ? (SnapshotPart)this.getLastPart() : null;
    }
}

